/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource.rtmp;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaLibraryInfo;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.BaseDataSource;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.TransferListener;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.antmedia.rtmp_client.RtmpClient;
import java.io.IOException;

@UnstableApi
public final class RtmpDataSource
extends BaseDataSource {
    @Nullable
    private RtmpClient rtmpClient;
    @Nullable
    private Uri uri;

    public RtmpDataSource() {
        super(true);
    }

    public long open(DataSpec dataSpec) throws RtmpClient.RtmpIOException {
        this.transferInitializing(dataSpec);
        this.rtmpClient = new RtmpClient();
        this.rtmpClient.open(dataSpec.uri.toString(), false);
        this.uri = dataSpec.uri;
        this.transferStarted(dataSpec);
        return -1L;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead = ((RtmpClient)Util.castNonNull((Object)this.rtmpClient)).read(buffer, offset, length);
        if (bytesRead == -1) {
            return -1;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    public void close() {
        if (this.uri != null) {
            this.uri = null;
            this.transferEnded();
        }
        if (this.rtmpClient != null) {
            this.rtmpClient.close();
            this.rtmpClient = null;
        }
    }

    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    static {
        MediaLibraryInfo.registerModule((String)"media3.datasource.rtmp");
    }

    public static final class Factory
    implements DataSource.Factory {
        @Nullable
        private TransferListener transferListener;

        @CanIgnoreReturnValue
        public Factory setTransferListener(@Nullable TransferListener transferListener) {
            this.transferListener = transferListener;
            return this;
        }

        public RtmpDataSource createDataSource() {
            RtmpDataSource dataSource = new RtmpDataSource();
            if (this.transferListener != null) {
                dataSource.addTransferListener(this.transferListener);
            }
            return dataSource;
        }
    }
}

