/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UnstableApi
public final class HttpUtil {
    private static final String TAG = "HttpUtil";
    private static final Pattern CONTENT_RANGE_WITH_START_AND_END = Pattern.compile("bytes (\\d+)-(\\d+)/(?:\\d+|\\*)");
    private static final Pattern CONTENT_RANGE_WITH_SIZE = Pattern.compile("bytes (?:(?:\\d+-\\d+)|\\*)/(\\d+)");

    private HttpUtil() {
    }

    @Nullable
    public static String buildRangeRequestHeader(long position, long length) {
        if (position == 0L && length == -1L) {
            return null;
        }
        StringBuilder rangeValue = new StringBuilder();
        rangeValue.append("bytes=");
        rangeValue.append(position);
        rangeValue.append("-");
        if (length != -1L) {
            rangeValue.append(position + length - 1L);
        }
        return rangeValue.toString();
    }

    public static long getDocumentSize(@Nullable String contentRangeHeader) {
        if (TextUtils.isEmpty((CharSequence)contentRangeHeader)) {
            return -1L;
        }
        Matcher matcher = CONTENT_RANGE_WITH_SIZE.matcher(contentRangeHeader);
        return matcher.matches() ? Long.parseLong((String)Assertions.checkNotNull((Object)matcher.group(1))) : -1L;
    }

    public static long getContentLength(@Nullable String contentLengthHeader, @Nullable String contentRangeHeader) {
        Matcher matcher;
        long contentLength = -1L;
        if (!TextUtils.isEmpty((CharSequence)contentLengthHeader)) {
            try {
                contentLength = Long.parseLong(contentLengthHeader);
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)("Unexpected Content-Length [" + contentLengthHeader + "]"));
            }
        }
        if (!TextUtils.isEmpty((CharSequence)contentRangeHeader) && (matcher = CONTENT_RANGE_WITH_START_AND_END.matcher(contentRangeHeader)).matches()) {
            try {
                long contentLengthFromRange = Long.parseLong((String)Assertions.checkNotNull((Object)matcher.group(2))) - Long.parseLong((String)Assertions.checkNotNull((Object)matcher.group(1))) + 1L;
                if (contentLength < 0L) {
                    contentLength = contentLengthFromRange;
                } else if (contentLength != contentLengthFromRange) {
                    Log.w((String)TAG, (String)("Inconsistent headers [" + contentLengthHeader + "] [" + contentRangeHeader + "]"));
                    contentLength = Math.max(contentLength, contentLengthFromRange);
                }
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)("Unexpected Content-Range [" + contentRangeHeader + "]"));
            }
        }
        return contentLength;
    }
}

