/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource.cache;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.cache.CacheSpan;
import androidx.media3.datasource.cache.CachedContentIndex;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SimpleCacheSpan
extends CacheSpan {
    static final String COMMON_SUFFIX = ".exo";
    private static final String SUFFIX = ".v3.exo";
    private static final Pattern CACHE_FILE_PATTERN_V1 = Pattern.compile("^(.+)\\.(\\d+)\\.(\\d+)\\.v1\\.exo$", 32);
    private static final Pattern CACHE_FILE_PATTERN_V2 = Pattern.compile("^(.+)\\.(\\d+)\\.(\\d+)\\.v2\\.exo$", 32);
    private static final Pattern CACHE_FILE_PATTERN_V3 = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.v3\\.exo$", 32);

    public static File getCacheFile(File cacheDir, int id, long position, long timestamp) {
        return new File(cacheDir, id + "." + position + "." + timestamp + SUFFIX);
    }

    public static SimpleCacheSpan createLookup(String key, long position) {
        return new SimpleCacheSpan(key, position, -1L, -9223372036854775807L, null);
    }

    public static SimpleCacheSpan createHole(String key, long position, long length) {
        return new SimpleCacheSpan(key, position, length, -9223372036854775807L, null);
    }

    @Nullable
    public static SimpleCacheSpan createCacheEntry(File file, long length, CachedContentIndex index) {
        return SimpleCacheSpan.createCacheEntry(file, length, -9223372036854775807L, index);
    }

    @Nullable
    public static SimpleCacheSpan createCacheEntry(File file, long length, long lastTouchTimestamp, CachedContentIndex index) {
        Matcher matcher;
        String name = file.getName();
        if (!name.endsWith(SUFFIX)) {
            File upgradedFile = SimpleCacheSpan.upgradeFile(file, index);
            if (upgradedFile == null) {
                return null;
            }
            file = upgradedFile;
            name = file.getName();
        }
        if (!(matcher = CACHE_FILE_PATTERN_V3.matcher(name)).matches()) {
            return null;
        }
        int id = Integer.parseInt((String)Assertions.checkNotNull((Object)matcher.group(1)));
        String key = index.getKeyForId(id);
        if (key == null) {
            return null;
        }
        if (length == -1L) {
            length = file.length();
        }
        if (length == 0L) {
            return null;
        }
        long position = Long.parseLong((String)Assertions.checkNotNull((Object)matcher.group(2)));
        if (lastTouchTimestamp == -9223372036854775807L) {
            lastTouchTimestamp = Long.parseLong((String)Assertions.checkNotNull((Object)matcher.group(3)));
        }
        return new SimpleCacheSpan(key, position, length, lastTouchTimestamp, file);
    }

    @Nullable
    private static File upgradeFile(File file, CachedContentIndex index) {
        String key = null;
        String filename = file.getName();
        Matcher matcher = CACHE_FILE_PATTERN_V2.matcher(filename);
        if (matcher.matches()) {
            key = Util.unescapeFileName((String)((String)Assertions.checkNotNull((Object)matcher.group(1))));
        } else {
            matcher = CACHE_FILE_PATTERN_V1.matcher(filename);
            if (matcher.matches()) {
                key = (String)Assertions.checkNotNull((Object)matcher.group(1));
            }
        }
        if (key == null) {
            return null;
        }
        File newCacheFile = SimpleCacheSpan.getCacheFile((File)Assertions.checkStateNotNull((Object)file.getParentFile()), index.assignIdForKey(key), Long.parseLong((String)Assertions.checkNotNull((Object)matcher.group(2))), Long.parseLong((String)Assertions.checkNotNull((Object)matcher.group(3))));
        if (!file.renameTo(newCacheFile)) {
            return null;
        }
        return newCacheFile;
    }

    private SimpleCacheSpan(String key, long position, long length, long lastTouchTimestamp, @Nullable File file) {
        super(key, position, length, lastTouchTimestamp, file);
    }

    public SimpleCacheSpan copyWithFileAndLastTouchTimestamp(File file, long lastTouchTimestamp) {
        Assertions.checkState((boolean)this.isCached);
        return new SimpleCacheSpan(this.key, this.position, this.length, lastTouchTimestamp, file);
    }
}

