/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.audio;

import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.extractor.OpusUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@UnstableApi
public final class OggOpusAudioPacketizer {
    private static final int FIRST_AUDIO_SAMPLE_PAGE_SEQUENCE = 2;
    private ByteBuffer outputBuffer = AudioProcessor.EMPTY_BUFFER;
    private int pageSequenceNumber = 2;
    private int granulePosition = 0;

    public void packetize(DecoderInputBuffer inputBuffer) {
        Assertions.checkNotNull((Object)inputBuffer.data);
        if (inputBuffer.data.limit() - inputBuffer.data.position() == 0) {
            return;
        }
        this.outputBuffer = this.packetizeInternal(inputBuffer.data);
        inputBuffer.clear();
        inputBuffer.ensureSpaceForWrite(this.outputBuffer.remaining());
        inputBuffer.data.put(this.outputBuffer);
        inputBuffer.flip();
    }

    public void reset() {
        this.outputBuffer = AudioProcessor.EMPTY_BUFFER;
        this.granulePosition = 0;
        this.pageSequenceNumber = 2;
    }

    private ByteBuffer packetizeInternal(ByteBuffer inputBuffer) {
        int i;
        int position = inputBuffer.position();
        int limit = inputBuffer.limit();
        int inputBufferSize = limit - position;
        int numSegments = (inputBufferSize + 255) / 255;
        int headerSize = 27 + numSegments;
        int outputPacketSize = headerSize + inputBufferSize;
        ByteBuffer buffer = this.replaceOutputBuffer(outputPacketSize);
        buffer.put((byte)79);
        buffer.put((byte)103);
        buffer.put((byte)103);
        buffer.put((byte)83);
        buffer.put((byte)0);
        buffer.put((byte)0);
        int numSamples = OpusUtil.parsePacketAudioSampleCount((ByteBuffer)inputBuffer);
        this.granulePosition += numSamples;
        buffer.putLong(this.granulePosition);
        buffer.putInt(0);
        buffer.putInt(this.pageSequenceNumber);
        ++this.pageSequenceNumber;
        buffer.putInt(0);
        buffer.put((byte)numSegments);
        int bytesLeft = inputBufferSize;
        for (i = 0; i < numSegments; ++i) {
            if (bytesLeft >= 255) {
                buffer.put((byte)-1);
                bytesLeft -= 255;
                continue;
            }
            buffer.put((byte)bytesLeft);
            bytesLeft = 0;
        }
        for (i = position; i < limit; ++i) {
            buffer.put(inputBuffer.get(i));
        }
        inputBuffer.position(inputBuffer.limit());
        buffer.flip();
        int checksum = Util.crc32((byte[])buffer.array(), (int)buffer.arrayOffset(), (int)(buffer.limit() - buffer.position()), (int)0);
        buffer.putInt(22, checksum);
        buffer.position(0);
        return buffer;
    }

    private ByteBuffer replaceOutputBuffer(int size) {
        if (this.outputBuffer.capacity() < size) {
            this.outputBuffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.outputBuffer.clear();
        }
        return this.outputBuffer;
    }
}

