/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.drm;

import android.os.Handler;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.source.MediaSource;
import java.util.concurrent.CopyOnWriteArrayList;

@UnstableApi
public interface DrmSessionEventListener {
    @Deprecated
    default public void onDrmSessionAcquired(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
    }

    default public void onDrmSessionAcquired(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, int state) {
    }

    default public void onDrmKeysLoaded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
    }

    default public void onDrmSessionManagerError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, Exception error) {
    }

    default public void onDrmKeysRestored(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
    }

    default public void onDrmKeysRemoved(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
    }

    default public void onDrmSessionReleased(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
    }

    public static class EventDispatcher {
        public final int windowIndex;
        @Nullable
        public final MediaSource.MediaPeriodId mediaPeriodId;
        private final CopyOnWriteArrayList<ListenerAndHandler> listenerAndHandlers;

        public EventDispatcher() {
            this(new CopyOnWriteArrayList<ListenerAndHandler>(), 0, null);
        }

        private EventDispatcher(CopyOnWriteArrayList<ListenerAndHandler> listenerAndHandlers, int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
            this.listenerAndHandlers = listenerAndHandlers;
            this.windowIndex = windowIndex;
            this.mediaPeriodId = mediaPeriodId;
        }

        @CheckResult
        public EventDispatcher withParameters(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
            return new EventDispatcher(this.listenerAndHandlers, windowIndex, mediaPeriodId);
        }

        public void addEventListener(Handler handler, DrmSessionEventListener eventListener) {
            Assertions.checkNotNull((Object)handler);
            Assertions.checkNotNull((Object)eventListener);
            this.listenerAndHandlers.add(new ListenerAndHandler(handler, eventListener));
        }

        public void removeEventListener(DrmSessionEventListener eventListener) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                if (listenerAndHandler.listener != eventListener) continue;
                this.listenerAndHandlers.remove(listenerAndHandler);
            }
        }

        public void drmSessionAcquired(int state) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                DrmSessionEventListener listener = listenerAndHandler.listener;
                Util.postOrRun((Handler)listenerAndHandler.handler, () -> {
                    listener.onDrmSessionAcquired(this.windowIndex, this.mediaPeriodId);
                    listener.onDrmSessionAcquired(this.windowIndex, this.mediaPeriodId, state);
                });
            }
        }

        public void drmKeysLoaded() {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                DrmSessionEventListener listener = listenerAndHandler.listener;
                Util.postOrRun((Handler)listenerAndHandler.handler, () -> listener.onDrmKeysLoaded(this.windowIndex, this.mediaPeriodId));
            }
        }

        public void drmSessionManagerError(Exception error) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                DrmSessionEventListener listener = listenerAndHandler.listener;
                Util.postOrRun((Handler)listenerAndHandler.handler, () -> listener.onDrmSessionManagerError(this.windowIndex, this.mediaPeriodId, error));
            }
        }

        public void drmKeysRestored() {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                DrmSessionEventListener listener = listenerAndHandler.listener;
                Util.postOrRun((Handler)listenerAndHandler.handler, () -> listener.onDrmKeysRestored(this.windowIndex, this.mediaPeriodId));
            }
        }

        public void drmKeysRemoved() {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                DrmSessionEventListener listener = listenerAndHandler.listener;
                Util.postOrRun((Handler)listenerAndHandler.handler, () -> listener.onDrmKeysRemoved(this.windowIndex, this.mediaPeriodId));
            }
        }

        public void drmSessionReleased() {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                DrmSessionEventListener listener = listenerAndHandler.listener;
                Util.postOrRun((Handler)listenerAndHandler.handler, () -> listener.onDrmSessionReleased(this.windowIndex, this.mediaPeriodId));
            }
        }

        private static final class ListenerAndHandler {
            public Handler handler;
            public DrmSessionEventListener listener;

            public ListenerAndHandler(Handler handler, DrmSessionEventListener listener) {
                this.handler = handler;
                this.listener = listener;
            }
        }
    }
}

