/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.offline;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.CheckResult;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.database.DatabaseProvider;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.cache.Cache;
import androidx.media3.datasource.cache.CacheDataSource;
import androidx.media3.exoplayer.offline.DefaultDownloadIndex;
import androidx.media3.exoplayer.offline.DefaultDownloaderFactory;
import androidx.media3.exoplayer.offline.Download;
import androidx.media3.exoplayer.offline.DownloadCursor;
import androidx.media3.exoplayer.offline.DownloadIndex;
import androidx.media3.exoplayer.offline.DownloadProgress;
import androidx.media3.exoplayer.offline.DownloadRequest;
import androidx.media3.exoplayer.offline.Downloader;
import androidx.media3.exoplayer.offline.DownloaderFactory;
import androidx.media3.exoplayer.offline.WritableDownloadIndex;
import androidx.media3.exoplayer.scheduler.Requirements;
import androidx.media3.exoplayer.scheduler.RequirementsWatcher;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;

@UnstableApi
public final class DownloadManager {
    public static final int DEFAULT_MAX_PARALLEL_DOWNLOADS = 3;
    public static final int DEFAULT_MIN_RETRY_COUNT = 5;
    public static final Requirements DEFAULT_REQUIREMENTS = new Requirements(1);
    private static final int MSG_INITIALIZED = 0;
    private static final int MSG_PROCESSED = 1;
    private static final int MSG_DOWNLOAD_UPDATE = 2;
    private static final int MSG_INITIALIZE = 0;
    private static final int MSG_SET_DOWNLOADS_PAUSED = 1;
    private static final int MSG_SET_NOT_MET_REQUIREMENTS = 2;
    private static final int MSG_SET_STOP_REASON = 3;
    private static final int MSG_SET_MAX_PARALLEL_DOWNLOADS = 4;
    private static final int MSG_SET_MIN_RETRY_COUNT = 5;
    private static final int MSG_ADD_DOWNLOAD = 6;
    private static final int MSG_REMOVE_DOWNLOAD = 7;
    private static final int MSG_REMOVE_ALL_DOWNLOADS = 8;
    private static final int MSG_TASK_STOPPED = 9;
    private static final int MSG_CONTENT_LENGTH_CHANGED = 10;
    private static final int MSG_UPDATE_PROGRESS = 11;
    private static final int MSG_RELEASE = 12;
    private static final String TAG = "DownloadManager";
    private final Context context;
    private final WritableDownloadIndex downloadIndex;
    private final Handler applicationHandler;
    private final InternalHandler internalHandler;
    private final RequirementsWatcher.Listener requirementsListener;
    private final CopyOnWriteArraySet<Listener> listeners;
    private int pendingMessages;
    private int activeTaskCount;
    private boolean initialized;
    private boolean downloadsPaused;
    private int maxParallelDownloads;
    private int minRetryCount;
    private int notMetRequirements;
    private boolean waitingForRequirements;
    private List<Download> downloads;
    private RequirementsWatcher requirementsWatcher;

    public DownloadManager(Context context, DatabaseProvider databaseProvider, Cache cache, DataSource.Factory upstreamFactory, Executor executor) {
        this(context, new DefaultDownloadIndex(databaseProvider), new DefaultDownloaderFactory(new CacheDataSource.Factory().setCache(cache).setUpstreamDataSourceFactory(upstreamFactory), executor));
    }

    public DownloadManager(Context context, WritableDownloadIndex downloadIndex, DownloaderFactory downloaderFactory) {
        RequirementsWatcher.Listener requirementsListener;
        Handler mainHandler;
        this.context = context.getApplicationContext();
        this.downloadIndex = downloadIndex;
        this.maxParallelDownloads = 3;
        this.minRetryCount = 5;
        this.downloadsPaused = true;
        this.downloads = Collections.emptyList();
        this.listeners = new CopyOnWriteArraySet();
        this.applicationHandler = mainHandler = Util.createHandlerForCurrentOrMainLooper(this::handleMainMessage);
        HandlerThread internalThread = new HandlerThread("ExoPlayer:DownloadManager");
        internalThread.start();
        this.internalHandler = new InternalHandler(internalThread, downloadIndex, downloaderFactory, mainHandler, this.maxParallelDownloads, this.minRetryCount, this.downloadsPaused);
        this.requirementsListener = requirementsListener = this::onRequirementsStateChanged;
        this.requirementsWatcher = new RequirementsWatcher(context, requirementsListener, DEFAULT_REQUIREMENTS);
        this.notMetRequirements = this.requirementsWatcher.start();
        this.pendingMessages = 1;
        this.internalHandler.obtainMessage(0, this.notMetRequirements, 0).sendToTarget();
    }

    public Looper getApplicationLooper() {
        return this.applicationHandler.getLooper();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isIdle() {
        return this.activeTaskCount == 0 && this.pendingMessages == 0;
    }

    public boolean isWaitingForRequirements() {
        return this.waitingForRequirements;
    }

    public void addListener(Listener listener) {
        Assertions.checkNotNull((Object)listener);
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public Requirements getRequirements() {
        return this.requirementsWatcher.getRequirements();
    }

    public int getNotMetRequirements() {
        return this.notMetRequirements;
    }

    public void setRequirements(Requirements requirements) {
        if (requirements.equals(this.requirementsWatcher.getRequirements())) {
            return;
        }
        this.requirementsWatcher.stop();
        this.requirementsWatcher = new RequirementsWatcher(this.context, this.requirementsListener, requirements);
        int notMetRequirements = this.requirementsWatcher.start();
        this.onRequirementsStateChanged(this.requirementsWatcher, notMetRequirements);
    }

    public int getMaxParallelDownloads() {
        return this.maxParallelDownloads;
    }

    public void setMaxParallelDownloads(@IntRange(from=1L) int maxParallelDownloads) {
        Assertions.checkArgument((maxParallelDownloads > 0 ? 1 : 0) != 0);
        if (this.maxParallelDownloads == maxParallelDownloads) {
            return;
        }
        this.maxParallelDownloads = maxParallelDownloads;
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(4, maxParallelDownloads, 0).sendToTarget();
    }

    public int getMinRetryCount() {
        return this.minRetryCount;
    }

    public void setMinRetryCount(int minRetryCount) {
        Assertions.checkArgument((minRetryCount >= 0 ? 1 : 0) != 0);
        if (this.minRetryCount == minRetryCount) {
            return;
        }
        this.minRetryCount = minRetryCount;
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(5, minRetryCount, 0).sendToTarget();
    }

    public DownloadIndex getDownloadIndex() {
        return this.downloadIndex;
    }

    public List<Download> getCurrentDownloads() {
        return this.downloads;
    }

    public boolean getDownloadsPaused() {
        return this.downloadsPaused;
    }

    public void resumeDownloads() {
        this.setDownloadsPaused(false);
    }

    public void pauseDownloads() {
        this.setDownloadsPaused(true);
    }

    public void setStopReason(@Nullable String id, int stopReason) {
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(3, stopReason, 0, id).sendToTarget();
    }

    public void addDownload(DownloadRequest request) {
        this.addDownload(request, 0);
    }

    public void addDownload(DownloadRequest request, int stopReason) {
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(6, stopReason, 0, request).sendToTarget();
    }

    public void removeDownload(String id) {
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(7, id).sendToTarget();
    }

    public void removeAllDownloads() {
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(8).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        InternalHandler internalHandler = this.internalHandler;
        synchronized (internalHandler) {
            if (this.internalHandler.released) {
                return;
            }
            this.internalHandler.sendEmptyMessage(12);
            boolean wasInterrupted = false;
            while (!this.internalHandler.released) {
                try {
                    ((Object)((Object)this.internalHandler)).wait();
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            this.applicationHandler.removeCallbacksAndMessages(null);
            this.requirementsWatcher.stop();
            this.downloads = Collections.emptyList();
            this.pendingMessages = 0;
            this.activeTaskCount = 0;
            this.initialized = false;
            this.notMetRequirements = 0;
            this.waitingForRequirements = false;
        }
    }

    private void setDownloadsPaused(boolean downloadsPaused) {
        if (this.downloadsPaused == downloadsPaused) {
            return;
        }
        this.downloadsPaused = downloadsPaused;
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(1, downloadsPaused ? 1 : 0, 0).sendToTarget();
        boolean waitingForRequirementsChanged = this.updateWaitingForRequirements();
        for (Listener listener : this.listeners) {
            listener.onDownloadsPausedChanged(this, downloadsPaused);
        }
        if (waitingForRequirementsChanged) {
            this.notifyWaitingForRequirementsChanged();
        }
    }

    private void onRequirementsStateChanged(RequirementsWatcher requirementsWatcher, int notMetRequirements) {
        Requirements requirements = requirementsWatcher.getRequirements();
        if (this.notMetRequirements != notMetRequirements) {
            this.notMetRequirements = notMetRequirements;
            ++this.pendingMessages;
            this.internalHandler.obtainMessage(2, notMetRequirements, 0).sendToTarget();
        }
        boolean waitingForRequirementsChanged = this.updateWaitingForRequirements();
        for (Listener listener : this.listeners) {
            listener.onRequirementsStateChanged(this, requirements, notMetRequirements);
        }
        if (waitingForRequirementsChanged) {
            this.notifyWaitingForRequirementsChanged();
        }
    }

    private boolean updateWaitingForRequirements() {
        boolean waitingForRequirements = false;
        if (!this.downloadsPaused && this.notMetRequirements != 0) {
            for (int i = 0; i < this.downloads.size(); ++i) {
                if (this.downloads.get((int)i).state != 0) continue;
                waitingForRequirements = true;
                break;
            }
        }
        boolean waitingForRequirementsChanged = this.waitingForRequirements != waitingForRequirements;
        this.waitingForRequirements = waitingForRequirements;
        return waitingForRequirementsChanged;
    }

    private void notifyWaitingForRequirementsChanged() {
        for (Listener listener : this.listeners) {
            listener.onWaitingForRequirementsChanged(this, this.waitingForRequirements);
        }
    }

    private boolean handleMainMessage(Message message) {
        switch (message.what) {
            case 0: {
                List downloads = (List)message.obj;
                this.onInitialized(downloads);
                break;
            }
            case 2: {
                DownloadUpdate update = (DownloadUpdate)message.obj;
                this.onDownloadUpdate(update);
                break;
            }
            case 1: {
                int processedMessageCount = message.arg1;
                int activeTaskCount = message.arg2;
                this.onMessageProcessed(processedMessageCount, activeTaskCount);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    private void onInitialized(List<Download> downloads) {
        this.initialized = true;
        this.downloads = Collections.unmodifiableList(downloads);
        boolean waitingForRequirementsChanged = this.updateWaitingForRequirements();
        for (Listener listener : this.listeners) {
            listener.onInitialized(this);
        }
        if (waitingForRequirementsChanged) {
            this.notifyWaitingForRequirementsChanged();
        }
    }

    private void onDownloadUpdate(DownloadUpdate update) {
        this.downloads = Collections.unmodifiableList(update.downloads);
        Download updatedDownload = update.download;
        boolean waitingForRequirementsChanged = this.updateWaitingForRequirements();
        if (update.isRemove) {
            for (Listener listener : this.listeners) {
                listener.onDownloadRemoved(this, updatedDownload);
            }
        } else {
            for (Listener listener : this.listeners) {
                listener.onDownloadChanged(this, updatedDownload, update.finalException);
            }
        }
        if (waitingForRequirementsChanged) {
            this.notifyWaitingForRequirementsChanged();
        }
    }

    private void onMessageProcessed(int processedMessageCount, int activeTaskCount) {
        this.pendingMessages -= processedMessageCount;
        this.activeTaskCount = activeTaskCount;
        if (this.isIdle()) {
            for (Listener listener : this.listeners) {
                listener.onIdle(this);
            }
        }
    }

    static Download mergeRequest(Download download, DownloadRequest request, int stopReason, long nowMs) {
        long startTimeMs;
        int state = download.state;
        long l = startTimeMs = state == 5 || download.isTerminalState() ? nowMs : download.startTimeMs;
        state = state == 5 || state == 7 ? 7 : (stopReason != 0 ? 1 : 0);
        return new Download(download.request.copyWithMergedRequest(request), state, startTimeMs, nowMs, -1L, stopReason, 0);
    }

    private static final class DownloadUpdate {
        public final Download download;
        public final boolean isRemove;
        public final List<Download> downloads;
        @Nullable
        public final Exception finalException;

        public DownloadUpdate(Download download, boolean isRemove, List<Download> downloads, @Nullable Exception finalException) {
            this.download = download;
            this.isRemove = isRemove;
            this.downloads = downloads;
            this.finalException = finalException;
        }
    }

    private static class Task
    extends Thread
    implements Downloader.ProgressListener {
        private final DownloadRequest request;
        private final Downloader downloader;
        private final DownloadProgress downloadProgress;
        private final boolean isRemove;
        private final int minRetryCount;
        @Nullable
        private volatile InternalHandler internalHandler;
        private volatile boolean isCanceled;
        @Nullable
        private Exception finalException;
        private long contentLength;

        private Task(DownloadRequest request, Downloader downloader, DownloadProgress downloadProgress, boolean isRemove, int minRetryCount, InternalHandler internalHandler) {
            this.request = request;
            this.downloader = downloader;
            this.downloadProgress = downloadProgress;
            this.isRemove = isRemove;
            this.minRetryCount = minRetryCount;
            this.internalHandler = internalHandler;
            this.contentLength = -1L;
        }

        public void cancel(boolean released) {
            if (released) {
                this.internalHandler = null;
            }
            if (!this.isCanceled) {
                this.isCanceled = true;
                this.downloader.cancel();
                this.interrupt();
            }
        }

        @Override
        public void run() {
            block10: {
                try {
                    if (this.isRemove) {
                        this.downloader.remove();
                        break block10;
                    }
                    int errorCount = 0;
                    long errorPosition = -1L;
                    while (!this.isCanceled) {
                        try {
                            this.downloader.download(this);
                            break;
                        }
                        catch (IOException e) {
                            if (this.isCanceled) continue;
                            long bytesDownloaded = this.downloadProgress.bytesDownloaded;
                            if (bytesDownloaded != errorPosition) {
                                errorPosition = bytesDownloaded;
                                errorCount = 0;
                            }
                            if (++errorCount > this.minRetryCount) {
                                throw e;
                            }
                            Thread.sleep(Task.getRetryDelayMillis(errorCount));
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    this.finalException = e;
                }
            }
            InternalHandler internalHandler = this.internalHandler;
            if (internalHandler != null) {
                internalHandler.obtainMessage(9, this).sendToTarget();
            }
        }

        @Override
        public void onProgress(long contentLength, long bytesDownloaded, float percentDownloaded) {
            this.downloadProgress.bytesDownloaded = bytesDownloaded;
            this.downloadProgress.percentDownloaded = percentDownloaded;
            if (contentLength != this.contentLength) {
                this.contentLength = contentLength;
                InternalHandler internalHandler = this.internalHandler;
                if (internalHandler != null) {
                    internalHandler.obtainMessage(10, (int)(contentLength >> 32), (int)contentLength, this).sendToTarget();
                }
            }
        }

        private static int getRetryDelayMillis(int errorCount) {
            return Math.min((errorCount - 1) * 1000, 5000);
        }
    }

    private static final class InternalHandler
    extends Handler {
        private static final int UPDATE_PROGRESS_INTERVAL_MS = 5000;
        public boolean released;
        private final HandlerThread thread;
        private final WritableDownloadIndex downloadIndex;
        private final DownloaderFactory downloaderFactory;
        private final Handler mainHandler;
        private final ArrayList<Download> downloads;
        private final HashMap<String, Task> activeTasks;
        private int notMetRequirements;
        private boolean downloadsPaused;
        private int maxParallelDownloads;
        private int minRetryCount;
        private int activeDownloadTaskCount;
        private boolean hasActiveRemoveTask;

        public InternalHandler(HandlerThread thread, WritableDownloadIndex downloadIndex, DownloaderFactory downloaderFactory, Handler mainHandler, int maxParallelDownloads, int minRetryCount, boolean downloadsPaused) {
            super(thread.getLooper());
            this.thread = thread;
            this.downloadIndex = downloadIndex;
            this.downloaderFactory = downloaderFactory;
            this.mainHandler = mainHandler;
            this.maxParallelDownloads = maxParallelDownloads;
            this.minRetryCount = minRetryCount;
            this.downloadsPaused = downloadsPaused;
            this.downloads = new ArrayList();
            this.activeTasks = new HashMap();
        }

        public void handleMessage(Message message) {
            boolean processedExternalMessage = true;
            switch (message.what) {
                case 0: {
                    int notMetRequirements = message.arg1;
                    this.initialize(notMetRequirements);
                    break;
                }
                case 1: {
                    boolean downloadsPaused = message.arg1 != 0;
                    this.setDownloadsPaused(downloadsPaused);
                    break;
                }
                case 2: {
                    int notMetRequirements = message.arg1;
                    this.setNotMetRequirements(notMetRequirements);
                    break;
                }
                case 3: {
                    String id = (String)message.obj;
                    int stopReason = message.arg1;
                    this.setStopReason(id, stopReason);
                    break;
                }
                case 4: {
                    int maxParallelDownloads = message.arg1;
                    this.setMaxParallelDownloads(maxParallelDownloads);
                    break;
                }
                case 5: {
                    int minRetryCount = message.arg1;
                    this.setMinRetryCount(minRetryCount);
                    break;
                }
                case 6: {
                    DownloadRequest request = (DownloadRequest)message.obj;
                    int stopReason = message.arg1;
                    this.addDownload(request, stopReason);
                    break;
                }
                case 7: {
                    String id = (String)message.obj;
                    this.removeDownload(id);
                    break;
                }
                case 8: {
                    this.removeAllDownloads();
                    break;
                }
                case 9: {
                    Task task = (Task)message.obj;
                    this.onTaskStopped(task);
                    processedExternalMessage = false;
                    break;
                }
                case 10: {
                    Task task = (Task)message.obj;
                    this.onContentLengthChanged(task, Util.toLong((int)message.arg1, (int)message.arg2));
                    return;
                }
                case 11: {
                    this.updateProgress();
                    return;
                }
                case 12: {
                    this.release();
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.mainHandler.obtainMessage(1, processedExternalMessage ? 1 : 0, this.activeTasks.size()).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize(int notMetRequirements) {
            this.notMetRequirements = notMetRequirements;
            DownloadCursor cursor = null;
            try {
                this.downloadIndex.setDownloadingStatesToQueued();
                cursor = this.downloadIndex.getDownloads(0, 1, 2, 5, 7);
                while (cursor.moveToNext()) {
                    this.downloads.add(cursor.getDownload());
                }
                Util.closeQuietly((Closeable)cursor);
            }
            catch (IOException e) {
                Log.e((String)DownloadManager.TAG, (String)"Failed to load index.", (Throwable)e);
                this.downloads.clear();
            }
            finally {
                Util.closeQuietly(cursor);
            }
            ArrayList<Download> downloadsForMessage = new ArrayList<Download>(this.downloads);
            this.mainHandler.obtainMessage(0, downloadsForMessage).sendToTarget();
            this.syncTasks();
        }

        private void setDownloadsPaused(boolean downloadsPaused) {
            this.downloadsPaused = downloadsPaused;
            this.syncTasks();
        }

        private void setNotMetRequirements(int notMetRequirements) {
            this.notMetRequirements = notMetRequirements;
            this.syncTasks();
        }

        private void setStopReason(@Nullable String id, int stopReason) {
            if (id == null) {
                for (int i = 0; i < this.downloads.size(); ++i) {
                    this.setStopReason(this.downloads.get(i), stopReason);
                }
                try {
                    this.downloadIndex.setStopReason(stopReason);
                }
                catch (IOException e) {
                    Log.e((String)DownloadManager.TAG, (String)"Failed to set manual stop reason", (Throwable)e);
                }
            } else {
                Download download = this.getDownload(id, false);
                if (download != null) {
                    this.setStopReason(download, stopReason);
                } else {
                    try {
                        this.downloadIndex.setStopReason(id, stopReason);
                    }
                    catch (IOException e) {
                        Log.e((String)DownloadManager.TAG, (String)("Failed to set manual stop reason: " + id), (Throwable)e);
                    }
                }
            }
            this.syncTasks();
        }

        private void setStopReason(Download download, int stopReason) {
            if (stopReason == 0) {
                if (download.state == 1) {
                    this.putDownloadWithState(download, 0, 0);
                }
            } else if (stopReason != download.stopReason) {
                int state = download.state;
                if (state == 0 || state == 2) {
                    state = 1;
                }
                this.putDownload(new Download(download.request, state, download.startTimeMs, System.currentTimeMillis(), download.contentLength, stopReason, 0, download.progress));
            }
        }

        private void setMaxParallelDownloads(int maxParallelDownloads) {
            this.maxParallelDownloads = maxParallelDownloads;
            this.syncTasks();
        }

        private void setMinRetryCount(int minRetryCount) {
            this.minRetryCount = minRetryCount;
        }

        private void addDownload(DownloadRequest request, int stopReason) {
            Download download = this.getDownload(request.id, true);
            long nowMs = System.currentTimeMillis();
            if (download != null) {
                this.putDownload(DownloadManager.mergeRequest(download, request, stopReason, nowMs));
            } else {
                this.putDownload(new Download(request, stopReason != 0 ? 1 : 0, nowMs, nowMs, -1L, stopReason, 0));
            }
            this.syncTasks();
        }

        private void removeDownload(String id) {
            Download download = this.getDownload(id, true);
            if (download == null) {
                Log.e((String)DownloadManager.TAG, (String)("Failed to remove nonexistent download: " + id));
                return;
            }
            this.putDownloadWithState(download, 5, 0);
            this.syncTasks();
        }

        private void removeAllDownloads() {
            int i;
            ArrayList<Download> terminalDownloads = new ArrayList<Download>();
            try (DownloadCursor cursor = this.downloadIndex.getDownloads(3, 4);){
                while (cursor.moveToNext()) {
                    terminalDownloads.add(cursor.getDownload());
                }
            }
            catch (IOException e) {
                Log.e((String)DownloadManager.TAG, (String)"Failed to load downloads.");
            }
            for (i = 0; i < this.downloads.size(); ++i) {
                this.downloads.set(i, InternalHandler.copyDownloadWithState(this.downloads.get(i), 5, 0));
            }
            for (i = 0; i < terminalDownloads.size(); ++i) {
                this.downloads.add(InternalHandler.copyDownloadWithState((Download)terminalDownloads.get(i), 5, 0));
            }
            Collections.sort(this.downloads, InternalHandler::compareStartTimes);
            try {
                this.downloadIndex.setStatesToRemoving();
            }
            catch (IOException e) {
                Log.e((String)DownloadManager.TAG, (String)"Failed to update index.", (Throwable)e);
            }
            ArrayList<Download> updateList = new ArrayList<Download>(this.downloads);
            for (int i2 = 0; i2 < this.downloads.size(); ++i2) {
                DownloadUpdate update = new DownloadUpdate(this.downloads.get(i2), false, updateList, null);
                this.mainHandler.obtainMessage(2, (Object)update).sendToTarget();
            }
            this.syncTasks();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void release() {
            for (Task task : this.activeTasks.values()) {
                task.cancel(true);
            }
            try {
                this.downloadIndex.setDownloadingStatesToQueued();
            }
            catch (IOException e) {
                Log.e((String)DownloadManager.TAG, (String)"Failed to update index.", (Throwable)e);
            }
            this.downloads.clear();
            this.thread.quit();
            Object object = this;
            synchronized (object) {
                this.released = true;
                ((Object)((Object)this)).notifyAll();
            }
        }

        private void syncTasks() {
            int accumulatingDownloadTaskCount = 0;
            for (int i = 0; i < this.downloads.size(); ++i) {
                Download download = this.downloads.get(i);
                Task activeTask = this.activeTasks.get(download.request.id);
                switch (download.state) {
                    case 1: {
                        this.syncStoppedDownload(activeTask);
                        break;
                    }
                    case 0: {
                        activeTask = this.syncQueuedDownload(activeTask, download);
                        break;
                    }
                    case 2: {
                        Assertions.checkNotNull((Object)activeTask);
                        this.syncDownloadingDownload(activeTask, download, accumulatingDownloadTaskCount);
                        break;
                    }
                    case 5: 
                    case 7: {
                        this.syncRemovingDownload(activeTask, download);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (activeTask == null || activeTask.isRemove) continue;
                ++accumulatingDownloadTaskCount;
            }
        }

        private void syncStoppedDownload(@Nullable Task activeTask) {
            if (activeTask != null) {
                Assertions.checkState((!activeTask.isRemove ? 1 : 0) != 0);
                activeTask.cancel(false);
            }
        }

        @Nullable
        @CheckResult
        private Task syncQueuedDownload(@Nullable Task activeTask, Download download) {
            if (activeTask != null) {
                Assertions.checkState((!activeTask.isRemove ? 1 : 0) != 0);
                activeTask.cancel(false);
                return activeTask;
            }
            if (!this.canDownloadsRun() || this.activeDownloadTaskCount >= this.maxParallelDownloads) {
                return null;
            }
            download = this.putDownloadWithState(download, 2, 0);
            Downloader downloader = this.downloaderFactory.createDownloader(download.request);
            activeTask = new Task(download.request, downloader, download.progress, false, this.minRetryCount, this);
            this.activeTasks.put(download.request.id, activeTask);
            if (this.activeDownloadTaskCount++ == 0) {
                this.sendEmptyMessageDelayed(11, 5000L);
            }
            activeTask.start();
            return activeTask;
        }

        private void syncDownloadingDownload(Task activeTask, Download download, int accumulatingDownloadTaskCount) {
            Assertions.checkState((!activeTask.isRemove ? 1 : 0) != 0);
            if (!this.canDownloadsRun() || accumulatingDownloadTaskCount >= this.maxParallelDownloads) {
                this.putDownloadWithState(download, 0, 0);
                activeTask.cancel(false);
            }
        }

        private void syncRemovingDownload(@Nullable Task activeTask, Download download) {
            if (activeTask != null) {
                if (!activeTask.isRemove) {
                    activeTask.cancel(false);
                }
                return;
            }
            if (this.hasActiveRemoveTask) {
                return;
            }
            Downloader downloader = this.downloaderFactory.createDownloader(download.request);
            activeTask = new Task(download.request, downloader, download.progress, true, this.minRetryCount, this);
            this.activeTasks.put(download.request.id, activeTask);
            this.hasActiveRemoveTask = true;
            activeTask.start();
        }

        private void onContentLengthChanged(Task task, long contentLength) {
            String downloadId = ((Task)task).request.id;
            Download download = (Download)Assertions.checkNotNull((Object)this.getDownload(downloadId, false));
            if (contentLength == download.contentLength || contentLength == -1L) {
                return;
            }
            this.putDownload(new Download(download.request, download.state, download.startTimeMs, System.currentTimeMillis(), contentLength, download.stopReason, download.failureReason, download.progress));
        }

        private void onTaskStopped(Task task) {
            String downloadId = ((Task)task).request.id;
            this.activeTasks.remove(downloadId);
            boolean isRemove = task.isRemove;
            if (isRemove) {
                this.hasActiveRemoveTask = false;
            } else if (--this.activeDownloadTaskCount == 0) {
                this.removeMessages(11);
            }
            if (task.isCanceled) {
                this.syncTasks();
                return;
            }
            Exception finalException = task.finalException;
            if (finalException != null) {
                Log.e((String)DownloadManager.TAG, (String)("Task failed: " + task.request + ", " + isRemove), (Throwable)finalException);
            }
            Download download = (Download)Assertions.checkNotNull((Object)this.getDownload(downloadId, false));
            switch (download.state) {
                case 2: {
                    Assertions.checkState((!isRemove ? 1 : 0) != 0);
                    this.onDownloadTaskStopped(download, finalException);
                    break;
                }
                case 5: 
                case 7: {
                    Assertions.checkState((boolean)isRemove);
                    this.onRemoveTaskStopped(download);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.syncTasks();
        }

        private void onDownloadTaskStopped(Download download, @Nullable Exception finalException) {
            download = new Download(download.request, finalException == null ? 3 : 4, download.startTimeMs, System.currentTimeMillis(), download.contentLength, download.stopReason, finalException == null ? 0 : 1, download.progress);
            this.downloads.remove(this.getDownloadIndex(download.request.id));
            try {
                this.downloadIndex.putDownload(download);
            }
            catch (IOException e) {
                Log.e((String)DownloadManager.TAG, (String)"Failed to update index.", (Throwable)e);
            }
            DownloadUpdate update = new DownloadUpdate(download, false, new ArrayList<Download>(this.downloads), finalException);
            this.mainHandler.obtainMessage(2, (Object)update).sendToTarget();
        }

        private void onRemoveTaskStopped(Download download) {
            if (download.state == 7) {
                int state = download.stopReason == 0 ? 0 : 1;
                this.putDownloadWithState(download, state, download.stopReason);
                this.syncTasks();
            } else {
                int removeIndex = this.getDownloadIndex(download.request.id);
                this.downloads.remove(removeIndex);
                try {
                    this.downloadIndex.removeDownload(download.request.id);
                }
                catch (IOException e) {
                    Log.e((String)DownloadManager.TAG, (String)"Failed to remove from database");
                }
                DownloadUpdate update = new DownloadUpdate(download, true, new ArrayList<Download>(this.downloads), null);
                this.mainHandler.obtainMessage(2, (Object)update).sendToTarget();
            }
        }

        private void updateProgress() {
            for (int i = 0; i < this.downloads.size(); ++i) {
                Download download = this.downloads.get(i);
                if (download.state != 2) continue;
                try {
                    this.downloadIndex.putDownload(download);
                    continue;
                }
                catch (IOException e) {
                    Log.e((String)DownloadManager.TAG, (String)"Failed to update index.", (Throwable)e);
                }
            }
            this.sendEmptyMessageDelayed(11, 5000L);
        }

        private boolean canDownloadsRun() {
            return !this.downloadsPaused && this.notMetRequirements == 0;
        }

        private Download putDownloadWithState(Download download, int state, int stopReason) {
            Assertions.checkState((state != 3 && state != 4 ? 1 : 0) != 0);
            return this.putDownload(InternalHandler.copyDownloadWithState(download, state, stopReason));
        }

        private Download putDownload(Download download) {
            Assertions.checkState((download.state != 3 && download.state != 4 ? 1 : 0) != 0);
            int changedIndex = this.getDownloadIndex(download.request.id);
            if (changedIndex == -1) {
                this.downloads.add(download);
                Collections.sort(this.downloads, InternalHandler::compareStartTimes);
            } else {
                boolean needsSort = download.startTimeMs != this.downloads.get((int)changedIndex).startTimeMs;
                this.downloads.set(changedIndex, download);
                if (needsSort) {
                    Collections.sort(this.downloads, InternalHandler::compareStartTimes);
                }
            }
            try {
                this.downloadIndex.putDownload(download);
            }
            catch (IOException e) {
                Log.e((String)DownloadManager.TAG, (String)"Failed to update index.", (Throwable)e);
            }
            DownloadUpdate update = new DownloadUpdate(download, false, new ArrayList<Download>(this.downloads), null);
            this.mainHandler.obtainMessage(2, (Object)update).sendToTarget();
            return download;
        }

        @Nullable
        private Download getDownload(String id, boolean loadFromIndex) {
            int index = this.getDownloadIndex(id);
            if (index != -1) {
                return this.downloads.get(index);
            }
            if (loadFromIndex) {
                try {
                    return this.downloadIndex.getDownload(id);
                }
                catch (IOException e) {
                    Log.e((String)DownloadManager.TAG, (String)("Failed to load download: " + id), (Throwable)e);
                }
            }
            return null;
        }

        private int getDownloadIndex(String id) {
            for (int i = 0; i < this.downloads.size(); ++i) {
                Download download = this.downloads.get(i);
                if (!download.request.id.equals(id)) continue;
                return i;
            }
            return -1;
        }

        private static Download copyDownloadWithState(Download download, int state, int stopReason) {
            return new Download(download.request, state, download.startTimeMs, System.currentTimeMillis(), download.contentLength, stopReason, 0, download.progress);
        }

        private static int compareStartTimes(Download first, Download second) {
            return Util.compareLong((long)first.startTimeMs, (long)second.startTimeMs);
        }
    }

    public static interface Listener {
        default public void onInitialized(DownloadManager downloadManager) {
        }

        default public void onDownloadsPausedChanged(DownloadManager downloadManager, boolean downloadsPaused) {
        }

        default public void onDownloadChanged(DownloadManager downloadManager, Download download, @Nullable Exception finalException) {
        }

        default public void onDownloadRemoved(DownloadManager downloadManager, Download download) {
        }

        default public void onIdle(DownloadManager downloadManager) {
        }

        default public void onRequirementsStateChanged(DownloadManager downloadManager, Requirements requirements, int notMetRequirements) {
        }

        default public void onWaitingForRequirementsChanged(DownloadManager downloadManager, boolean waitingForRequirements) {
        }
    }
}

