/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.upstream.experimental;

import androidx.annotation.VisibleForTesting;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSpec;
import androidx.media3.exoplayer.upstream.SlidingPercentile;
import androidx.media3.exoplayer.upstream.TimeToFirstByteEstimator;
import java.util.LinkedHashMap;
import java.util.Map;

@UnstableApi
public final class PercentileTimeToFirstByteEstimator
implements TimeToFirstByteEstimator {
    public static final int DEFAULT_MAX_SAMPLES_COUNT = 10;
    public static final float DEFAULT_PERCENTILE = 0.5f;
    private static final int MAX_DATA_SPECS = 10;
    private final LinkedHashMap<DataSpec, Long> initializedDataSpecs;
    private final SlidingPercentile slidingPercentile;
    private final float percentile;
    private final Clock clock;
    private boolean isEmpty;

    public PercentileTimeToFirstByteEstimator() {
        this(10, 0.5f);
    }

    public PercentileTimeToFirstByteEstimator(int numberOfSamples, float percentile) {
        this(numberOfSamples, percentile, Clock.DEFAULT);
    }

    @VisibleForTesting
    PercentileTimeToFirstByteEstimator(int numberOfSamples, float percentile, Clock clock) {
        Assertions.checkArgument((numberOfSamples > 0 && percentile > 0.0f && percentile <= 1.0f ? 1 : 0) != 0);
        this.percentile = percentile;
        this.clock = clock;
        this.initializedDataSpecs = new FixedSizeLinkedHashMap<DataSpec, Long>(10);
        this.slidingPercentile = new SlidingPercentile(numberOfSamples);
        this.isEmpty = true;
    }

    @Override
    public long getTimeToFirstByteEstimateUs() {
        return !this.isEmpty ? (long)this.slidingPercentile.getPercentile(this.percentile) : -9223372036854775807L;
    }

    @Override
    public void reset() {
        this.slidingPercentile.reset();
        this.isEmpty = true;
    }

    @Override
    public void onTransferInitializing(DataSpec dataSpec) {
        this.initializedDataSpecs.remove(dataSpec);
        this.initializedDataSpecs.put(dataSpec, Util.msToUs((long)this.clock.elapsedRealtime()));
    }

    @Override
    public void onTransferStart(DataSpec dataSpec) {
        Long initializationStartUs = (Long)this.initializedDataSpecs.remove(dataSpec);
        if (initializationStartUs == null) {
            return;
        }
        this.slidingPercentile.addSample(1, Util.msToUs((long)this.clock.elapsedRealtime()) - initializationStartUs);
        this.isEmpty = false;
    }

    private static class FixedSizeLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        public FixedSizeLinkedHashMap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

