/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import android.os.Bundle;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@UnstableApi
public final class BundleableUtil {
    public static <T extends Bundleable> ImmutableList<Bundle> toBundleList(List<T> bundleableList) {
        return BundleableUtil.toBundleList(bundleableList, Bundleable::toBundle);
    }

    public static <T extends Bundleable> ImmutableList<Bundle> toBundleList(List<T> bundleableList, Function<T, Bundle> customToBundleFunc) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < bundleableList.size(); ++i) {
            Bundleable bundleable = (Bundleable)bundleableList.get(i);
            builder.add((Object)((Bundle)customToBundleFunc.apply((Object)bundleable)));
        }
        return builder.build();
    }

    public static <T extends Bundleable> ImmutableList<T> fromBundleList(Bundleable.Creator<T> creator, List<Bundle> bundleList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < bundleList.size(); ++i) {
            Bundle bundle = Assertions.checkNotNull(bundleList.get(i));
            T bundleable = creator.fromBundle(bundle);
            builder.add(bundleable);
        }
        return builder.build();
    }

    public static <T extends Bundleable> ArrayList<Bundle> toBundleArrayList(Collection<T> bundleables) {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(bundleables.size());
        for (Bundleable element : bundleables) {
            arrayList.add(element.toBundle());
        }
        return arrayList;
    }

    public static <T extends Bundleable> SparseArray<T> fromBundleSparseArray(Bundleable.Creator<T> creator, SparseArray<Bundle> bundleSparseArray) {
        SparseArray result = new SparseArray(bundleSparseArray.size());
        for (int i = 0; i < bundleSparseArray.size(); ++i) {
            result.put(bundleSparseArray.keyAt(i), creator.fromBundle((Bundle)bundleSparseArray.valueAt(i)));
        }
        return result;
    }

    public static <T extends Bundleable> SparseArray<Bundle> toBundleSparseArray(SparseArray<T> bundleableSparseArray) {
        SparseArray sparseArray = new SparseArray(bundleableSparseArray.size());
        for (int i = 0; i < bundleableSparseArray.size(); ++i) {
            sparseArray.put(bundleableSparseArray.keyAt(i), (Object)((Bundleable)bundleableSparseArray.valueAt(i)).toBundle());
        }
        return sparseArray;
    }

    public static Bundle stringMapToBundle(Map<String, String> bundleableMap) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : bundleableMap.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    public static HashMap<String, String> bundleToStringHashMap(Bundle bundle) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (bundle == Bundle.EMPTY) {
            return map;
        }
        for (String key : bundle.keySet()) {
            String value = bundle.getString(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static ImmutableMap<String, String> bundleToStringImmutableMap(Bundle bundle) {
        if (bundle == Bundle.EMPTY) {
            return ImmutableMap.of();
        }
        HashMap<String, String> map = BundleableUtil.bundleToStringHashMap(bundle);
        return ImmutableMap.copyOf(map);
    }

    public static Bundle getBundleWithDefault(Bundle bundle, String field, Bundle defaultValue) {
        Bundle result = bundle.getBundle(field);
        return result != null ? result : defaultValue;
    }

    public static ArrayList<Integer> getIntegerArrayListWithDefault(Bundle bundle, String field, ArrayList<Integer> defaultValue) {
        ArrayList<Integer> result = bundle.getIntegerArrayList(field);
        return result != null ? result : defaultValue;
    }

    public static void ensureClassLoader(@Nullable Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(Util.castNonNull(BundleableUtil.class.getClassLoader()));
        }
    }

    private BundleableUtil() {
    }
}

