/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp.reader;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.rtsp.RtpPayloadFormat;
import androidx.media3.exoplayer.rtsp.reader.RtpAacReader;
import androidx.media3.exoplayer.rtsp.reader.RtpAc3Reader;
import androidx.media3.exoplayer.rtsp.reader.RtpAmrReader;
import androidx.media3.exoplayer.rtsp.reader.RtpH263Reader;
import androidx.media3.exoplayer.rtsp.reader.RtpH264Reader;
import androidx.media3.exoplayer.rtsp.reader.RtpH265Reader;
import androidx.media3.exoplayer.rtsp.reader.RtpMp4aReader;
import androidx.media3.exoplayer.rtsp.reader.RtpMpeg4Reader;
import androidx.media3.exoplayer.rtsp.reader.RtpOpusReader;
import androidx.media3.exoplayer.rtsp.reader.RtpPayloadReader;
import androidx.media3.exoplayer.rtsp.reader.RtpPcmReader;
import androidx.media3.exoplayer.rtsp.reader.RtpVp8Reader;
import androidx.media3.exoplayer.rtsp.reader.RtpVp9Reader;

@UnstableApi
public final class DefaultRtpPayloadReaderFactory
implements RtpPayloadReader.Factory {
    @Override
    @Nullable
    public RtpPayloadReader createPayloadReader(RtpPayloadFormat payloadFormat) {
        switch ((String)Assertions.checkNotNull((Object)payloadFormat.format.sampleMimeType)) {
            case "audio/ac3": {
                return new RtpAc3Reader(payloadFormat);
            }
            case "audio/mp4a-latm": {
                if (payloadFormat.mediaEncoding.equals("MP4A-LATM")) {
                    return new RtpMp4aReader(payloadFormat);
                }
                return new RtpAacReader(payloadFormat);
            }
            case "audio/3gpp": 
            case "audio/amr-wb": {
                return new RtpAmrReader(payloadFormat);
            }
            case "audio/opus": {
                return new RtpOpusReader(payloadFormat);
            }
            case "audio/raw": 
            case "audio/g711-alaw": 
            case "audio/g711-mlaw": {
                return new RtpPcmReader(payloadFormat);
            }
            case "video/3gpp": {
                return new RtpH263Reader(payloadFormat);
            }
            case "video/avc": {
                return new RtpH264Reader(payloadFormat);
            }
            case "video/hevc": {
                return new RtpH265Reader(payloadFormat);
            }
            case "video/mp4v-es": {
                return new RtpMpeg4Reader(payloadFormat);
            }
            case "video/x-vnd.on2.vp8": {
                return new RtpVp8Reader(payloadFormat);
            }
            case "video/x-vnd.on2.vp9": {
                return new RtpVp9Reader(payloadFormat);
            }
        }
        return null;
    }
}

