/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import androidx.media3.common.util.UnstableApi;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@UnstableApi
public final class ExoTimeoutException
extends RuntimeException {
    public static final int TIMEOUT_OPERATION_UNDEFINED = 0;
    public static final int TIMEOUT_OPERATION_RELEASE = 1;
    public static final int TIMEOUT_OPERATION_SET_FOREGROUND_MODE = 2;
    public static final int TIMEOUT_OPERATION_DETACH_SURFACE = 3;
    public final int timeoutOperation;

    public ExoTimeoutException(int timeoutOperation) {
        super(ExoTimeoutException.getErrorMessage(timeoutOperation));
        this.timeoutOperation = timeoutOperation;
    }

    private static String getErrorMessage(int timeoutOperation) {
        switch (timeoutOperation) {
            case 1: {
                return "Player release timed out.";
            }
            case 2: {
                return "Setting foreground mode timed out.";
            }
            case 3: {
                return "Detaching surface timed out.";
            }
        }
        return "Undefined timeout.";
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface TimeoutOperation {
    }
}

