/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source.ads;

import android.os.Handler;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.media3.common.AdPlaybackState;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.StreamKey;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.TransferListener;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.exoplayer.FormatHolder;
import androidx.media3.exoplayer.SeekParameters;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.source.BaseMediaSource;
import androidx.media3.exoplayer.source.EmptySampleStream;
import androidx.media3.exoplayer.source.ForwardingTimeline;
import androidx.media3.exoplayer.source.LoadEventInfo;
import androidx.media3.exoplayer.source.MediaLoadData;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.MediaSourceEventListener;
import androidx.media3.exoplayer.source.SampleStream;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.source.ads.ServerSideAdInsertionUtil;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import androidx.media3.exoplayer.upstream.Allocator;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class ServerSideAdInsertionMediaSource
extends BaseMediaSource
implements MediaSource.MediaSourceCaller,
MediaSourceEventListener,
DrmSessionEventListener {
    private final MediaSource mediaSource;
    private final ListMultimap<Pair<Long, Object>, SharedMediaPeriod> mediaPeriods;
    private final MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcherWithoutId;
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcherWithoutId;
    @Nullable
    private final AdPlaybackStateUpdater adPlaybackStateUpdater;
    @GuardedBy(value="this")
    @Nullable
    private Handler playbackHandler;
    @Nullable
    private SharedMediaPeriod lastUsedMediaPeriod;
    private ImmutableMap<Object, AdPlaybackState> adPlaybackStates;

    public ServerSideAdInsertionMediaSource(MediaSource mediaSource, @Nullable AdPlaybackStateUpdater adPlaybackStateUpdater) {
        this.mediaSource = mediaSource;
        this.adPlaybackStateUpdater = adPlaybackStateUpdater;
        this.mediaPeriods = ArrayListMultimap.create();
        this.adPlaybackStates = ImmutableMap.of();
        this.mediaSourceEventDispatcherWithoutId = this.createEventDispatcher(null);
        this.drmEventDispatcherWithoutId = this.createDrmEventDispatcher(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdPlaybackStates(ImmutableMap<Object, AdPlaybackState> adPlaybackStates, Timeline contentTimeline) {
        Assertions.checkArgument((!adPlaybackStates.isEmpty() ? 1 : 0) != 0);
        Object adsId = Assertions.checkNotNull((Object)((AdPlaybackState)adPlaybackStates.values().asList().get((int)0)).adsId);
        for (Map.Entry entry : adPlaybackStates.entrySet()) {
            Object periodUid = entry.getKey();
            AdPlaybackState adPlaybackState = (AdPlaybackState)entry.getValue();
            Assertions.checkArgument((boolean)Util.areEqual((Object)adsId, (Object)adPlaybackState.adsId));
            AdPlaybackState oldAdPlaybackState = (AdPlaybackState)this.adPlaybackStates.get(periodUid);
            if (oldAdPlaybackState == null) continue;
            for (int adGroupIndex = adPlaybackState.removedAdGroupCount; adGroupIndex < adPlaybackState.adGroupCount; ++adGroupIndex) {
                AdPlaybackState.AdGroup adGroup = adPlaybackState.getAdGroup(adGroupIndex);
                Assertions.checkArgument((boolean)adGroup.isServerSideInserted);
                if (adGroupIndex < oldAdPlaybackState.adGroupCount && ServerSideAdInsertionUtil.getAdCountInGroup(adPlaybackState, adGroupIndex) < ServerSideAdInsertionUtil.getAdCountInGroup(oldAdPlaybackState, adGroupIndex)) {
                    AdPlaybackState.AdGroup nextAdGroup = adPlaybackState.getAdGroup(adGroupIndex + 1);
                    long sumOfSplitContentResumeOffsetUs = adGroup.contentResumeOffsetUs + nextAdGroup.contentResumeOffsetUs;
                    AdPlaybackState.AdGroup oldAdGroup = oldAdPlaybackState.getAdGroup(adGroupIndex);
                    Assertions.checkArgument((sumOfSplitContentResumeOffsetUs == oldAdGroup.contentResumeOffsetUs ? 1 : 0) != 0);
                    Assertions.checkArgument((adGroup.timeUs + adGroup.contentResumeOffsetUs == nextAdGroup.timeUs ? 1 : 0) != 0);
                }
                if (adGroup.timeUs != Long.MIN_VALUE) continue;
                Assertions.checkArgument((ServerSideAdInsertionUtil.getAdCountInGroup(adPlaybackState, adGroupIndex) == 0 ? 1 : 0) != 0);
            }
        }
        Object object = this;
        synchronized (object) {
            if (this.playbackHandler == null) {
                this.adPlaybackStates = adPlaybackStates;
            } else {
                this.playbackHandler.post(() -> {
                    AdPlaybackState adPlaybackState;
                    for (SharedMediaPeriod mediaPeriod : this.mediaPeriods.values()) {
                        AdPlaybackState adPlaybackState2 = (AdPlaybackState)adPlaybackStates.get(mediaPeriod.periodUid);
                        if (adPlaybackState2 == null) continue;
                        mediaPeriod.updateAdPlaybackState(adPlaybackState2);
                    }
                    if (this.lastUsedMediaPeriod != null && (adPlaybackState = (AdPlaybackState)adPlaybackStates.get(this.lastUsedMediaPeriod.periodUid)) != null) {
                        this.lastUsedMediaPeriod.updateAdPlaybackState(adPlaybackState);
                    }
                    this.adPlaybackStates = adPlaybackStates;
                    this.refreshSourceInfo(new ServerSideAdInsertionTimeline(contentTimeline, adPlaybackStates));
                });
            }
        }
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaSource.getMediaItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        Handler handler = Util.createHandlerForCurrentLooper();
        ServerSideAdInsertionMediaSource serverSideAdInsertionMediaSource = this;
        synchronized (serverSideAdInsertionMediaSource) {
            this.playbackHandler = handler;
        }
        this.mediaSource.addEventListener(handler, this);
        this.mediaSource.addDrmEventListener(handler, this);
        this.mediaSource.prepareSource(this, mediaTransferListener, this.getPlayerId());
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.mediaSource.maybeThrowSourceInfoRefreshError();
    }

    @Override
    protected void enableInternal() {
        this.mediaSource.enable(this);
    }

    @Override
    protected void disableInternal() {
        this.releaseLastUsedMediaPeriod();
        this.mediaSource.disable(this);
    }

    @Override
    public void onSourceInfoRefreshed(MediaSource source, Timeline timeline) {
        if (!(this.adPlaybackStateUpdater != null && this.adPlaybackStateUpdater.onAdPlaybackStateUpdateRequested(timeline) || this.adPlaybackStates.isEmpty())) {
            this.refreshSourceInfo(new ServerSideAdInsertionTimeline(timeline, this.adPlaybackStates));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseSourceInternal() {
        this.releaseLastUsedMediaPeriod();
        ServerSideAdInsertionMediaSource serverSideAdInsertionMediaSource = this;
        synchronized (serverSideAdInsertionMediaSource) {
            this.playbackHandler = null;
        }
        this.mediaSource.releaseSource(this);
        this.mediaSource.removeEventListener(this);
        this.mediaSource.removeDrmEventListener(this);
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        SharedMediaPeriod sharedPeriod = null;
        Pair sharedMediaPeriodKey = new Pair((Object)id.windowSequenceNumber, id.periodUid);
        boolean reusedSharedPeriod = false;
        if (this.lastUsedMediaPeriod != null) {
            if (this.lastUsedMediaPeriod.periodUid.equals(id.periodUid)) {
                sharedPeriod = this.lastUsedMediaPeriod;
                this.mediaPeriods.put((Object)sharedMediaPeriodKey, (Object)sharedPeriod);
                reusedSharedPeriod = true;
            } else {
                this.lastUsedMediaPeriod.release(this.mediaSource);
            }
            this.lastUsedMediaPeriod = null;
        }
        if (sharedPeriod == null) {
            SharedMediaPeriod lastExistingPeriod = (SharedMediaPeriod)Iterables.getLast((Iterable)this.mediaPeriods.get((Object)sharedMediaPeriodKey), null);
            if (lastExistingPeriod != null && lastExistingPeriod.canReuseMediaPeriod(id, startPositionUs)) {
                sharedPeriod = lastExistingPeriod;
            } else {
                AdPlaybackState adPlaybackState = (AdPlaybackState)Assertions.checkNotNull((Object)((AdPlaybackState)this.adPlaybackStates.get(id.periodUid)));
                long streamPositionUs = ServerSideAdInsertionUtil.getStreamPositionUs(startPositionUs, id, adPlaybackState);
                sharedPeriod = new SharedMediaPeriod(this.mediaSource.createPeriod(new MediaSource.MediaPeriodId(id.periodUid, id.windowSequenceNumber), allocator, streamPositionUs), id.periodUid, adPlaybackState);
                this.mediaPeriods.put((Object)sharedMediaPeriodKey, (Object)sharedPeriod);
            }
        }
        MediaPeriodImpl mediaPeriod = new MediaPeriodImpl(sharedPeriod, id, this.createEventDispatcher(id), this.createDrmEventDispatcher(id));
        sharedPeriod.add(mediaPeriod);
        if (reusedSharedPeriod && sharedPeriod.trackSelections.length > 0) {
            mediaPeriod.seekToUs(startPositionUs);
        }
        return mediaPeriod;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        MediaPeriodImpl mediaPeriodImpl = (MediaPeriodImpl)mediaPeriod;
        mediaPeriodImpl.sharedPeriod.remove(mediaPeriodImpl);
        if (mediaPeriodImpl.sharedPeriod.isUnused()) {
            this.mediaPeriods.remove((Object)new Pair((Object)mediaPeriodImpl.mediaPeriodId.windowSequenceNumber, mediaPeriodImpl.mediaPeriodId.periodUid), (Object)mediaPeriodImpl.sharedPeriod);
            if (this.mediaPeriods.isEmpty()) {
                this.lastUsedMediaPeriod = mediaPeriodImpl.sharedPeriod;
            } else {
                mediaPeriodImpl.sharedPeriod.release(this.mediaSource);
            }
        }
    }

    @Override
    public void onDrmSessionAcquired(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, int state) {
        MediaPeriodImpl mediaPeriod = this.getMediaPeriodForEvent(mediaPeriodId, null, true);
        if (mediaPeriod == null) {
            this.drmEventDispatcherWithoutId.drmSessionAcquired(state);
        } else {
            mediaPeriod.drmEventDispatcher.drmSessionAcquired(state);
        }
    }

    @Override
    public void onDrmKeysLoaded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        MediaPeriodImpl mediaPeriod = this.getMediaPeriodForEvent(mediaPeriodId, null, false);
        if (mediaPeriod == null) {
            this.drmEventDispatcherWithoutId.drmKeysLoaded();
        } else {
            mediaPeriod.drmEventDispatcher.drmKeysLoaded();
        }
    }

    @Override
    public void onDrmSessionManagerError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, Exception error) {
        MediaPeriodImpl mediaPeriod = this.getMediaPeriodForEvent(mediaPeriodId, null, false);
        if (mediaPeriod == null) {
            this.drmEventDispatcherWithoutId.drmSessionManagerError(error);
        } else {
            mediaPeriod.drmEventDispatcher.drmSessionManagerError(error);
        }
    }

    @Override
    public void onDrmKeysRestored(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        MediaPeriodImpl mediaPeriod = this.getMediaPeriodForEvent(mediaPeriodId, null, false);
        if (mediaPeriod == null) {
            this.drmEventDispatcherWithoutId.drmKeysRestored();
        } else {
            mediaPeriod.drmEventDispatcher.drmKeysRestored();
        }
    }

    @Override
    public void onDrmKeysRemoved(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        MediaPeriodImpl mediaPeriod = this.getMediaPeriodForEvent(mediaPeriodId, null, false);
        if (mediaPeriod == null) {
            this.drmEventDispatcherWithoutId.drmKeysRemoved();
        } else {
            mediaPeriod.drmEventDispatcher.drmKeysRemoved();
        }
    }

    @Override
    public void onDrmSessionReleased(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        MediaPeriodImpl mediaPeriod = this.getMediaPeriodForEvent(mediaPeriodId, null, false);
        if (mediaPeriod == null) {
            this.drmEventDispatcherWithoutId.drmSessionReleased();
        } else {
            mediaPeriod.drmEventDispatcher.drmSessionReleased();
        }
    }

    @Override
    public void onLoadStarted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        MediaPeriodImpl mediaPeriod = this.getMediaPeriodForEvent(mediaPeriodId, mediaLoadData, true);
        if (mediaPeriod == null) {
            this.mediaSourceEventDispatcherWithoutId.loadStarted(loadEventInfo, mediaLoadData);
        } else {
            mediaPeriod.sharedPeriod.onLoadStarted(loadEventInfo, mediaLoadData);
            mediaPeriod.mediaSourceEventDispatcher.loadStarted(loadEventInfo, ServerSideAdInsertionMediaSource.correctMediaLoadData(mediaPeriod, mediaLoadData, (AdPlaybackState)Assertions.checkNotNull((Object)((AdPlaybackState)this.adPlaybackStates.get(mediaPeriod.mediaPeriodId.periodUid)))));
        }
    }

    @Override
    public void onLoadCompleted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        MediaPeriodImpl mediaPeriod = this.getMediaPeriodForEvent(mediaPeriodId, mediaLoadData, true);
        if (mediaPeriod == null) {
            this.mediaSourceEventDispatcherWithoutId.loadCompleted(loadEventInfo, mediaLoadData);
        } else {
            mediaPeriod.sharedPeriod.onLoadFinished(loadEventInfo);
            mediaPeriod.mediaSourceEventDispatcher.loadCompleted(loadEventInfo, ServerSideAdInsertionMediaSource.correctMediaLoadData(mediaPeriod, mediaLoadData, (AdPlaybackState)Assertions.checkNotNull((Object)((AdPlaybackState)this.adPlaybackStates.get(mediaPeriod.mediaPeriodId.periodUid)))));
        }
    }

    @Override
    public void onLoadCanceled(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        MediaPeriodImpl mediaPeriod = this.getMediaPeriodForEvent(mediaPeriodId, mediaLoadData, true);
        if (mediaPeriod == null) {
            this.mediaSourceEventDispatcherWithoutId.loadCanceled(loadEventInfo, mediaLoadData);
        } else {
            mediaPeriod.sharedPeriod.onLoadFinished(loadEventInfo);
            mediaPeriod.mediaSourceEventDispatcher.loadCanceled(loadEventInfo, ServerSideAdInsertionMediaSource.correctMediaLoadData(mediaPeriod, mediaLoadData, (AdPlaybackState)Assertions.checkNotNull((Object)((AdPlaybackState)this.adPlaybackStates.get(mediaPeriod.mediaPeriodId.periodUid)))));
        }
    }

    @Override
    public void onLoadError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
        MediaPeriodImpl mediaPeriod = this.getMediaPeriodForEvent(mediaPeriodId, mediaLoadData, true);
        if (mediaPeriod == null) {
            this.mediaSourceEventDispatcherWithoutId.loadError(loadEventInfo, mediaLoadData, error, wasCanceled);
        } else {
            if (wasCanceled) {
                mediaPeriod.sharedPeriod.onLoadFinished(loadEventInfo);
            }
            mediaPeriod.mediaSourceEventDispatcher.loadError(loadEventInfo, ServerSideAdInsertionMediaSource.correctMediaLoadData(mediaPeriod, mediaLoadData, (AdPlaybackState)Assertions.checkNotNull((Object)((AdPlaybackState)this.adPlaybackStates.get(mediaPeriod.mediaPeriodId.periodUid)))), error, wasCanceled);
        }
    }

    @Override
    public void onUpstreamDiscarded(int windowIndex, MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
        MediaPeriodImpl mediaPeriod = this.getMediaPeriodForEvent(mediaPeriodId, mediaLoadData, false);
        if (mediaPeriod == null) {
            this.mediaSourceEventDispatcherWithoutId.upstreamDiscarded(mediaLoadData);
        } else {
            mediaPeriod.mediaSourceEventDispatcher.upstreamDiscarded(ServerSideAdInsertionMediaSource.correctMediaLoadData(mediaPeriod, mediaLoadData, (AdPlaybackState)Assertions.checkNotNull((Object)((AdPlaybackState)this.adPlaybackStates.get(mediaPeriod.mediaPeriodId.periodUid)))));
        }
    }

    @Override
    public void onDownstreamFormatChanged(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
        MediaPeriodImpl mediaPeriod = this.getMediaPeriodForEvent(mediaPeriodId, mediaLoadData, false);
        if (mediaPeriod == null) {
            this.mediaSourceEventDispatcherWithoutId.downstreamFormatChanged(mediaLoadData);
        } else {
            mediaPeriod.sharedPeriod.onDownstreamFormatChanged(mediaPeriod, mediaLoadData);
            mediaPeriod.mediaSourceEventDispatcher.downstreamFormatChanged(ServerSideAdInsertionMediaSource.correctMediaLoadData(mediaPeriod, mediaLoadData, (AdPlaybackState)Assertions.checkNotNull((Object)((AdPlaybackState)this.adPlaybackStates.get(mediaPeriod.mediaPeriodId.periodUid)))));
        }
    }

    private void releaseLastUsedMediaPeriod() {
        if (this.lastUsedMediaPeriod != null) {
            this.lastUsedMediaPeriod.release(this.mediaSource);
            this.lastUsedMediaPeriod = null;
        }
    }

    @Nullable
    private MediaPeriodImpl getMediaPeriodForEvent(@Nullable MediaSource.MediaPeriodId mediaPeriodId, @Nullable MediaLoadData mediaLoadData, boolean useLoadingPeriod) {
        if (mediaPeriodId == null) {
            return null;
        }
        List periods = this.mediaPeriods.get((Object)new Pair((Object)mediaPeriodId.windowSequenceNumber, mediaPeriodId.periodUid));
        if (periods.isEmpty()) {
            return null;
        }
        if (useLoadingPeriod) {
            SharedMediaPeriod loadingPeriod = (SharedMediaPeriod)Iterables.getLast((Iterable)periods);
            return loadingPeriod.loadingPeriod != null ? loadingPeriod.loadingPeriod : (MediaPeriodImpl)Iterables.getLast((Iterable)loadingPeriod.mediaPeriods);
        }
        for (int i = 0; i < periods.size(); ++i) {
            MediaPeriodImpl period = ((SharedMediaPeriod)periods.get(i)).getMediaPeriodForEvent(mediaLoadData);
            if (period == null) continue;
            return period;
        }
        return (MediaPeriodImpl)((SharedMediaPeriod)periods.get(0)).mediaPeriods.get(0);
    }

    private static long getMediaPeriodEndPositionUs(MediaPeriodImpl mediaPeriod, AdPlaybackState adPlaybackState) {
        MediaSource.MediaPeriodId id = mediaPeriod.mediaPeriodId;
        if (id.isAd()) {
            AdPlaybackState.AdGroup adGroup = adPlaybackState.getAdGroup(id.adGroupIndex);
            return adGroup.count == -1 ? 0L : adGroup.durationsUs[id.adIndexInAdGroup];
        }
        if (id.nextAdGroupIndex == -1) {
            return Long.MAX_VALUE;
        }
        AdPlaybackState.AdGroup nextAdGroup = adPlaybackState.getAdGroup(id.nextAdGroupIndex);
        return nextAdGroup.timeUs == Long.MIN_VALUE ? Long.MAX_VALUE : nextAdGroup.timeUs;
    }

    private static MediaLoadData correctMediaLoadData(MediaPeriodImpl mediaPeriod, MediaLoadData mediaLoadData, AdPlaybackState adPlaybackState) {
        return new MediaLoadData(mediaLoadData.dataType, mediaLoadData.trackType, mediaLoadData.trackFormat, mediaLoadData.trackSelectionReason, mediaLoadData.trackSelectionData, ServerSideAdInsertionMediaSource.correctMediaLoadDataPositionMs(mediaLoadData.mediaStartTimeMs, mediaPeriod, adPlaybackState), ServerSideAdInsertionMediaSource.correctMediaLoadDataPositionMs(mediaLoadData.mediaEndTimeMs, mediaPeriod, adPlaybackState));
    }

    private static long correctMediaLoadDataPositionMs(long mediaPositionMs, MediaPeriodImpl mediaPeriod, AdPlaybackState adPlaybackState) {
        if (mediaPositionMs == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        long mediaPositionUs = Util.msToUs((long)mediaPositionMs);
        MediaSource.MediaPeriodId id = mediaPeriod.mediaPeriodId;
        long correctedPositionUs = id.isAd() ? ServerSideAdInsertionUtil.getMediaPeriodPositionUsForAd(mediaPositionUs, id.adGroupIndex, id.adIndexInAdGroup, adPlaybackState) : ServerSideAdInsertionUtil.getMediaPeriodPositionUsForContent(mediaPositionUs, -1, adPlaybackState);
        return Util.usToMs((long)correctedPositionUs);
    }

    private static final class SampleStreamImpl
    implements SampleStream {
        private final MediaPeriodImpl mediaPeriod;
        private final int streamIndex;

        public SampleStreamImpl(MediaPeriodImpl mediaPeriod, int streamIndex) {
            this.mediaPeriod = mediaPeriod;
            this.streamIndex = streamIndex;
        }

        @Override
        public boolean isReady() {
            return this.mediaPeriod.sharedPeriod.isReady(this.streamIndex);
        }

        @Override
        public void maybeThrowError() throws IOException {
            this.mediaPeriod.sharedPeriod.maybeThrowError(this.streamIndex);
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
            return this.mediaPeriod.sharedPeriod.readData(this.mediaPeriod, this.streamIndex, formatHolder, buffer, readFlags);
        }

        @Override
        public int skipData(long positionUs) {
            return this.mediaPeriod.sharedPeriod.skipData(this.mediaPeriod, this.streamIndex, positionUs);
        }
    }

    private static final class MediaPeriodImpl
    implements MediaPeriod {
        public final SharedMediaPeriod sharedPeriod;
        public final MediaSource.MediaPeriodId mediaPeriodId;
        public final MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;
        public final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
        public @MonotonicNonNull MediaPeriod.Callback callback;
        public long lastStartPositionUs;
        public boolean[] hasNotifiedDownstreamFormatChange;
        public boolean isPrepared;

        public MediaPeriodImpl(SharedMediaPeriod sharedPeriod, MediaSource.MediaPeriodId mediaPeriodId, MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher, DrmSessionEventListener.EventDispatcher drmEventDispatcher) {
            this.sharedPeriod = sharedPeriod;
            this.mediaPeriodId = mediaPeriodId;
            this.mediaSourceEventDispatcher = mediaSourceEventDispatcher;
            this.drmEventDispatcher = drmEventDispatcher;
            this.hasNotifiedDownstreamFormatChange = new boolean[0];
        }

        public void onPrepared() {
            if (this.callback != null) {
                this.callback.onPrepared(this);
            }
            this.isPrepared = true;
        }

        @Override
        public void prepare(MediaPeriod.Callback callback, long positionUs) {
            this.callback = callback;
            this.sharedPeriod.prepare(this, positionUs);
        }

        @Override
        public void maybeThrowPrepareError() throws IOException {
            this.sharedPeriod.maybeThrowPrepareError();
        }

        @Override
        public TrackGroupArray getTrackGroups() {
            return this.sharedPeriod.getTrackGroups();
        }

        @Override
        public List<StreamKey> getStreamKeys(List<ExoTrackSelection> trackSelections) {
            return this.sharedPeriod.getStreamKeys(trackSelections);
        }

        @Override
        public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
            if (this.hasNotifiedDownstreamFormatChange.length == 0) {
                this.hasNotifiedDownstreamFormatChange = new boolean[streams.length];
            }
            return this.sharedPeriod.selectTracks(this, selections, mayRetainStreamFlags, streams, streamResetFlags, positionUs);
        }

        @Override
        public void discardBuffer(long positionUs, boolean toKeyframe) {
            this.sharedPeriod.discardBuffer(this, positionUs, toKeyframe);
        }

        @Override
        public long readDiscontinuity() {
            return this.sharedPeriod.readDiscontinuity(this);
        }

        @Override
        public long seekToUs(long positionUs) {
            return this.sharedPeriod.seekToUs(this, positionUs);
        }

        @Override
        public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
            return this.sharedPeriod.getAdjustedSeekPositionUs(this, positionUs, seekParameters);
        }

        @Override
        public long getBufferedPositionUs() {
            return this.sharedPeriod.getBufferedPositionUs(this);
        }

        @Override
        public long getNextLoadPositionUs() {
            return this.sharedPeriod.getNextLoadPositionUs(this);
        }

        @Override
        public boolean continueLoading(long positionUs) {
            return this.sharedPeriod.continueLoading(this, positionUs);
        }

        @Override
        public boolean isLoading() {
            return this.sharedPeriod.isLoading(this);
        }

        @Override
        public void reevaluateBuffer(long positionUs) {
            this.sharedPeriod.reevaluateBuffer(this, positionUs);
        }
    }

    private static final class ServerSideAdInsertionTimeline
    extends ForwardingTimeline {
        private final ImmutableMap<Object, AdPlaybackState> adPlaybackStates;

        public ServerSideAdInsertionTimeline(Timeline contentTimeline, ImmutableMap<Object, AdPlaybackState> adPlaybackStates) {
            super(contentTimeline);
            Assertions.checkState((contentTimeline.getWindowCount() == 1 ? 1 : 0) != 0);
            Timeline.Period period = new Timeline.Period();
            for (int i = 0; i < contentTimeline.getPeriodCount(); ++i) {
                contentTimeline.getPeriod(i, period, true);
                Assertions.checkState((boolean)adPlaybackStates.containsKey(Assertions.checkNotNull((Object)period.uid)));
            }
            this.adPlaybackStates = adPlaybackStates;
        }

        @Override
        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
            super.getWindow(windowIndex, window, defaultPositionProjectionUs);
            Timeline.Period period = new Timeline.Period();
            Object firstPeriodUid = Assertions.checkNotNull((Object)this.getPeriod((int)window.firstPeriodIndex, (Timeline.Period)period, (boolean)true).uid);
            AdPlaybackState firstAdPlaybackState = (AdPlaybackState)Assertions.checkNotNull((Object)((AdPlaybackState)this.adPlaybackStates.get(firstPeriodUid)));
            long positionInPeriodUs = ServerSideAdInsertionUtil.getMediaPeriodPositionUsForContent(window.positionInFirstPeriodUs, -1, firstAdPlaybackState);
            if (window.durationUs == -9223372036854775807L) {
                if (firstAdPlaybackState.contentDurationUs != -9223372036854775807L) {
                    window.durationUs = firstAdPlaybackState.contentDurationUs - positionInPeriodUs;
                }
            } else {
                Timeline.Period originalLastPeriod = super.getPeriod(window.lastPeriodIndex, period, true);
                long originalLastPeriodPositionInWindowUs = originalLastPeriod.positionInWindowUs;
                AdPlaybackState lastAdPlaybackState = (AdPlaybackState)Assertions.checkNotNull((Object)((AdPlaybackState)this.adPlaybackStates.get(originalLastPeriod.uid)));
                Timeline.Period adjustedLastPeriod = this.getPeriod(window.lastPeriodIndex, period);
                long originalWindowDurationInLastPeriodUs = window.durationUs - originalLastPeriodPositionInWindowUs;
                long adjustedWindowDurationInLastPeriodUs = ServerSideAdInsertionUtil.getMediaPeriodPositionUsForContent(originalWindowDurationInLastPeriodUs, -1, lastAdPlaybackState);
                window.durationUs = adjustedLastPeriod.positionInWindowUs + adjustedWindowDurationInLastPeriodUs;
            }
            window.positionInFirstPeriodUs = positionInPeriodUs;
            return window;
        }

        @Override
        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            super.getPeriod(periodIndex, period, true);
            AdPlaybackState adPlaybackState = (AdPlaybackState)Assertions.checkNotNull((Object)((AdPlaybackState)this.adPlaybackStates.get(period.uid)));
            long durationUs = period.durationUs;
            durationUs = durationUs == -9223372036854775807L ? adPlaybackState.contentDurationUs : ServerSideAdInsertionUtil.getMediaPeriodPositionUsForContent(durationUs, -1, adPlaybackState);
            long positionInWindowUs = 0L;
            Timeline.Period innerPeriod = new Timeline.Period();
            for (int i = 0; i < periodIndex + 1; ++i) {
                this.timeline.getPeriod(i, innerPeriod, true);
                AdPlaybackState innerAdPlaybackState = (AdPlaybackState)Assertions.checkNotNull((Object)((AdPlaybackState)this.adPlaybackStates.get(innerPeriod.uid)));
                if (i == 0) {
                    positionInWindowUs = -ServerSideAdInsertionUtil.getMediaPeriodPositionUsForContent(-innerPeriod.getPositionInWindowUs(), -1, innerAdPlaybackState);
                }
                if (i == periodIndex) continue;
                positionInWindowUs += ServerSideAdInsertionUtil.getMediaPeriodPositionUsForContent(innerPeriod.durationUs, -1, innerAdPlaybackState);
            }
            period.set(period.id, period.uid, period.windowIndex, durationUs, positionInWindowUs, adPlaybackState, period.isPlaceholder);
            return period;
        }
    }

    private static final class SharedMediaPeriod
    implements MediaPeriod.Callback {
        private final MediaPeriod actualMediaPeriod;
        private final List<MediaPeriodImpl> mediaPeriods;
        private final Map<Long, Pair<LoadEventInfo, MediaLoadData>> activeLoads;
        private final Object periodUid;
        private AdPlaybackState adPlaybackState;
        @Nullable
        private MediaPeriodImpl loadingPeriod;
        private boolean hasStartedPreparing;
        private boolean isPrepared;
        public @NullableType ExoTrackSelection[] trackSelections;
        public @NullableType SampleStream[] sampleStreams;
        public @NullableType MediaLoadData[] lastDownstreamFormatChangeData;

        public SharedMediaPeriod(MediaPeriod actualMediaPeriod, Object periodUid, AdPlaybackState adPlaybackState) {
            this.actualMediaPeriod = actualMediaPeriod;
            this.periodUid = periodUid;
            this.adPlaybackState = adPlaybackState;
            this.mediaPeriods = new ArrayList<MediaPeriodImpl>();
            this.activeLoads = new HashMap<Long, Pair<LoadEventInfo, MediaLoadData>>();
            this.trackSelections = new ExoTrackSelection[0];
            this.sampleStreams = new SampleStream[0];
            this.lastDownstreamFormatChangeData = new MediaLoadData[0];
        }

        public void updateAdPlaybackState(AdPlaybackState adPlaybackState) {
            this.adPlaybackState = adPlaybackState;
        }

        public void add(MediaPeriodImpl mediaPeriod) {
            this.mediaPeriods.add(mediaPeriod);
        }

        public void remove(MediaPeriodImpl mediaPeriod) {
            if (mediaPeriod.equals(this.loadingPeriod)) {
                this.loadingPeriod = null;
                this.activeLoads.clear();
            }
            this.mediaPeriods.remove(mediaPeriod);
        }

        public boolean isUnused() {
            return this.mediaPeriods.isEmpty();
        }

        public void release(MediaSource mediaSource) {
            mediaSource.releasePeriod(this.actualMediaPeriod);
        }

        public boolean canReuseMediaPeriod(MediaSource.MediaPeriodId id, long positionUs) {
            MediaPeriodImpl previousPeriod = (MediaPeriodImpl)Iterables.getLast(this.mediaPeriods);
            long previousEndPositionUs = ServerSideAdInsertionUtil.getStreamPositionUs(ServerSideAdInsertionMediaSource.getMediaPeriodEndPositionUs(previousPeriod, this.adPlaybackState), previousPeriod.mediaPeriodId, this.adPlaybackState);
            long startPositionUs = ServerSideAdInsertionUtil.getStreamPositionUs(positionUs, id, this.adPlaybackState);
            return startPositionUs == previousEndPositionUs;
        }

        @Nullable
        public MediaPeriodImpl getMediaPeriodForEvent(@Nullable MediaLoadData mediaLoadData) {
            if (mediaLoadData != null && mediaLoadData.mediaStartTimeMs != -9223372036854775807L) {
                for (int i = 0; i < this.mediaPeriods.size(); ++i) {
                    MediaPeriodImpl mediaPeriod = this.mediaPeriods.get(i);
                    if (!mediaPeriod.isPrepared) continue;
                    long startTimeInPeriodUs = ServerSideAdInsertionUtil.getMediaPeriodPositionUs(Util.msToUs((long)mediaLoadData.mediaStartTimeMs), mediaPeriod.mediaPeriodId, this.adPlaybackState);
                    long mediaPeriodEndPositionUs = ServerSideAdInsertionMediaSource.getMediaPeriodEndPositionUs(mediaPeriod, this.adPlaybackState);
                    if (startTimeInPeriodUs < 0L || startTimeInPeriodUs >= mediaPeriodEndPositionUs) continue;
                    return mediaPeriod;
                }
            }
            return null;
        }

        public void prepare(MediaPeriodImpl mediaPeriod, long positionUs) {
            mediaPeriod.lastStartPositionUs = positionUs;
            if (this.hasStartedPreparing) {
                if (this.isPrepared) {
                    mediaPeriod.onPrepared();
                }
                return;
            }
            this.hasStartedPreparing = true;
            long preparePositionUs = ServerSideAdInsertionUtil.getStreamPositionUs(positionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
            this.actualMediaPeriod.prepare(this, preparePositionUs);
        }

        public void maybeThrowPrepareError() throws IOException {
            this.actualMediaPeriod.maybeThrowPrepareError();
        }

        public TrackGroupArray getTrackGroups() {
            return this.actualMediaPeriod.getTrackGroups();
        }

        public List<StreamKey> getStreamKeys(List<ExoTrackSelection> trackSelections) {
            return this.actualMediaPeriod.getStreamKeys(trackSelections);
        }

        public boolean continueLoading(MediaPeriodImpl mediaPeriod, long positionUs) {
            MediaPeriodImpl loadingPeriod = this.loadingPeriod;
            if (loadingPeriod != null && !mediaPeriod.equals(loadingPeriod)) {
                for (Pair<LoadEventInfo, MediaLoadData> loadData : this.activeLoads.values()) {
                    loadingPeriod.mediaSourceEventDispatcher.loadCompleted((LoadEventInfo)loadData.first, ServerSideAdInsertionMediaSource.correctMediaLoadData(loadingPeriod, (MediaLoadData)loadData.second, this.adPlaybackState));
                    mediaPeriod.mediaSourceEventDispatcher.loadStarted((LoadEventInfo)loadData.first, ServerSideAdInsertionMediaSource.correctMediaLoadData(mediaPeriod, (MediaLoadData)loadData.second, this.adPlaybackState));
                }
            }
            this.loadingPeriod = mediaPeriod;
            long actualPlaybackPositionUs = this.getStreamPositionUsWithNotYetStartedHandling(mediaPeriod, positionUs);
            return this.actualMediaPeriod.continueLoading(actualPlaybackPositionUs);
        }

        public boolean isLoading(MediaPeriodImpl mediaPeriod) {
            return mediaPeriod.equals(this.loadingPeriod) && this.actualMediaPeriod.isLoading();
        }

        public long getBufferedPositionUs(MediaPeriodImpl mediaPeriod) {
            return this.getMediaPeriodPositionUsWithEndOfSourceHandling(mediaPeriod, this.actualMediaPeriod.getBufferedPositionUs());
        }

        public long getNextLoadPositionUs(MediaPeriodImpl mediaPeriod) {
            return this.getMediaPeriodPositionUsWithEndOfSourceHandling(mediaPeriod, this.actualMediaPeriod.getNextLoadPositionUs());
        }

        public long seekToUs(MediaPeriodImpl mediaPeriod, long positionUs) {
            long actualRequestedPositionUs = ServerSideAdInsertionUtil.getStreamPositionUs(positionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
            long newActualPositionUs = this.actualMediaPeriod.seekToUs(actualRequestedPositionUs);
            return ServerSideAdInsertionUtil.getMediaPeriodPositionUs(newActualPositionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
        }

        public long getAdjustedSeekPositionUs(MediaPeriodImpl mediaPeriod, long positionUs, SeekParameters seekParameters) {
            long actualRequestedPositionUs = ServerSideAdInsertionUtil.getStreamPositionUs(positionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
            long adjustedActualPositionUs = this.actualMediaPeriod.getAdjustedSeekPositionUs(actualRequestedPositionUs, seekParameters);
            return ServerSideAdInsertionUtil.getMediaPeriodPositionUs(adjustedActualPositionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
        }

        public void discardBuffer(MediaPeriodImpl mediaPeriod, long positionUs, boolean toKeyframe) {
            long actualPositionUs = ServerSideAdInsertionUtil.getStreamPositionUs(positionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
            this.actualMediaPeriod.discardBuffer(actualPositionUs, toKeyframe);
        }

        public void reevaluateBuffer(MediaPeriodImpl mediaPeriod, long positionUs) {
            this.actualMediaPeriod.reevaluateBuffer(this.getStreamPositionUsWithNotYetStartedHandling(mediaPeriod, positionUs));
        }

        public long readDiscontinuity(MediaPeriodImpl mediaPeriod) {
            if (!mediaPeriod.equals(this.mediaPeriods.get(0))) {
                return -9223372036854775807L;
            }
            long actualDiscontinuityPositionUs = this.actualMediaPeriod.readDiscontinuity();
            return actualDiscontinuityPositionUs == -9223372036854775807L ? -9223372036854775807L : ServerSideAdInsertionUtil.getMediaPeriodPositionUs(actualDiscontinuityPositionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
        }

        public long selectTracks(MediaPeriodImpl mediaPeriod, @NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
            mediaPeriod.lastStartPositionUs = positionUs;
            if (mediaPeriod.equals(this.mediaPeriods.get(0))) {
                this.trackSelections = Arrays.copyOf(selections, selections.length);
                long requestedPositionUs = ServerSideAdInsertionUtil.getStreamPositionUs(positionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
                @NullableType SampleStream[] realStreams = this.sampleStreams.length == 0 ? new SampleStream[selections.length] : Arrays.copyOf(this.sampleStreams, this.sampleStreams.length);
                long startPositionUs = this.actualMediaPeriod.selectTracks(selections, mayRetainStreamFlags, realStreams, streamResetFlags, requestedPositionUs);
                this.sampleStreams = Arrays.copyOf(realStreams, realStreams.length);
                this.lastDownstreamFormatChangeData = Arrays.copyOf(this.lastDownstreamFormatChangeData, realStreams.length);
                for (int i = 0; i < realStreams.length; ++i) {
                    if (realStreams[i] == null) {
                        streams[i] = null;
                        this.lastDownstreamFormatChangeData[i] = null;
                        continue;
                    }
                    if (streams[i] != null && !streamResetFlags[i]) continue;
                    streams[i] = new SampleStreamImpl(mediaPeriod, i);
                    this.lastDownstreamFormatChangeData[i] = null;
                }
                return ServerSideAdInsertionUtil.getMediaPeriodPositionUs(startPositionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
            }
            for (int i = 0; i < selections.length; ++i) {
                if (selections[i] != null) {
                    boolean bl = streamResetFlags[i] = !mayRetainStreamFlags[i] || streams[i] == null;
                    if (!streamResetFlags[i]) continue;
                    streams[i] = Util.areEqual((Object)this.trackSelections[i], (Object)selections[i]) ? new SampleStreamImpl(mediaPeriod, i) : new EmptySampleStream();
                    continue;
                }
                streams[i] = null;
                streamResetFlags[i] = true;
            }
            return positionUs;
        }

        public int readData(MediaPeriodImpl mediaPeriod, int streamIndex, FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
            int peekingFlags = readFlags | 1 | 4;
            int result = ((SampleStream)Util.castNonNull((Object)this.sampleStreams[streamIndex])).readData(formatHolder, buffer, peekingFlags);
            long adjustedTimeUs = this.getMediaPeriodPositionUsWithEndOfSourceHandling(mediaPeriod, buffer.timeUs);
            if (result == -4 && adjustedTimeUs == Long.MIN_VALUE || result == -3 && this.getBufferedPositionUs(mediaPeriod) == Long.MIN_VALUE && !buffer.waitingForKeys) {
                this.maybeNotifyDownstreamFormatChanged(mediaPeriod, streamIndex);
                buffer.clear();
                buffer.addFlag(4);
                return -4;
            }
            if (result == -4) {
                this.maybeNotifyDownstreamFormatChanged(mediaPeriod, streamIndex);
                ((SampleStream)Util.castNonNull((Object)this.sampleStreams[streamIndex])).readData(formatHolder, buffer, readFlags);
                buffer.timeUs = adjustedTimeUs;
            }
            return result;
        }

        public int skipData(MediaPeriodImpl mediaPeriod, int streamIndex, long positionUs) {
            long actualPositionUs = ServerSideAdInsertionUtil.getStreamPositionUs(positionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
            return ((SampleStream)Util.castNonNull((Object)this.sampleStreams[streamIndex])).skipData(actualPositionUs);
        }

        public boolean isReady(int streamIndex) {
            return ((SampleStream)Util.castNonNull((Object)this.sampleStreams[streamIndex])).isReady();
        }

        public void maybeThrowError(int streamIndex) throws IOException {
            ((SampleStream)Util.castNonNull((Object)this.sampleStreams[streamIndex])).maybeThrowError();
        }

        public void onDownstreamFormatChanged(MediaPeriodImpl mediaPeriod, MediaLoadData mediaLoadData) {
            int streamIndex = this.findMatchingStreamIndex(mediaLoadData);
            if (streamIndex != -1) {
                this.lastDownstreamFormatChangeData[streamIndex] = mediaLoadData;
                mediaPeriod.hasNotifiedDownstreamFormatChange[streamIndex] = true;
            }
        }

        public void onLoadStarted(LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            this.activeLoads.put(loadEventInfo.loadTaskId, (Pair<LoadEventInfo, MediaLoadData>)Pair.create((Object)loadEventInfo, (Object)mediaLoadData));
        }

        public void onLoadFinished(LoadEventInfo loadEventInfo) {
            this.activeLoads.remove(loadEventInfo.loadTaskId);
        }

        @Override
        public void onPrepared(MediaPeriod actualMediaPeriod) {
            this.isPrepared = true;
            for (int i = 0; i < this.mediaPeriods.size(); ++i) {
                this.mediaPeriods.get(i).onPrepared();
            }
        }

        @Override
        public void onContinueLoadingRequested(MediaPeriod source) {
            if (this.loadingPeriod == null) {
                return;
            }
            ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.loadingPeriod.callback)).onContinueLoadingRequested(this.loadingPeriod);
        }

        private long getStreamPositionUsWithNotYetStartedHandling(MediaPeriodImpl mediaPeriod, long positionUs) {
            if (positionUs < mediaPeriod.lastStartPositionUs) {
                long actualStartPositionUs = ServerSideAdInsertionUtil.getStreamPositionUs(mediaPeriod.lastStartPositionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
                return actualStartPositionUs - (mediaPeriod.lastStartPositionUs - positionUs);
            }
            return ServerSideAdInsertionUtil.getStreamPositionUs(positionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
        }

        private long getMediaPeriodPositionUsWithEndOfSourceHandling(MediaPeriodImpl mediaPeriod, long positionUs) {
            long endPositionUs;
            if (positionUs == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            long mediaPeriodPositionUs = ServerSideAdInsertionUtil.getMediaPeriodPositionUs(positionUs, mediaPeriod.mediaPeriodId, this.adPlaybackState);
            return mediaPeriodPositionUs >= (endPositionUs = ServerSideAdInsertionMediaSource.getMediaPeriodEndPositionUs(mediaPeriod, this.adPlaybackState)) ? Long.MIN_VALUE : mediaPeriodPositionUs;
        }

        private int findMatchingStreamIndex(MediaLoadData mediaLoadData) {
            if (mediaLoadData.trackFormat == null) {
                return -1;
            }
            for (int i = 0; i < this.trackSelections.length; ++i) {
                if (this.trackSelections[i] == null) continue;
                TrackGroup trackGroup = this.trackSelections[i].getTrackGroup();
                boolean isPrimaryTrackGroup = mediaLoadData.trackType == 0 && trackGroup.equals((Object)this.getTrackGroups().get(0));
                for (int j = 0; j < trackGroup.length; ++j) {
                    Format format = trackGroup.getFormat(j);
                    if (!format.equals((Object)mediaLoadData.trackFormat) && (!isPrimaryTrackGroup || format.id == null || !format.id.equals(mediaLoadData.trackFormat.id))) continue;
                    return i;
                }
            }
            return -1;
        }

        private void maybeNotifyDownstreamFormatChanged(MediaPeriodImpl mediaPeriod, int streamIndex) {
            if (!mediaPeriod.hasNotifiedDownstreamFormatChange[streamIndex] && this.lastDownstreamFormatChangeData[streamIndex] != null) {
                mediaPeriod.hasNotifiedDownstreamFormatChange[streamIndex] = true;
                mediaPeriod.mediaSourceEventDispatcher.downstreamFormatChanged(ServerSideAdInsertionMediaSource.correctMediaLoadData(mediaPeriod, this.lastDownstreamFormatChangeData[streamIndex], this.adPlaybackState));
            }
        }
    }

    public static interface AdPlaybackStateUpdater {
        public boolean onAdPlaybackStateUpdateRequested(Timeline var1);
    }
}

