/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.mp4;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.Metadata;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.container.NalUnitUtil;
import androidx.media3.extractor.Ac4Util;
import androidx.media3.extractor.Extractor;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.ExtractorsFactory;
import androidx.media3.extractor.GaplessInfoHolder;
import androidx.media3.extractor.PositionHolder;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.SeekPoint;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.TrueHdSampleRechunker;
import androidx.media3.extractor.metadata.mp4.MotionPhotoMetadata;
import androidx.media3.extractor.mp4.Atom;
import androidx.media3.extractor.mp4.AtomParsers;
import androidx.media3.extractor.mp4.MetadataUtil;
import androidx.media3.extractor.mp4.SefReader;
import androidx.media3.extractor.mp4.Sniffer;
import androidx.media3.extractor.mp4.Track;
import androidx.media3.extractor.mp4.TrackSampleTable;
import com.google.common.base.Function;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class Mp4Extractor
implements Extractor,
SeekMap {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new Mp4Extractor()};
    public static final int FLAG_WORKAROUND_IGNORE_EDIT_LISTS = 1;
    public static final int FLAG_READ_MOTION_PHOTO_METADATA = 2;
    public static final int FLAG_READ_SEF_DATA = 4;
    private static final int STATE_READING_ATOM_HEADER = 0;
    private static final int STATE_READING_ATOM_PAYLOAD = 1;
    private static final int STATE_READING_SAMPLE = 2;
    private static final int STATE_READING_SEF = 3;
    private static final int FILE_TYPE_MP4 = 0;
    private static final int FILE_TYPE_QUICKTIME = 1;
    private static final int FILE_TYPE_HEIC = 2;
    private static final long RELOAD_MINIMUM_SEEK_DISTANCE = 262144L;
    private static final long MAXIMUM_READ_AHEAD_BYTES_STREAM = 0xA00000L;
    private final int flags;
    private final ParsableByteArray nalStartCode;
    private final ParsableByteArray nalLength;
    private final ParsableByteArray scratch;
    private final ParsableByteArray atomHeader;
    private final ArrayDeque<Atom.ContainerAtom> containerAtoms;
    private final SefReader sefReader;
    private final List<Metadata.Entry> slowMotionMetadataEntries;
    private int parserState;
    private int atomType;
    private long atomSize;
    private int atomHeaderBytesRead;
    @Nullable
    private ParsableByteArray atomData;
    private int sampleTrackIndex;
    private int sampleBytesRead;
    private int sampleBytesWritten;
    private int sampleCurrentNalBytesRemaining;
    private ExtractorOutput extractorOutput;
    private Mp4Track[] tracks;
    private long @MonotonicNonNull [][] accumulatedSampleSizes;
    private int firstVideoTrackIndex;
    private long durationUs;
    private int fileType;
    @Nullable
    private MotionPhotoMetadata motionPhotoMetadata;

    public Mp4Extractor() {
        this(0);
    }

    public Mp4Extractor(int flags) {
        this.flags = flags;
        this.parserState = (flags & 4) != 0 ? 3 : 0;
        this.sefReader = new SefReader();
        this.slowMotionMetadataEntries = new ArrayList<Metadata.Entry>();
        this.atomHeader = new ParsableByteArray(16);
        this.containerAtoms = new ArrayDeque();
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalLength = new ParsableByteArray(4);
        this.scratch = new ParsableByteArray();
        this.sampleTrackIndex = -1;
        this.extractorOutput = ExtractorOutput.PLACEHOLDER;
        this.tracks = new Mp4Track[0];
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        return Sniffer.sniffUnfragmented(input, (this.flags & 2) != 0);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
    }

    @Override
    public void seek(long position, long timeUs) {
        this.containerAtoms.clear();
        this.atomHeaderBytesRead = 0;
        this.sampleTrackIndex = -1;
        this.sampleBytesRead = 0;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        if (position == 0L) {
            if (this.parserState != 3) {
                this.enterReadingAtomHeaderState();
            } else {
                this.sefReader.reset();
                this.slowMotionMetadataEntries.clear();
            }
        } else {
            for (Mp4Track track : this.tracks) {
                this.updateSampleIndex(track, timeUs);
                if (track.trueHdSampleRechunker == null) continue;
                track.trueHdSampleRechunker.reset();
            }
        }
    }

    @Override
    public void release() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        block6: while (true) {
            switch (this.parserState) {
                case 0: {
                    if (this.readAtomHeader(input)) continue block6;
                    return -1;
                }
                case 1: {
                    if (this.readAtomPayload(input, seekPosition)) return 1;
                    continue block6;
                }
                case 2: {
                    return this.readSample(input, seekPosition);
                }
                case 3: {
                    return this.readSefData(input, seekPosition);
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        return this.getSeekPoints(timeUs, -1);
    }

    public SeekMap.SeekPoints getSeekPoints(long timeUs, int trackId) {
        long firstOffset;
        long firstTimeUs;
        int mainTrackIndex;
        if (this.tracks.length == 0) {
            return new SeekMap.SeekPoints(SeekPoint.START);
        }
        long secondTimeUs = -9223372036854775807L;
        long secondOffset = -1L;
        int n = mainTrackIndex = trackId != -1 ? trackId : this.firstVideoTrackIndex;
        if (mainTrackIndex != -1) {
            int secondSampleIndex;
            long sampleTimeUs;
            TrackSampleTable sampleTable = this.tracks[mainTrackIndex].sampleTable;
            int sampleIndex = Mp4Extractor.getSynchronizationSampleIndex(sampleTable, timeUs);
            if (sampleIndex == -1) {
                return new SeekMap.SeekPoints(SeekPoint.START);
            }
            firstTimeUs = sampleTimeUs = sampleTable.timestampsUs[sampleIndex];
            firstOffset = sampleTable.offsets[sampleIndex];
            if (sampleTimeUs < timeUs && sampleIndex < sampleTable.sampleCount - 1 && (secondSampleIndex = sampleTable.getIndexOfLaterOrEqualSynchronizationSample(timeUs)) != -1 && secondSampleIndex != sampleIndex) {
                secondTimeUs = sampleTable.timestampsUs[secondSampleIndex];
                secondOffset = sampleTable.offsets[secondSampleIndex];
            }
        } else {
            firstTimeUs = timeUs;
            firstOffset = Long.MAX_VALUE;
        }
        if (trackId == -1) {
            for (int i = 0; i < this.tracks.length; ++i) {
                if (i == this.firstVideoTrackIndex) continue;
                TrackSampleTable sampleTable = this.tracks[i].sampleTable;
                firstOffset = Mp4Extractor.maybeAdjustSeekOffset(sampleTable, firstTimeUs, firstOffset);
                if (secondTimeUs == -9223372036854775807L) continue;
                secondOffset = Mp4Extractor.maybeAdjustSeekOffset(sampleTable, secondTimeUs, secondOffset);
            }
        }
        SeekPoint firstSeekPoint = new SeekPoint(firstTimeUs, firstOffset);
        if (secondTimeUs == -9223372036854775807L) {
            return new SeekMap.SeekPoints(firstSeekPoint);
        }
        SeekPoint secondSeekPoint = new SeekPoint(secondTimeUs, secondOffset);
        return new SeekMap.SeekPoints(firstSeekPoint, secondSeekPoint);
    }

    private void enterReadingAtomHeaderState() {
        this.parserState = 0;
        this.atomHeaderBytesRead = 0;
    }

    private boolean readAtomHeader(ExtractorInput input) throws IOException {
        if (this.atomHeaderBytesRead == 0) {
            if (!input.readFully(this.atomHeader.getData(), 0, 8, true)) {
                this.processEndOfStreamReadingAtomHeader();
                return false;
            }
            this.atomHeaderBytesRead = 8;
            this.atomHeader.setPosition(0);
            this.atomSize = this.atomHeader.readUnsignedInt();
            this.atomType = this.atomHeader.readInt();
        }
        if (this.atomSize == 1L) {
            int headerBytesRemaining = 8;
            input.readFully(this.atomHeader.getData(), 8, headerBytesRemaining);
            this.atomHeaderBytesRead += headerBytesRemaining;
            this.atomSize = this.atomHeader.readUnsignedLongToLong();
        } else if (this.atomSize == 0L) {
            Atom.ContainerAtom containerAtom;
            long endPosition = input.getLength();
            if (endPosition == -1L && (containerAtom = this.containerAtoms.peek()) != null) {
                endPosition = containerAtom.endPosition;
            }
            if (endPosition != -1L) {
                this.atomSize = endPosition - input.getPosition() + (long)this.atomHeaderBytesRead;
            }
        }
        if (this.atomSize < (long)this.atomHeaderBytesRead) {
            throw ParserException.createForUnsupportedContainerFeature((String)"Atom size less than header length (unsupported).");
        }
        if (Mp4Extractor.shouldParseContainerAtom(this.atomType)) {
            long endPosition = input.getPosition() + this.atomSize - (long)this.atomHeaderBytesRead;
            if (this.atomSize != (long)this.atomHeaderBytesRead && this.atomType == 1835365473) {
                this.maybeSkipRemainingMetaAtomHeaderBytes(input);
            }
            this.containerAtoms.push(new Atom.ContainerAtom(this.atomType, endPosition));
            if (this.atomSize == (long)this.atomHeaderBytesRead) {
                this.processAtomEnded(endPosition);
            } else {
                this.enterReadingAtomHeaderState();
            }
        } else if (Mp4Extractor.shouldParseLeafAtom(this.atomType)) {
            Assertions.checkState((this.atomHeaderBytesRead == 8 ? 1 : 0) != 0);
            Assertions.checkState((this.atomSize <= Integer.MAX_VALUE ? 1 : 0) != 0);
            ParsableByteArray atomData = new ParsableByteArray((int)this.atomSize);
            System.arraycopy(this.atomHeader.getData(), 0, atomData.getData(), 0, 8);
            this.atomData = atomData;
            this.parserState = 1;
        } else {
            this.processUnparsedAtom(input.getPosition() - (long)this.atomHeaderBytesRead);
            this.atomData = null;
            this.parserState = 1;
        }
        return true;
    }

    private boolean readAtomPayload(ExtractorInput input, PositionHolder positionHolder) throws IOException {
        long atomPayloadSize = this.atomSize - (long)this.atomHeaderBytesRead;
        long atomEndPosition = input.getPosition() + atomPayloadSize;
        boolean seekRequired = false;
        ParsableByteArray atomData = this.atomData;
        if (atomData != null) {
            input.readFully(atomData.getData(), this.atomHeaderBytesRead, (int)atomPayloadSize);
            if (this.atomType == 1718909296) {
                this.fileType = Mp4Extractor.processFtypAtom(atomData);
            } else if (!this.containerAtoms.isEmpty()) {
                this.containerAtoms.peek().add(new Atom.LeafAtom(this.atomType, atomData));
            }
        } else if (atomPayloadSize < 262144L) {
            input.skipFully((int)atomPayloadSize);
        } else {
            positionHolder.position = input.getPosition() + atomPayloadSize;
            seekRequired = true;
        }
        this.processAtomEnded(atomEndPosition);
        return seekRequired && this.parserState != 2;
    }

    private int readSefData(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        int result = this.sefReader.read(input, seekPosition, this.slowMotionMetadataEntries);
        if (result == 1 && seekPosition.position == 0L) {
            this.enterReadingAtomHeaderState();
        }
        return result;
    }

    private void processAtomEnded(long atomEndPosition) throws ParserException {
        while (!this.containerAtoms.isEmpty() && this.containerAtoms.peek().endPosition == atomEndPosition) {
            Atom.ContainerAtom containerAtom = this.containerAtoms.pop();
            if (containerAtom.type == 1836019574) {
                this.processMoovAtom(containerAtom);
                this.containerAtoms.clear();
                this.parserState = 2;
                continue;
            }
            if (this.containerAtoms.isEmpty()) continue;
            this.containerAtoms.peek().add(containerAtom);
        }
        if (this.parserState != 2) {
            this.enterReadingAtomHeaderState();
        }
    }

    private void processMoovAtom(Atom.ContainerAtom moov) throws ParserException {
        int firstVideoTrackIndex = -1;
        long durationUs = -9223372036854775807L;
        ArrayList<Mp4Track> tracks = new ArrayList<Mp4Track>();
        Metadata udtaMetaMetadata = null;
        Metadata smtaMetadata = null;
        Metadata xyzMetadata = null;
        boolean isQuickTime = this.fileType == 1;
        GaplessInfoHolder gaplessInfoHolder = new GaplessInfoHolder();
        Atom.LeafAtom udta = moov.getLeafAtomOfType(1969517665);
        if (udta != null) {
            AtomParsers.UdtaInfo udtaInfo = AtomParsers.parseUdta(udta);
            udtaMetaMetadata = udtaInfo.metaMetadata;
            smtaMetadata = udtaInfo.smtaMetadata;
            xyzMetadata = udtaInfo.xyzMetadata;
            if (udtaMetaMetadata != null) {
                gaplessInfoHolder.setFromMetadata(udtaMetaMetadata);
            }
        }
        Metadata mdtaMetadata = null;
        Atom.ContainerAtom meta = moov.getContainerAtomOfType(1835365473);
        if (meta != null) {
            mdtaMetadata = AtomParsers.parseMdtaFromMeta(meta);
        }
        Metadata mvhdMetadata = AtomParsers.parseMvhd((ParsableByteArray)((Atom.LeafAtom)Assertions.checkNotNull((Object)moov.getLeafAtomOfType((int)1836476516))).data).metadata;
        boolean ignoreEditLists = (this.flags & 1) != 0;
        List<TrackSampleTable> trackSampleTables = AtomParsers.parseTraks(moov, gaplessInfoHolder, -9223372036854775807L, null, ignoreEditLists, isQuickTime, (Function<Track, Track>)((Function)track -> track));
        int trackCount = trackSampleTables.size();
        for (int i = 0; i < trackCount; ++i) {
            TrackSampleTable trackSampleTable = trackSampleTables.get(i);
            if (trackSampleTable.sampleCount == 0) continue;
            Track track2 = trackSampleTable.track;
            long trackDurationUs = track2.durationUs != -9223372036854775807L ? track2.durationUs : trackSampleTable.durationUs;
            durationUs = Math.max(durationUs, trackDurationUs);
            Mp4Track mp4Track = new Mp4Track(track2, trackSampleTable, this.extractorOutput.track(i, track2.type));
            int maxInputSize = "audio/true-hd".equals(track2.format.sampleMimeType) ? trackSampleTable.maximumSize * 16 : trackSampleTable.maximumSize + 30;
            Format.Builder formatBuilder = track2.format.buildUpon();
            formatBuilder.setMaxInputSize(maxInputSize);
            if (track2.type == 2 && trackDurationUs > 0L && trackSampleTable.sampleCount > 1) {
                float frameRate = (float)trackSampleTable.sampleCount / ((float)trackDurationUs / 1000000.0f);
                formatBuilder.setFrameRate(frameRate);
            }
            MetadataUtil.setFormatGaplessInfo(track2.type, gaplessInfoHolder, formatBuilder);
            MetadataUtil.setFormatMetadata(track2.type, udtaMetaMetadata, mdtaMetadata, formatBuilder, smtaMetadata, this.slowMotionMetadataEntries.isEmpty() ? null : new Metadata(this.slowMotionMetadataEntries), xyzMetadata, mvhdMetadata);
            mp4Track.trackOutput.format(formatBuilder.build());
            if (track2.type == 2 && firstVideoTrackIndex == -1) {
                firstVideoTrackIndex = tracks.size();
            }
            tracks.add(mp4Track);
        }
        this.firstVideoTrackIndex = firstVideoTrackIndex;
        this.durationUs = durationUs;
        this.tracks = tracks.toArray(new Mp4Track[0]);
        this.accumulatedSampleSizes = Mp4Extractor.calculateAccumulatedSampleSizes(this.tracks);
        this.extractorOutput.endTracks();
        this.extractorOutput.seekMap(this);
    }

    private int readSample(ExtractorInput input, PositionHolder positionHolder) throws IOException {
        long inputPosition = input.getPosition();
        if (this.sampleTrackIndex == -1) {
            this.sampleTrackIndex = this.getTrackIndexOfNextReadSample(inputPosition);
            if (this.sampleTrackIndex == -1) {
                return -1;
            }
        }
        Mp4Track track = this.tracks[this.sampleTrackIndex];
        TrackOutput trackOutput = track.trackOutput;
        int sampleIndex = track.sampleIndex;
        long position = track.sampleTable.offsets[sampleIndex];
        int sampleSize = track.sampleTable.sizes[sampleIndex];
        TrueHdSampleRechunker trueHdSampleRechunker = track.trueHdSampleRechunker;
        long skipAmount = position - inputPosition + (long)this.sampleBytesRead;
        if (skipAmount < 0L || skipAmount >= 262144L) {
            positionHolder.position = position;
            return 1;
        }
        if (track.track.sampleTransformation == 1) {
            skipAmount += 8L;
            sampleSize -= 8;
        }
        input.skipFully((int)skipAmount);
        if (track.track.nalUnitLengthFieldLength != 0) {
            byte[] nalLengthData = this.nalLength.getData();
            nalLengthData[0] = 0;
            nalLengthData[1] = 0;
            nalLengthData[2] = 0;
            int nalUnitLengthFieldLength = track.track.nalUnitLengthFieldLength;
            int nalUnitLengthFieldLengthDiff = 4 - track.track.nalUnitLengthFieldLength;
            while (this.sampleBytesWritten < sampleSize) {
                if (this.sampleCurrentNalBytesRemaining == 0) {
                    input.readFully(nalLengthData, nalUnitLengthFieldLengthDiff, nalUnitLengthFieldLength);
                    this.sampleBytesRead += nalUnitLengthFieldLength;
                    this.nalLength.setPosition(0);
                    int nalLengthInt = this.nalLength.readInt();
                    if (nalLengthInt < 0) {
                        throw ParserException.createForMalformedContainer((String)"Invalid NAL length", null);
                    }
                    this.sampleCurrentNalBytesRemaining = nalLengthInt;
                    this.nalStartCode.setPosition(0);
                    trackOutput.sampleData(this.nalStartCode, 4);
                    this.sampleBytesWritten += 4;
                    sampleSize += nalUnitLengthFieldLengthDiff;
                    continue;
                }
                int writtenBytes = trackOutput.sampleData(input, this.sampleCurrentNalBytesRemaining, false);
                this.sampleBytesRead += writtenBytes;
                this.sampleBytesWritten += writtenBytes;
                this.sampleCurrentNalBytesRemaining -= writtenBytes;
            }
        } else {
            if ("audio/ac4".equals(track.track.format.sampleMimeType)) {
                if (this.sampleBytesWritten == 0) {
                    Ac4Util.getAc4SampleHeader(sampleSize, this.scratch);
                    trackOutput.sampleData(this.scratch, 7);
                    this.sampleBytesWritten += 7;
                }
                sampleSize += 7;
            } else if (trueHdSampleRechunker != null) {
                trueHdSampleRechunker.startSample(input);
            }
            while (this.sampleBytesWritten < sampleSize) {
                int writtenBytes = trackOutput.sampleData(input, sampleSize - this.sampleBytesWritten, false);
                this.sampleBytesRead += writtenBytes;
                this.sampleBytesWritten += writtenBytes;
                this.sampleCurrentNalBytesRemaining -= writtenBytes;
            }
        }
        long timeUs = track.sampleTable.timestampsUs[sampleIndex];
        int flags = track.sampleTable.flags[sampleIndex];
        if (trueHdSampleRechunker != null) {
            trueHdSampleRechunker.sampleMetadata(trackOutput, timeUs, flags, sampleSize, 0, null);
            if (sampleIndex + 1 == track.sampleTable.sampleCount) {
                trueHdSampleRechunker.outputPendingSampleMetadata(trackOutput, null);
            }
        } else {
            trackOutput.sampleMetadata(timeUs, flags, sampleSize, 0, null);
        }
        ++track.sampleIndex;
        this.sampleTrackIndex = -1;
        this.sampleBytesRead = 0;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        return 0;
    }

    private int getTrackIndexOfNextReadSample(long inputPosition) {
        long preferredSkipAmount = Long.MAX_VALUE;
        boolean preferredRequiresReload = true;
        int preferredTrackIndex = -1;
        long preferredAccumulatedBytes = Long.MAX_VALUE;
        long minAccumulatedBytes = Long.MAX_VALUE;
        boolean minAccumulatedBytesRequiresReload = true;
        int minAccumulatedBytesTrackIndex = -1;
        for (int trackIndex = 0; trackIndex < this.tracks.length; ++trackIndex) {
            boolean requiresReload;
            Mp4Track track = this.tracks[trackIndex];
            int sampleIndex = track.sampleIndex;
            if (sampleIndex == track.sampleTable.sampleCount) continue;
            long sampleOffset = track.sampleTable.offsets[sampleIndex];
            long sampleAccumulatedBytes = ((long[][])Util.castNonNull((Object)this.accumulatedSampleSizes))[trackIndex][sampleIndex];
            long skipAmount = sampleOffset - inputPosition;
            boolean bl = requiresReload = skipAmount < 0L || skipAmount >= 262144L;
            if (!requiresReload && preferredRequiresReload || requiresReload == preferredRequiresReload && skipAmount < preferredSkipAmount) {
                preferredRequiresReload = requiresReload;
                preferredSkipAmount = skipAmount;
                preferredTrackIndex = trackIndex;
                preferredAccumulatedBytes = sampleAccumulatedBytes;
            }
            if (sampleAccumulatedBytes >= minAccumulatedBytes) continue;
            minAccumulatedBytes = sampleAccumulatedBytes;
            minAccumulatedBytesRequiresReload = requiresReload;
            minAccumulatedBytesTrackIndex = trackIndex;
        }
        return minAccumulatedBytes == Long.MAX_VALUE || !minAccumulatedBytesRequiresReload || preferredAccumulatedBytes < minAccumulatedBytes + 0xA00000L ? preferredTrackIndex : minAccumulatedBytesTrackIndex;
    }

    private void updateSampleIndex(Mp4Track track, long timeUs) {
        TrackSampleTable sampleTable = track.sampleTable;
        int sampleIndex = sampleTable.getIndexOfEarlierOrEqualSynchronizationSample(timeUs);
        if (sampleIndex == -1) {
            sampleIndex = sampleTable.getIndexOfLaterOrEqualSynchronizationSample(timeUs);
        }
        track.sampleIndex = sampleIndex;
    }

    private void processEndOfStreamReadingAtomHeader() {
        if (this.fileType == 2 && (this.flags & 2) != 0) {
            TrackOutput trackOutput = this.extractorOutput.track(0, 4);
            Metadata metadata = this.motionPhotoMetadata == null ? null : new Metadata(new Metadata.Entry[]{this.motionPhotoMetadata});
            trackOutput.format(new Format.Builder().setMetadata(metadata).build());
            this.extractorOutput.endTracks();
            this.extractorOutput.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
        }
    }

    private void maybeSkipRemainingMetaAtomHeaderBytes(ExtractorInput input) throws IOException {
        this.scratch.reset(8);
        input.peekFully(this.scratch.getData(), 0, 8);
        AtomParsers.maybeSkipRemainingMetaAtomHeaderBytes(this.scratch);
        input.skipFully(this.scratch.getPosition());
        input.resetPeekPosition();
    }

    private void processUnparsedAtom(long atomStartPosition) {
        if (this.atomType == 1836086884) {
            this.motionPhotoMetadata = new MotionPhotoMetadata(0L, atomStartPosition, -9223372036854775807L, atomStartPosition + (long)this.atomHeaderBytesRead, this.atomSize - (long)this.atomHeaderBytesRead);
        }
    }

    private static long[][] calculateAccumulatedSampleSizes(Mp4Track[] tracks) {
        long[][] accumulatedSampleSizes = new long[tracks.length][];
        int[] nextSampleIndex = new int[tracks.length];
        long[] nextSampleTimesUs = new long[tracks.length];
        boolean[] tracksFinished = new boolean[tracks.length];
        for (int i = 0; i < tracks.length; ++i) {
            accumulatedSampleSizes[i] = new long[tracks[i].sampleTable.sampleCount];
            nextSampleTimesUs[i] = tracks[i].sampleTable.timestampsUs[0];
        }
        long accumulatedSampleSize = 0L;
        int finishedTracks = 0;
        while (finishedTracks < tracks.length) {
            long minTimeUs = Long.MAX_VALUE;
            int minTimeTrackIndex = -1;
            for (int i = 0; i < tracks.length; ++i) {
                if (tracksFinished[i] || nextSampleTimesUs[i] > minTimeUs) continue;
                minTimeTrackIndex = i;
                minTimeUs = nextSampleTimesUs[i];
            }
            int trackSampleIndex = nextSampleIndex[minTimeTrackIndex];
            accumulatedSampleSizes[minTimeTrackIndex][trackSampleIndex] = accumulatedSampleSize;
            accumulatedSampleSize += (long)tracks[minTimeTrackIndex].sampleTable.sizes[trackSampleIndex];
            nextSampleIndex[minTimeTrackIndex] = ++trackSampleIndex;
            if (trackSampleIndex < accumulatedSampleSizes[minTimeTrackIndex].length) {
                nextSampleTimesUs[minTimeTrackIndex] = tracks[minTimeTrackIndex].sampleTable.timestampsUs[trackSampleIndex];
                continue;
            }
            tracksFinished[minTimeTrackIndex] = true;
            ++finishedTracks;
        }
        return accumulatedSampleSizes;
    }

    private static long maybeAdjustSeekOffset(TrackSampleTable sampleTable, long seekTimeUs, long offset) {
        int sampleIndex = Mp4Extractor.getSynchronizationSampleIndex(sampleTable, seekTimeUs);
        if (sampleIndex == -1) {
            return offset;
        }
        long sampleOffset = sampleTable.offsets[sampleIndex];
        return Math.min(sampleOffset, offset);
    }

    private static int getSynchronizationSampleIndex(TrackSampleTable sampleTable, long timeUs) {
        int sampleIndex = sampleTable.getIndexOfEarlierOrEqualSynchronizationSample(timeUs);
        if (sampleIndex == -1) {
            sampleIndex = sampleTable.getIndexOfLaterOrEqualSynchronizationSample(timeUs);
        }
        return sampleIndex;
    }

    private static int processFtypAtom(ParsableByteArray atomData) {
        atomData.setPosition(8);
        int majorBrand = atomData.readInt();
        int fileType = Mp4Extractor.brandToFileType(majorBrand);
        if (fileType != 0) {
            return fileType;
        }
        atomData.skipBytes(4);
        while (atomData.bytesLeft() > 0) {
            fileType = Mp4Extractor.brandToFileType(atomData.readInt());
            if (fileType == 0) continue;
            return fileType;
        }
        return 0;
    }

    private static int brandToFileType(int brand) {
        switch (brand) {
            case 1903435808: {
                return 1;
            }
            case 1751476579: {
                return 2;
            }
        }
        return 0;
    }

    private static boolean shouldParseLeafAtom(int atom) {
        return atom == 1835296868 || atom == 1836476516 || atom == 1751411826 || atom == 1937011556 || atom == 0x73747473 || atom == 0x73747373 || atom == 1668576371 || atom == 1701606260 || atom == 1937011555 || atom == 1937011578 || atom == 1937013298 || atom == 1937007471 || atom == 1668232756 || atom == 1953196132 || atom == 1718909296 || atom == 1969517665 || atom == 1801812339 || atom == 1768715124;
    }

    private static boolean shouldParseContainerAtom(int atom) {
        return atom == 1836019574 || atom == 1953653099 || atom == 1835297121 || atom == 1835626086 || atom == 1937007212 || atom == 1701082227 || atom == 1835365473;
    }

    private static final class Mp4Track {
        public final Track track;
        public final TrackSampleTable sampleTable;
        public final TrackOutput trackOutput;
        @Nullable
        public final TrueHdSampleRechunker trueHdSampleRechunker;
        public int sampleIndex;

        public Mp4Track(Track track, TrackSampleTable sampleTable, TrackOutput trackOutput) {
            this.track = track;
            this.sampleTable = sampleTable;
            this.trackOutput = trackOutput;
            this.trueHdSampleRechunker = "audio/true-hd".equals(track.format.sampleMimeType) ? new TrueHdSampleRechunker() : null;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }
}

