/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text.ssa;

import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.text.Subtitle;
import java.util.Collections;
import java.util.List;

final class SsaSubtitle
implements Subtitle {
    private final List<List<Cue>> cues;
    private final List<Long> cueTimesUs;

    public SsaSubtitle(List<List<Cue>> cues, List<Long> cueTimesUs) {
        this.cues = cues;
        this.cueTimesUs = cueTimesUs;
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        int index = Util.binarySearchCeil(this.cueTimesUs, (Comparable)Long.valueOf(timeUs), (boolean)false, (boolean)false);
        return index < this.cueTimesUs.size() ? index : -1;
    }

    @Override
    public int getEventTimeCount() {
        return this.cueTimesUs.size();
    }

    @Override
    public long getEventTime(int index) {
        Assertions.checkArgument((index >= 0 ? 1 : 0) != 0);
        Assertions.checkArgument((index < this.cueTimesUs.size() ? 1 : 0) != 0);
        return this.cueTimesUs.get(index);
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        int index = Util.binarySearchFloor(this.cueTimesUs, (Comparable)Long.valueOf(timeUs), (boolean)true, (boolean)false);
        if (index == -1) {
            return Collections.emptyList();
        }
        return this.cues.get(index);
    }
}

