/*
 * Decompiled with CFR 0.152.
 */
package com.renderheads.AVPro.Video;

import androidx.media3.common.Format;
import androidx.media3.common.Metadata;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.Player;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.Tracks;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.metadata.MetadataOutput;
import androidx.media3.exoplayer.trackselection.DefaultTrackSelector;
import androidx.media3.exoplayer.trackselection.TrackSelection;
import androidx.media3.extractor.metadata.emsg.EventMessage;
import androidx.media3.extractor.metadata.id3.ApicFrame;
import androidx.media3.extractor.metadata.id3.CommentFrame;
import androidx.media3.extractor.metadata.id3.GeobFrame;
import androidx.media3.extractor.metadata.id3.Id3Frame;
import androidx.media3.extractor.metadata.id3.PrivFrame;
import androidx.media3.extractor.metadata.id3.TextInformationFrame;
import androidx.media3.extractor.metadata.id3.UrlLinkFrame;

final class PlayerEventListener
implements Player.Listener,
MetadataOutput {
    private final String TAG;
    private DefaultTrackSelector m_TrackSelector;

    public PlayerEventListener(DefaultTrackSelector defaultTrackSelector) {
        this.TAG = "AVProVideo";
        this.m_TrackSelector = defaultTrackSelector;
    }

    private void printMetadata(Metadata metadata, String string) {
        for (int i = 0; i < metadata.length(); ++i) {
            Object[] objectArray;
            string = metadata.get(i);
            if (string instanceof TextInformationFrame) {
                string = (TextInformationFrame)string;
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = ((TextInformationFrame)string).id;
                objectArray2[1] = ((TextInformationFrame)string).value;
                String.format("%s: value=%s", objectArray);
                continue;
            }
            if (string instanceof UrlLinkFrame) {
                string = (UrlLinkFrame)string;
                Object[] objectArray3 = new Object[2];
                objectArray = objectArray3;
                objectArray[0] = ((UrlLinkFrame)string).id;
                objectArray3[1] = ((UrlLinkFrame)string).url;
                String.format("%s: url=%s", objectArray);
                continue;
            }
            if (string instanceof PrivFrame) {
                string = (PrivFrame)string;
                Object[] objectArray4 = new Object[2];
                objectArray = objectArray4;
                objectArray[0] = ((PrivFrame)string).id;
                objectArray4[1] = ((PrivFrame)string).owner;
                String.format("%s: owner=%s", objectArray);
                continue;
            }
            if (string instanceof GeobFrame) {
                string = (GeobFrame)string;
                Object[] objectArray5 = new Object[4];
                objectArray = objectArray5;
                objectArray[0] = ((GeobFrame)string).id;
                objectArray[1] = ((GeobFrame)string).mimeType;
                objectArray[2] = ((GeobFrame)string).filename;
                objectArray5[3] = ((GeobFrame)string).description;
                String.format("%s: mimeType=%s, filename=%s, description=%s", objectArray);
                continue;
            }
            if (string instanceof ApicFrame) {
                string = (ApicFrame)string;
                Object[] objectArray6 = new Object[3];
                objectArray = objectArray6;
                objectArray[0] = ((ApicFrame)string).id;
                objectArray[1] = ((ApicFrame)string).mimeType;
                objectArray6[2] = ((ApicFrame)string).description;
                String.format("%s: mimeType=%s, description=%s", objectArray);
                continue;
            }
            if (string instanceof CommentFrame) {
                string = (CommentFrame)string;
                Object[] objectArray7 = new Object[3];
                objectArray = objectArray7;
                objectArray[0] = ((CommentFrame)string).id;
                objectArray[1] = ((CommentFrame)string).language;
                objectArray7[2] = ((CommentFrame)string).description;
                String.format("%s: language=%s, description=%s", objectArray);
                continue;
            }
            if (string instanceof Id3Frame) {
                string = (Id3Frame)string;
                Object[] objectArray8 = new Object[1];
                objectArray = objectArray8;
                objectArray8[0] = ((Id3Frame)string).id;
                String.format("%s", objectArray);
                continue;
            }
            if (!(string instanceof EventMessage)) continue;
            string = (EventMessage)string;
            Object[] objectArray9 = new Object[3];
            objectArray = objectArray9;
            objectArray[0] = ((EventMessage)string).schemeIdUri;
            objectArray[1] = ((EventMessage)string).id;
            objectArray9[2] = ((EventMessage)string).value;
            String.format("EMSG: scheme=%s, id=%d, value=%s", objectArray);
        }
    }

    private static String getStateString(int n) {
        switch (n) {
            default: {
                return "?";
            }
            case 4: {
                return "E";
            }
            case 3: {
                return "R";
            }
            case 2: {
                return "B";
            }
            case 1: 
        }
        return "I";
    }

    public static String getAdaptiveSupportString(int n, int n2) {
        if (n < 2) {
            return "N/A";
        }
        if (n2 != 0) {
            if (n2 != 8) {
                if (n2 != 16) {
                    return "?";
                }
                return "YES";
            }
            return "YES_NOT_SEAMLESS";
        }
        return "NO";
    }

    public static String getTrackStatusString(TrackSelection trackSelection, TrackGroup trackGroup, int n) {
        return PlayerEventListener.getTrackStatusString(trackSelection != null && trackSelection.getTrackGroup() == trackGroup && trackSelection.indexOf(n) != -1);
    }

    private static String getTrackStatusString(boolean bl) {
        return bl ? "[X]" : "[ ]";
    }

    private static String getRepeatModeString(int n) {
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    return "?";
                }
                return "ALL";
            }
            return "ONE";
        }
        return "OFF";
    }

    public void onPlaybackStateChanged(int n) {
    }

    public void onPlayerError(PlaybackException playbackException) {
    }

    public void onTracksChanged(Tracks tracks) {
        Metadata metadata;
        int n;
        tracks = tracks.getGroups();
        for (n = 0; n < tracks.size(); ++n) {
            Tracks.Group group = (Tracks.Group)tracks.get(n);
            for (int i = 0; i < group.length; ++i) {
                PlayerEventListener.getTrackStatusString(group.isTrackSelected(i));
                Util.getFormatSupportString((int)group.getTrackSupport(i));
                Object object = group.getTrackFormat(i);
                Format.toLogString((Format)object);
                int cfr_ignored_0 = ((Format)object).stereoMode;
                metadata = ((Format)object).colorInfo;
                if (metadata != null) {
                    metadata.toString();
                }
                if ((object = ((Format)object).codecs) == null) continue;
                ((String)object).toString();
            }
        }
        n = 0;
        for (int i = 0; n == 0 && i < tracks.size(); ++i) {
            Tracks.Group group = (Tracks.Group)tracks.get(i);
            for (int j = 0; n == 0 && j < group.length; ++j) {
                if (!group.isTrackSelected(j) || (metadata = group.getTrackFormat((int)j).metadata) == null || metadata.length() <= 0) continue;
                this.printMetadata(metadata, "        ");
                n = 1;
            }
        }
    }

    public void onMetadata(Metadata metadata) {
        metadata.toString();
    }
}

