/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import android.annotation.SuppressLint;
import androidx.media3.common.Format;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.Renderer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@UnstableApi
public interface RendererCapabilities {
    public static final int FORMAT_SUPPORT_MASK = 7;
    @Deprecated
    public static final int FORMAT_HANDLED = 4;
    @Deprecated
    public static final int FORMAT_EXCEEDS_CAPABILITIES = 3;
    @Deprecated
    public static final int FORMAT_UNSUPPORTED_DRM = 2;
    @Deprecated
    public static final int FORMAT_UNSUPPORTED_SUBTYPE = 1;
    @Deprecated
    public static final int FORMAT_UNSUPPORTED_TYPE = 0;
    public static final int ADAPTIVE_SUPPORT_MASK = 24;
    public static final int ADAPTIVE_SEAMLESS = 16;
    public static final int ADAPTIVE_NOT_SEAMLESS = 8;
    public static final int ADAPTIVE_NOT_SUPPORTED = 0;
    public static final int TUNNELING_SUPPORT_MASK = 32;
    public static final int TUNNELING_SUPPORTED = 32;
    public static final int TUNNELING_NOT_SUPPORTED = 0;
    public static final int HARDWARE_ACCELERATION_SUPPORT_MASK = 64;
    public static final int HARDWARE_ACCELERATION_SUPPORTED = 64;
    public static final int HARDWARE_ACCELERATION_NOT_SUPPORTED = 0;
    public static final int MODE_SUPPORT_MASK = 384;
    public static final int DECODER_SUPPORT_FALLBACK_MIMETYPE = 256;
    public static final int DECODER_SUPPORT_PRIMARY = 128;
    public static final int DECODER_SUPPORT_FALLBACK = 0;

    public static int create(int formatSupport) {
        return RendererCapabilities.create(formatSupport, 0, 0);
    }

    public static int create(int formatSupport, int adaptiveSupport, int tunnelingSupport) {
        return RendererCapabilities.create(formatSupport, adaptiveSupport, tunnelingSupport, 0, 128);
    }

    @SuppressLint(value={"WrongConstant"})
    public static int create(int formatSupport, int adaptiveSupport, int tunnelingSupport, int hardwareAccelerationSupport, int decoderSupport) {
        return formatSupport | adaptiveSupport | tunnelingSupport | hardwareAccelerationSupport | decoderSupport;
    }

    @SuppressLint(value={"WrongConstant"})
    public static int getFormatSupport(int supportFlags) {
        return supportFlags & 7;
    }

    @SuppressLint(value={"WrongConstant"})
    public static int getAdaptiveSupport(int supportFlags) {
        return supportFlags & 0x18;
    }

    @SuppressLint(value={"WrongConstant"})
    public static int getTunnelingSupport(int supportFlags) {
        return supportFlags & 0x20;
    }

    @SuppressLint(value={"WrongConstant"})
    public static int getHardwareAccelerationSupport(int supportFlags) {
        return supportFlags & 0x40;
    }

    @SuppressLint(value={"WrongConstant"})
    public static int getDecoderSupport(int supportFlags) {
        return supportFlags & 0x180;
    }

    public String getName();

    public int getTrackType();

    public int supportsFormat(Format var1) throws ExoPlaybackException;

    public int supportsMixedMimeTypeAdaptation() throws ExoPlaybackException;

    default public void setListener(Listener listener) {
    }

    default public void clearListener() {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Capabilities {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface DecoderSupport {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface HardwareAccelerationSupport {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface TunnelingSupport {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface AdaptiveSupport {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    @Deprecated
    public static @interface FormatSupport {
    }

    public static interface Listener {
        public void onRendererCapabilitiesChanged(Renderer var1);
    }
}

