/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.upstream.experimental;

import androidx.annotation.VisibleForTesting;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSpec;
import androidx.media3.exoplayer.upstream.TimeToFirstByteEstimator;
import java.util.LinkedHashMap;
import java.util.Map;

@UnstableApi
public final class ExponentialWeightedAverageTimeToFirstByteEstimator
implements TimeToFirstByteEstimator {
    public static final double DEFAULT_SMOOTHING_FACTOR = 0.85;
    private static final int MAX_DATA_SPECS = 10;
    private final LinkedHashMap<DataSpec, Long> initializedDataSpecs;
    private final double smoothingFactor;
    private final Clock clock;
    private long estimateUs;

    public ExponentialWeightedAverageTimeToFirstByteEstimator() {
        this(0.85, Clock.DEFAULT);
    }

    public ExponentialWeightedAverageTimeToFirstByteEstimator(double smoothingFactor) {
        this(smoothingFactor, Clock.DEFAULT);
    }

    @VisibleForTesting
    ExponentialWeightedAverageTimeToFirstByteEstimator(double smoothingFactor, Clock clock) {
        this.smoothingFactor = smoothingFactor;
        this.clock = clock;
        this.initializedDataSpecs = new FixedSizeLinkedHashMap<DataSpec, Long>(10);
        this.estimateUs = -9223372036854775807L;
    }

    @Override
    public long getTimeToFirstByteEstimateUs() {
        return this.estimateUs;
    }

    @Override
    public void reset() {
        this.estimateUs = -9223372036854775807L;
    }

    @Override
    public void onTransferInitializing(DataSpec dataSpec) {
        this.initializedDataSpecs.remove(dataSpec);
        this.initializedDataSpecs.put(dataSpec, Util.msToUs((long)this.clock.elapsedRealtime()));
    }

    @Override
    public void onTransferStart(DataSpec dataSpec) {
        Long initializationStartUs = (Long)this.initializedDataSpecs.remove(dataSpec);
        if (initializationStartUs == null) {
            return;
        }
        long timeToStartSampleUs = Util.msToUs((long)this.clock.elapsedRealtime()) - initializationStartUs;
        this.estimateUs = this.estimateUs == -9223372036854775807L ? timeToStartSampleUs : (long)(this.smoothingFactor * (double)this.estimateUs + (1.0 - this.smoothingFactor) * (double)timeToStartSampleUs);
    }

    private static class FixedSizeLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        public FixedSizeLinkedHashMap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

