/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text.cea;

import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.extractor.text.Subtitle;
import java.util.Collections;
import java.util.List;

final class CeaSubtitle
implements Subtitle {
    private final List<Cue> cues;

    public CeaSubtitle(List<Cue> cues) {
        this.cues = cues;
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        return timeUs < 0L ? 0 : -1;
    }

    @Override
    public int getEventTimeCount() {
        return 1;
    }

    @Override
    public long getEventTime(int index) {
        Assertions.checkArgument((index == 0 ? 1 : 0) != 0);
        return 0L;
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        return timeUs >= 0L ? this.cues : Collections.emptyList();
    }
}

