/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;

@UnstableApi
public final class SurfaceInfo {
    public final Surface surface;
    public final int width;
    public final int height;
    public final int orientationDegrees;

    public SurfaceInfo(Surface surface, int width, int height) {
        this(surface, width, height, 0);
    }

    public SurfaceInfo(Surface surface, int width, int height, int orientationDegrees) {
        Assertions.checkArgument(orientationDegrees == 0 || orientationDegrees == 90 || orientationDegrees == 180 || orientationDegrees == 270, "orientationDegrees must be 0, 90, 180, or 270");
        this.surface = surface;
        this.width = width;
        this.height = height;
        this.orientationDegrees = orientationDegrees;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SurfaceInfo)) {
            return false;
        }
        SurfaceInfo that = (SurfaceInfo)o;
        return this.width == that.width && this.height == that.height && this.orientationDegrees == that.orientationDegrees && this.surface.equals(that.surface);
    }

    public int hashCode() {
        int result = this.surface.hashCode();
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.orientationDegrees;
        return result;
    }
}

