/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import java.util.Arrays;

@UnstableApi
public abstract class LibraryLoader {
    private static final String TAG = "LibraryLoader";
    private String[] nativeLibraries;
    private boolean loadAttempted;
    private boolean isAvailable;

    public LibraryLoader(String ... libraries) {
        this.nativeLibraries = libraries;
    }

    public synchronized void setLibraries(String ... libraries) {
        Assertions.checkState(!this.loadAttempted, "Cannot set libraries after loading");
        this.nativeLibraries = libraries;
    }

    public synchronized boolean isAvailable() {
        if (this.loadAttempted) {
            return this.isAvailable;
        }
        this.loadAttempted = true;
        try {
            for (String lib : this.nativeLibraries) {
                this.loadLibrary(lib);
            }
            this.isAvailable = true;
        }
        catch (UnsatisfiedLinkError exception) {
            Log.w(TAG, "Failed to load " + Arrays.toString(this.nativeLibraries));
        }
        return this.isAvailable;
    }

    protected abstract void loadLibrary(String var1);
}

