/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.FlacStreamMetadata;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.SeekPoint;

@UnstableApi
public final class FlacSeekTableSeekMap
implements SeekMap {
    private final FlacStreamMetadata flacStreamMetadata;
    private final long firstFrameOffset;

    public FlacSeekTableSeekMap(FlacStreamMetadata flacStreamMetadata, long firstFrameOffset) {
        this.flacStreamMetadata = flacStreamMetadata;
        this.firstFrameOffset = firstFrameOffset;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long getDurationUs() {
        return this.flacStreamMetadata.getDurationUs();
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        Assertions.checkStateNotNull((Object)this.flacStreamMetadata.seekTable);
        long[] pointSampleNumbers = this.flacStreamMetadata.seekTable.pointSampleNumbers;
        long[] pointOffsets = this.flacStreamMetadata.seekTable.pointOffsets;
        long targetSampleNumber = this.flacStreamMetadata.getSampleNumber(timeUs);
        int index = Util.binarySearchFloor((long[])pointSampleNumbers, (long)targetSampleNumber, (boolean)true, (boolean)false);
        long seekPointSampleNumber = index == -1 ? 0L : pointSampleNumbers[index];
        long seekPointOffsetFromFirstFrame = index == -1 ? 0L : pointOffsets[index];
        SeekPoint seekPoint = this.getSeekPoint(seekPointSampleNumber, seekPointOffsetFromFirstFrame);
        if (seekPoint.timeUs == timeUs || index == pointSampleNumbers.length - 1) {
            return new SeekMap.SeekPoints(seekPoint);
        }
        SeekPoint secondSeekPoint = this.getSeekPoint(pointSampleNumbers[index + 1], pointOffsets[index + 1]);
        return new SeekMap.SeekPoints(seekPoint, secondSeekPoint);
    }

    private SeekPoint getSeekPoint(long sampleNumber, long offsetFromFirstFrame) {
        long seekTimeUs = sampleNumber * 1000000L / (long)this.flacStreamMetadata.sampleRate;
        long seekPosition = this.firstFrameOffset + offsetFromFirstFrame;
        return new SeekPoint(seekTimeUs, seekPosition);
    }
}

