/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.jpeg;

import androidx.media3.common.util.Assertions;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ForwardingExtractorInput;

final class StartOffsetExtractorInput
extends ForwardingExtractorInput {
    private final long startOffset;

    public StartOffsetExtractorInput(ExtractorInput input, long startOffset) {
        super(input);
        Assertions.checkArgument((input.getPosition() >= startOffset ? 1 : 0) != 0);
        this.startOffset = startOffset;
    }

    @Override
    public long getPosition() {
        return super.getPosition() - this.startOffset;
    }

    @Override
    public long getPeekPosition() {
        return super.getPeekPosition() - this.startOffset;
    }

    @Override
    public long getLength() {
        return super.getLength() - this.startOffset;
    }

    @Override
    public <E extends Throwable> void setRetryPosition(long position, E e) throws E {
        super.setRetryPosition(position + this.startOffset, e);
    }
}

