/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.metadata.emsg;

import androidx.media3.common.Metadata;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.metadata.MetadataInputBuffer;
import androidx.media3.extractor.metadata.SimpleMetadataDecoder;
import androidx.media3.extractor.metadata.emsg.EventMessage;
import java.nio.ByteBuffer;
import java.util.Arrays;

@UnstableApi
public final class EventMessageDecoder
extends SimpleMetadataDecoder {
    @Override
    protected Metadata decode(MetadataInputBuffer inputBuffer, ByteBuffer buffer) {
        return new Metadata(new Metadata.Entry[]{this.decode(new ParsableByteArray(buffer.array(), buffer.limit()))});
    }

    public EventMessage decode(ParsableByteArray emsgData) {
        String schemeIdUri = (String)Assertions.checkNotNull((Object)emsgData.readNullTerminatedString());
        String value = (String)Assertions.checkNotNull((Object)emsgData.readNullTerminatedString());
        long durationMs = emsgData.readLong();
        long id = emsgData.readLong();
        byte[] messageData = Arrays.copyOfRange(emsgData.getData(), emsgData.getPosition(), emsgData.limit());
        return new EventMessage(schemeIdUri, value, durationMs, id, messageData);
    }
}

