/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360;

import com.twobigears.audio360.AssetDescriptor;
import com.twobigears.audio360.Audio360JNI;
import com.twobigears.audio360.SWIGTYPE_p_void;
import java.nio.ByteBuffer;

public class IOStream {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IOStream(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IOStream obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                Audio360JNI.delete_IOStream(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public long getPosition() {
        return Audio360JNI.IOStream_getPosition(this.swigCPtr, this);
    }

    public boolean setPosition(long pos) {
        return Audio360JNI.IOStream_setPosition__SWIG_0(this.swigCPtr, this, pos);
    }

    public boolean setPosition(long pos, int mode) {
        return Audio360JNI.IOStream_setPosition__SWIG_1(this.swigCPtr, this, pos, mode);
    }

    public int pushBackByte(int c) {
        return Audio360JNI.IOStream_pushBackByte(this.swigCPtr, this, c);
    }

    public long getSize() {
        return Audio360JNI.IOStream_getSize(this.swigCPtr, this);
    }

    public boolean canSeek() {
        return Audio360JNI.IOStream_canSeek(this.swigCPtr, this);
    }

    public boolean ready() {
        return Audio360JNI.IOStream_ready(this.swigCPtr, this);
    }

    public boolean endOfStream() {
        return Audio360JNI.IOStream_endOfStream(this.swigCPtr, this);
    }

    public int getFD() {
        return Audio360JNI.IOStream_getFD(this.swigCPtr, this);
    }

    public static IOStream createFileStream(String file, StreamOptions options, AssetDescriptor ad) {
        long cPtr = Audio360JNI.IOStream_createFileStream__SWIG_0(file, options.swigValue(), AssetDescriptor.getCPtr(ad), ad);
        return cPtr == 0L ? null : new IOStream(cPtr, true);
    }

    public static IOStream createFileStream(String file, StreamOptions options) {
        long cPtr = Audio360JNI.IOStream_createFileStream__SWIG_1(file, options.swigValue());
        return cPtr == 0L ? null : new IOStream(cPtr, true);
    }

    public static IOStream createMemoryStream(SWIGTYPE_p_void buffer, long sizeInBytes, long offsetInBytes) {
        long cPtr = Audio360JNI.IOStream_createMemoryStream__SWIG_0(SWIGTYPE_p_void.getCPtr(buffer), sizeInBytes, offsetInBytes);
        return cPtr == 0L ? null : new IOStream(cPtr, true);
    }

    public static IOStream createMemoryStream(SWIGTYPE_p_void buffer, long sizeInBytes) {
        long cPtr = Audio360JNI.IOStream_createMemoryStream__SWIG_1(SWIGTYPE_p_void.getCPtr(buffer), sizeInBytes);
        return cPtr == 0L ? null : new IOStream(cPtr, true);
    }

    public long read(ByteBuffer data, long numBytes) {
        assert (data.isDirect()) : "Buffer must be allocated direct.";
        return Audio360JNI.IOStream_read(this.swigCPtr, this, data, numBytes);
    }

    public long write(ByteBuffer data, long numBytes) {
        assert (data.isDirect()) : "Buffer must be allocated direct.";
        return Audio360JNI.IOStream_write(this.swigCPtr, this, data, numBytes);
    }

    public static enum StreamOptions {
        READ_BINARY,
        WRITE_BINARY,
        READ_WRITE_BINARY;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static StreamOptions swigToEnum(int swigValue) {
            StreamOptions[] swigValues = (StreamOptions[])StreamOptions.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (StreamOptions swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + StreamOptions.class + " with value " + swigValue);
        }

        private StreamOptions() {
            this.swigValue = SwigNext.next++;
        }

        private StreamOptions(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private StreamOptions(StreamOptions swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

