/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.TransferListener;
import androidx.media3.datasource.UdpDataSource;
import androidx.media3.exoplayer.rtsp.RtpDataChannel;
import androidx.media3.exoplayer.rtsp.RtspMessageChannel;
import com.google.common.primitives.Ints;
import java.io.IOException;

@UnstableApi
final class UdpDataSourceRtpDataChannel
implements RtpDataChannel {
    private static final String DEFAULT_UDP_TRANSPORT_FORMAT = "RTP/AVP;unicast;client_port=%d-%d";
    private final UdpDataSource dataSource;
    @Nullable
    private UdpDataSourceRtpDataChannel rtcpChannel;

    public UdpDataSourceRtpDataChannel(long socketTimeoutMs) {
        this.dataSource = new UdpDataSource(2000, Ints.checkedCast((long)socketTimeoutMs));
    }

    @Override
    public String getTransport() {
        int dataPortNumber = this.getLocalPort();
        Assertions.checkState((dataPortNumber != -1 ? 1 : 0) != 0);
        return Util.formatInvariant((String)DEFAULT_UDP_TRANSPORT_FORMAT, (Object[])new Object[]{dataPortNumber, dataPortNumber + 1});
    }

    @Override
    public int getLocalPort() {
        int port = this.dataSource.getLocalPort();
        return port == -1 ? -1 : port;
    }

    @Override
    public boolean needsClosingOnLoadCompletion() {
        return true;
    }

    @Override
    @Nullable
    public RtspMessageChannel.InterleavedBinaryDataListener getInterleavedBinaryDataListener() {
        return null;
    }

    public void addTransferListener(TransferListener transferListener) {
        this.dataSource.addTransferListener(transferListener);
    }

    public long open(DataSpec dataSpec) throws IOException {
        return this.dataSource.open(dataSpec);
    }

    @Nullable
    public Uri getUri() {
        return this.dataSource.getUri();
    }

    public void close() {
        this.dataSource.close();
        if (this.rtcpChannel != null) {
            this.rtcpChannel.close();
        }
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        try {
            return this.dataSource.read(buffer, offset, length);
        }
        catch (UdpDataSource.UdpDataSourceException e) {
            if (e.reason == 2002) {
                return -1;
            }
            throw e;
        }
    }

    public void setRtcpChannel(UdpDataSourceRtpDataChannel rtcpChannel) {
        Assertions.checkArgument((this != rtcpChannel ? 1 : 0) != 0);
        this.rtcpChannel = rtcpChannel;
    }
}

