/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp;

import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.media3.common.DataReader;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSourceUtil;
import androidx.media3.exoplayer.rtsp.RtpDataChannel;
import androidx.media3.exoplayer.rtsp.RtpExtractor;
import androidx.media3.exoplayer.rtsp.RtspMediaTrack;
import androidx.media3.exoplayer.upstream.Loader;
import androidx.media3.extractor.DefaultExtractorInput;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.PositionHolder;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
final class RtpDataLoadable
implements Loader.Loadable {
    public final int trackId;
    public final RtspMediaTrack rtspMediaTrack;
    private final EventListener eventListener;
    private final ExtractorOutput output;
    private final Handler playbackThreadHandler;
    private final RtpDataChannel.Factory rtpDataChannelFactory;
    @Nullable
    private RtpDataChannel dataChannel;
    private @MonotonicNonNull RtpExtractor extractor;
    private @MonotonicNonNull DefaultExtractorInput extractorInput;
    private volatile boolean loadCancelled;
    private volatile long pendingSeekPositionUs;
    private volatile long nextRtpTimestamp;

    public RtpDataLoadable(int trackId, RtspMediaTrack rtspMediaTrack, EventListener eventListener, ExtractorOutput output, RtpDataChannel.Factory rtpDataChannelFactory) {
        this.trackId = trackId;
        this.rtspMediaTrack = rtspMediaTrack;
        this.eventListener = eventListener;
        this.output = output;
        this.playbackThreadHandler = Util.createHandlerForCurrentLooper();
        this.rtpDataChannelFactory = rtpDataChannelFactory;
        this.pendingSeekPositionUs = -9223372036854775807L;
    }

    public void setTimestamp(long timestamp) {
        if (timestamp != -9223372036854775807L && !((RtpExtractor)Assertions.checkNotNull((Object)this.extractor)).hasReadFirstRtpPacket()) {
            this.extractor.setFirstTimestamp(timestamp);
        }
    }

    public void setSequenceNumber(int sequenceNumber) {
        if (!((RtpExtractor)Assertions.checkNotNull((Object)this.extractor)).hasReadFirstRtpPacket()) {
            this.extractor.setFirstSequenceNumber(sequenceNumber);
        }
    }

    public void cancelLoad() {
        this.loadCancelled = true;
    }

    public void load() throws IOException {
        if (this.loadCancelled) {
            this.loadCancelled = false;
        }
        try {
            if (this.dataChannel == null) {
                this.dataChannel = this.rtpDataChannelFactory.createAndOpenDataChannel(this.trackId);
                String transport = this.dataChannel.getTransport();
                RtpDataChannel finalDataChannel = this.dataChannel;
                this.playbackThreadHandler.post(() -> this.eventListener.onTransportReady(transport, finalDataChannel));
                this.extractorInput = new DefaultExtractorInput((DataReader)Assertions.checkNotNull((Object)this.dataChannel), 0L, -1L);
                this.extractor = new RtpExtractor(this.rtspMediaTrack.payloadFormat, this.trackId);
                this.extractor.init(this.output);
            }
            while (!this.loadCancelled) {
                int readResult;
                if (this.pendingSeekPositionUs != -9223372036854775807L) {
                    ((RtpExtractor)Assertions.checkNotNull((Object)this.extractor)).seek(this.nextRtpTimestamp, this.pendingSeekPositionUs);
                    this.pendingSeekPositionUs = -9223372036854775807L;
                }
                if ((readResult = ((RtpExtractor)Assertions.checkNotNull((Object)this.extractor)).read((ExtractorInput)Assertions.checkNotNull((Object)this.extractorInput), new PositionHolder())) != -1) continue;
                break;
            }
            this.loadCancelled = false;
        }
        finally {
            if (((RtpDataChannel)Assertions.checkNotNull((Object)this.dataChannel)).needsClosingOnLoadCompletion()) {
                DataSourceUtil.closeQuietly((DataSource)this.dataChannel);
                this.dataChannel = null;
            }
        }
    }

    public void resetForSeek() {
        ((RtpExtractor)Assertions.checkNotNull((Object)this.extractor)).preSeek();
    }

    public void seekToUs(long positionUs, long nextRtpTimestamp) {
        this.pendingSeekPositionUs = positionUs;
        this.nextRtpTimestamp = nextRtpTimestamp;
    }

    public static interface EventListener {
        public void onTransportReady(String var1, RtpDataChannel var2);
    }
}

