/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.metadata.id3;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaMetadata;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.metadata.id3.Id3Frame;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.InlineMe;
import java.util.ArrayList;
import java.util.List;

@UnstableApi
public final class TextInformationFrame
extends Id3Frame {
    @Nullable
    public final String description;
    @Deprecated
    public final String value;
    public final ImmutableList<String> values;
    public static final Parcelable.Creator<TextInformationFrame> CREATOR = new Parcelable.Creator<TextInformationFrame>(){

        public TextInformationFrame createFromParcel(Parcel in) {
            return new TextInformationFrame(in);
        }

        public TextInformationFrame[] newArray(int size) {
            return new TextInformationFrame[size];
        }
    };

    public TextInformationFrame(String id, @Nullable String description, List<String> values) {
        super(id);
        Assertions.checkArgument((!values.isEmpty() ? 1 : 0) != 0);
        this.description = description;
        this.values = ImmutableList.copyOf(values);
        this.value = (String)this.values.get(0);
    }

    @Deprecated
    @InlineMe(replacement="this(id, description, ImmutableList.of(value))", imports={"com.google.common.collect.ImmutableList"})
    public TextInformationFrame(String id, @Nullable String description, String value) {
        this(id, description, (List<String>)ImmutableList.of((Object)value));
    }

    private TextInformationFrame(Parcel in) {
        this((String)Assertions.checkNotNull((Object)in.readString()), in.readString(), (List<String>)ImmutableList.copyOf((Object[])((String[])Assertions.checkNotNull((Object)in.createStringArray()))));
    }

    public void populateMediaMetadata(MediaMetadata.Builder builder) {
        block27 : switch (this.id) {
            case "TT2": 
            case "TIT2": {
                builder.setTitle((CharSequence)this.values.get(0));
                break;
            }
            case "TP1": 
            case "TPE1": {
                builder.setArtist((CharSequence)this.values.get(0));
                break;
            }
            case "TP2": 
            case "TPE2": {
                builder.setAlbumArtist((CharSequence)this.values.get(0));
                break;
            }
            case "TAL": 
            case "TALB": {
                builder.setAlbumTitle((CharSequence)this.values.get(0));
                break;
            }
            case "TRK": 
            case "TRCK": {
                String[] trackNumbers = Util.split((String)((String)this.values.get(0)), (String)"/");
                try {
                    int trackNumber = Integer.parseInt(trackNumbers[0]);
                    Integer totalTrackCount = trackNumbers.length > 1 ? Integer.valueOf(Integer.parseInt(trackNumbers[1])) : null;
                    builder.setTrackNumber(Integer.valueOf(trackNumber)).setTotalTrackCount(totalTrackCount);
                }
                catch (NumberFormatException trackNumber) {}
                break;
            }
            case "TYE": 
            case "TYER": {
                try {
                    builder.setRecordingYear(Integer.valueOf(Integer.parseInt((String)this.values.get(0))));
                }
                catch (NumberFormatException trackNumber) {}
                break;
            }
            case "TDA": 
            case "TDAT": {
                try {
                    String date = (String)this.values.get(0);
                    int month = Integer.parseInt(date.substring(2, 4));
                    int day = Integer.parseInt(date.substring(0, 2));
                    builder.setRecordingMonth(Integer.valueOf(month)).setRecordingDay(Integer.valueOf(day));
                }
                catch (NumberFormatException | StringIndexOutOfBoundsException date) {}
                break;
            }
            case "TDRC": {
                List<Integer> recordingDate = TextInformationFrame.parseId3v2point4TimestampFrameForDate((String)this.values.get(0));
                switch (recordingDate.size()) {
                    case 3: {
                        builder.setRecordingDay(recordingDate.get(2));
                    }
                    case 2: {
                        builder.setRecordingMonth(recordingDate.get(1));
                    }
                    case 1: {
                        builder.setRecordingYear(recordingDate.get(0));
                        break block27;
                    }
                }
                break;
            }
            case "TDRL": {
                List<Integer> releaseDate = TextInformationFrame.parseId3v2point4TimestampFrameForDate((String)this.values.get(0));
                switch (releaseDate.size()) {
                    case 3: {
                        builder.setReleaseDay(releaseDate.get(2));
                    }
                    case 2: {
                        builder.setReleaseMonth(releaseDate.get(1));
                    }
                    case 1: {
                        builder.setReleaseYear(releaseDate.get(0));
                        break block27;
                    }
                }
                break;
            }
            case "TCM": 
            case "TCOM": {
                builder.setComposer((CharSequence)this.values.get(0));
                break;
            }
            case "TP3": 
            case "TPE3": {
                builder.setConductor((CharSequence)this.values.get(0));
                break;
            }
            case "TXT": 
            case "TEXT": {
                builder.setWriter((CharSequence)this.values.get(0));
                break;
            }
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TextInformationFrame other = (TextInformationFrame)obj;
        return Util.areEqual((Object)this.id, (Object)other.id) && Util.areEqual((Object)this.description, (Object)other.description) && this.values.equals(other.values);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.values.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return this.id + ": description=" + this.description + ": values=" + this.values;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.description);
        dest.writeStringArray((String[])this.values.toArray((Object[])new String[0]));
    }

    private static List<Integer> parseId3v2point4TimestampFrameForDate(String value) {
        ArrayList<Integer> dates = new ArrayList<Integer>();
        try {
            if (value.length() >= 10) {
                dates.add(Integer.parseInt(value.substring(0, 4)));
                dates.add(Integer.parseInt(value.substring(5, 7)));
                dates.add(Integer.parseInt(value.substring(8, 10)));
            } else if (value.length() >= 7) {
                dates.add(Integer.parseInt(value.substring(0, 4)));
                dates.add(Integer.parseInt(value.substring(5, 7)));
            } else if (value.length() >= 4) {
                dates.add(Integer.parseInt(value.substring(0, 4)));
            }
        }
        catch (NumberFormatException e) {
            return new ArrayList<Integer>();
        }
        return dates;
    }
}

