/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360;

import com.twobigears.audio360.Audio360JNI;

public class TBVector {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected TBVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(TBVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                Audio360JNI.delete_TBVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setX(float value) {
        Audio360JNI.TBVector_x_set(this.swigCPtr, this, value);
    }

    public float getX() {
        return Audio360JNI.TBVector_x_get(this.swigCPtr, this);
    }

    public void setY(float value) {
        Audio360JNI.TBVector_y_set(this.swigCPtr, this, value);
    }

    public float getY() {
        return Audio360JNI.TBVector_y_get(this.swigCPtr, this);
    }

    public void setZ(float value) {
        Audio360JNI.TBVector_z_set(this.swigCPtr, this, value);
    }

    public float getZ() {
        return Audio360JNI.TBVector_z_get(this.swigCPtr, this);
    }

    public TBVector() {
        this(Audio360JNI.new_TBVector__SWIG_0(), true);
    }

    public TBVector(float xValue, float yValue, float zValue) {
        this(Audio360JNI.new_TBVector__SWIG_1(xValue, yValue, zValue), true);
    }

    public TBVector(float value) {
        this(Audio360JNI.new_TBVector__SWIG_2(value), true);
    }

    public static TBVector CrossProduct(TBVector vectorA, TBVector vectorB) {
        return new TBVector(Audio360JNI.TBVector_CrossProduct(TBVector.getCPtr(vectorA), vectorA, TBVector.getCPtr(vectorB), vectorB), true);
    }

    public static TBVector zero() {
        return new TBVector(Audio360JNI.TBVector_zero(), true);
    }

    public static TBVector forward() {
        return new TBVector(Audio360JNI.TBVector_forward(), true);
    }

    public static TBVector up() {
        return new TBVector(Audio360JNI.TBVector_up(), true);
    }

    public static float DotProduct(TBVector vectorA, TBVector vectorB) {
        return Audio360JNI.TBVector_DotProduct(TBVector.getCPtr(vectorA), vectorA, TBVector.getCPtr(vectorB), vectorB);
    }

    public static float Angle(TBVector vectorA, TBVector vectorB) {
        return Audio360JNI.TBVector_Angle(TBVector.getCPtr(vectorA), vectorA, TBVector.getCPtr(vectorB), vectorB);
    }

    public static float magnitude(TBVector vector) {
        return Audio360JNI.TBVector_magnitude(TBVector.getCPtr(vector), vector);
    }

    public static void clampMagnitude(TBVector vector, float maxValue) {
        Audio360JNI.TBVector_clampMagnitude(TBVector.getCPtr(vector), vector, maxValue);
    }

    public static float magSquared(TBVector vector) {
        return Audio360JNI.TBVector_magSquared(TBVector.getCPtr(vector), vector);
    }

    public static void normalise(TBVector vector) {
        Audio360JNI.TBVector_normalise(TBVector.getCPtr(vector), vector);
    }

    public void set(float xValue, float yValue, float zValue) {
        Audio360JNI.TBVector_set(this.swigCPtr, this, xValue, yValue, zValue);
    }

    public void abs() {
        Audio360JNI.TBVector_abs__SWIG_0(this.swigCPtr, this);
    }

    public static TBVector projectOntoPlane(TBVector inputVector, TBVector unitNormalToPlane) {
        return new TBVector(Audio360JNI.TBVector_projectOntoPlane(TBVector.getCPtr(inputVector), inputVector, TBVector.getCPtr(unitNormalToPlane), unitNormalToPlane), true);
    }

    public static void rotateByVectors(TBVector forwardVector, TBVector upVector, TBVector rotatedVectorOut) {
        Audio360JNI.TBVector_rotateByVectors(TBVector.getCPtr(forwardVector), forwardVector, TBVector.getCPtr(upVector), upVector, TBVector.getCPtr(rotatedVectorOut), rotatedVectorOut);
    }

    public float min_val() {
        return Audio360JNI.TBVector_min_val(this.swigCPtr, this);
    }

    public float max_val() {
        return Audio360JNI.TBVector_max_val(this.swigCPtr, this);
    }

    public String toString(int precision) {
        return Audio360JNI.TBVector_toString__SWIG_0(this.swigCPtr, this, precision);
    }

    public String toString() {
        return Audio360JNI.TBVector_toString__SWIG_1(this.swigCPtr, this);
    }

    public static TBVector getVectorFromAziEle(float azimuth, float elevation) {
        return new TBVector(Audio360JNI.TBVector_getVectorFromAziEle(azimuth, elevation), true);
    }

    public static TBVector getVectorFromAziEleDist(float azimuth, float elevation, float dist) {
        return new TBVector(Audio360JNI.TBVector_getVectorFromAziEleDist(azimuth, elevation, dist), true);
    }

    public static TBVector getVectorFromEuler(TBVector eulerAngles) {
        return new TBVector(Audio360JNI.TBVector_getVectorFromEuler(TBVector.getCPtr(eulerAngles), eulerAngles), true);
    }
}

