/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360;

import com.twobigears.audio360.AssetDescriptor;
import com.twobigears.audio360.AttenuationMode;
import com.twobigears.audio360.AttenuationProps;
import com.twobigears.audio360.Audio360JNI;
import com.twobigears.audio360.AudioFormatDecoder;
import com.twobigears.audio360.DirectionalProps;
import com.twobigears.audio360.EffectParam;
import com.twobigears.audio360.EffectType;
import com.twobigears.audio360.EngineError;
import com.twobigears.audio360.EventListener;
import com.twobigears.audio360.IOStream;
import com.twobigears.audio360.SWIGTYPE_p_void;
import com.twobigears.audio360.SpatDecoderInterface;
import com.twobigears.audio360.SpatialisationType;

public class AudioObject
extends SpatDecoderInterface {
    private transient long swigCPtr;
    private EventListener eventListener_;

    protected AudioObject(long cPtr, boolean cMemoryOwn) {
        super(Audio360JNI.AudioObject_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(AudioObject obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setEventListener(EventListener listener) {
        if (this.eventListener_ != null) {
            this.eventListener_.delete();
            this.eventListener_ = null;
        }
        this.eventListener_ = listener;
        this.setEventListenerInternal(this.eventListener_);
    }

    public EngineError open(String nameAndPath) {
        return EngineError.swigToEnum(Audio360JNI.AudioObject_open__SWIG_0(this.swigCPtr, this, nameAndPath));
    }

    public EngineError open(String nameAndPath, AssetDescriptor ad) {
        return EngineError.swigToEnum(Audio360JNI.AudioObject_open__SWIG_1(this.swigCPtr, this, nameAndPath, AssetDescriptor.getCPtr(ad), ad));
    }

    public EngineError open(IOStream stream, boolean shouldOwnStream) {
        return EngineError.swigToEnum(Audio360JNI.AudioObject_open__SWIG_2(this.swigCPtr, this, IOStream.getCPtr(stream), stream, shouldOwnStream));
    }

    public EngineError open(AudioFormatDecoder decoder) {
        return EngineError.swigToEnum(Audio360JNI.AudioObject_open__SWIG_3(this.swigCPtr, this, AudioFormatDecoder.getCPtr(decoder), decoder));
    }

    public void close() {
        Audio360JNI.AudioObject_close(this.swigCPtr, this);
    }

    public boolean isOpen() {
        return Audio360JNI.AudioObject_isOpen(this.swigCPtr, this);
    }

    public EngineError seekToSample(long timeInSamples) {
        return EngineError.swigToEnum(Audio360JNI.AudioObject_seekToSample(this.swigCPtr, this, timeInSamples));
    }

    public EngineError seekToMs(float timeInMs) {
        return EngineError.swigToEnum(Audio360JNI.AudioObject_seekToMs(this.swigCPtr, this, timeInMs));
    }

    public long getElapsedTimeInSamples() {
        return Audio360JNI.AudioObject_getElapsedTimeInSamples(this.swigCPtr, this);
    }

    public double getElapsedTimeInMs() {
        return Audio360JNI.AudioObject_getElapsedTimeInMs(this.swigCPtr, this);
    }

    public long getAssetDurationInSamples() {
        return Audio360JNI.AudioObject_getAssetDurationInSamples(this.swigCPtr, this);
    }

    public float getAssetDurationInMs() {
        return Audio360JNI.AudioObject_getAssetDurationInMs(this.swigCPtr, this);
    }

    public void shouldSpatialise(boolean spatialise) {
        Audio360JNI.AudioObject_shouldSpatialise(this.swigCPtr, this, spatialise);
    }

    public boolean isSpatialised() {
        return Audio360JNI.AudioObject_isSpatialised(this.swigCPtr, this);
    }

    public void overrideRanking(boolean override) {
        Audio360JNI.AudioObject_overrideRanking(this.swigCPtr, this, override);
    }

    public EngineError setSpatialisationType(SpatialisationType spatType) {
        return EngineError.swigToEnum(Audio360JNI.AudioObject_setSpatialisationType(this.swigCPtr, this, spatType.swigValue()));
    }

    public SpatialisationType getSpatialisationType() {
        return SpatialisationType.swigToEnum(Audio360JNI.AudioObject_getSpatialisationType(this.swigCPtr, this));
    }

    public boolean enableLooping(boolean loop) {
        return Audio360JNI.AudioObject_enableLooping(this.swigCPtr, this, loop);
    }

    public boolean loopingEnabled() {
        return Audio360JNI.AudioObject_loopingEnabled(this.swigCPtr, this);
    }

    public void setAttenuationMode(AttenuationMode mode) {
        Audio360JNI.AudioObject_setAttenuationMode(this.swigCPtr, this, mode.swigValue());
    }

    public AttenuationMode getAttenuationMode() {
        return AttenuationMode.swigToEnum(Audio360JNI.AudioObject_getAttenuationMode(this.swigCPtr, this));
    }

    public void setAttenuationProperties(AttenuationProps props) {
        Audio360JNI.AudioObject_setAttenuationProperties(this.swigCPtr, this, AttenuationProps.getCPtr(props), props);
    }

    public AttenuationProps getAttenuationProperties() {
        return new AttenuationProps(Audio360JNI.AudioObject_getAttenuationProperties(this.swigCPtr, this), true);
    }

    public void setDirectionalityEnabled(boolean enable) {
        Audio360JNI.AudioObject_setDirectionalityEnabled(this.swigCPtr, this, enable);
    }

    public boolean isDirectionalityEnabled() {
        return Audio360JNI.AudioObject_isDirectionalityEnabled(this.swigCPtr, this);
    }

    public void setDirectionalProperties(DirectionalProps props) {
        Audio360JNI.AudioObject_setDirectionalProperties(this.swigCPtr, this, DirectionalProps.getCPtr(props), props);
    }

    public DirectionalProps getDirectionalProperties() {
        return new DirectionalProps(Audio360JNI.AudioObject_getDirectionalProperties(this.swigCPtr, this), true);
    }

    public void setPitch(float pitch) {
        Audio360JNI.AudioObject_setPitch(this.swigCPtr, this, pitch);
    }

    public float getPitch() {
        return Audio360JNI.AudioObject_getPitch(this.swigCPtr, this);
    }

    public SWIGTYPE_p_void createEffect(EffectType type) {
        long cPtr = Audio360JNI.AudioObject_createEffect(this.swigCPtr, this, type.swigValue());
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public void destroyEffect(SWIGTYPE_p_void handle) {
        Audio360JNI.AudioObject_destroyEffect(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(handle));
    }

    public EffectType getEffectTypeForHandle(SWIGTYPE_p_void handle) {
        return EffectType.swigToEnum(Audio360JNI.AudioObject_getEffectTypeForHandle(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(handle)));
    }

    public EngineError setEffectType(SWIGTYPE_p_void handle, EffectType type) {
        return EngineError.swigToEnum(Audio360JNI.AudioObject_setEffectType(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(handle), type.swigValue()));
    }

    public EngineError bypassEffect(SWIGTYPE_p_void handle, boolean bypass) {
        return EngineError.swigToEnum(Audio360JNI.AudioObject_bypassEffect(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(handle), bypass));
    }

    public boolean isEffectBypassed(SWIGTYPE_p_void handle) {
        return Audio360JNI.AudioObject_isEffectBypassed(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(handle));
    }

    public EngineError setEffectParam(SWIGTYPE_p_void handle, EffectParam param, float value) {
        return EngineError.swigToEnum(Audio360JNI.AudioObject_setEffectParam(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(handle), param.swigValue(), value));
    }

    public float getEffectParam(SWIGTYPE_p_void handle, EffectParam param) {
        return Audio360JNI.AudioObject_getEffectParam(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(handle), param.swigValue());
    }

    public long getNumberOfEffects() {
        return Audio360JNI.AudioObject_getNumberOfEffects(this.swigCPtr, this);
    }

    public SWIGTYPE_p_void getEffect(long effectIndex) {
        long cPtr = Audio360JNI.AudioObject_getEffect(this.swigCPtr, this, effectIndex);
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    public SWIGTYPE_p_void getOutputBus() {
        long cPtr = Audio360JNI.AudioObject_getOutputBus(this.swigCPtr, this);
        return cPtr == 0L ? null : new SWIGTYPE_p_void(cPtr, false);
    }

    private void setEventListenerInternal(EventListener listener) {
        Audio360JNI.AudioObject_setEventListenerInternal(this.swigCPtr, this, EventListener.getCPtr(listener), listener);
    }
}

