/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource.okhttp;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaLibraryInfo;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.BaseDataSource;
import androidx.media3.datasource.DataSourceException;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.HttpDataSource;
import androidx.media3.datasource.HttpUtil;
import androidx.media3.datasource.TransferListener;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpDataSource
extends BaseDataSource
implements HttpDataSource {
    private final Call.Factory callFactory;
    private final HttpDataSource.RequestProperties requestProperties;
    @Nullable
    private final String userAgent;
    @Nullable
    private final CacheControl cacheControl;
    @Nullable
    private final HttpDataSource.RequestProperties defaultRequestProperties;
    @Nullable
    private Predicate<String> contentTypePredicate;
    @Nullable
    private DataSpec dataSpec;
    @Nullable
    private Response response;
    @Nullable
    private InputStream responseByteStream;
    private boolean opened;
    private long bytesToRead;
    private long bytesRead;

    @Deprecated
    @UnstableApi
    public OkHttpDataSource(Call.Factory callFactory) {
        this(callFactory, null);
    }

    @Deprecated
    @UnstableApi
    public OkHttpDataSource(Call.Factory callFactory, @Nullable String userAgent) {
        this(callFactory, userAgent, null, null);
    }

    @Deprecated
    @UnstableApi
    public OkHttpDataSource(Call.Factory callFactory, @Nullable String userAgent, @Nullable CacheControl cacheControl, @Nullable HttpDataSource.RequestProperties defaultRequestProperties) {
        this(callFactory, userAgent, cacheControl, defaultRequestProperties, null);
    }

    private OkHttpDataSource(Call.Factory callFactory, @Nullable String userAgent, @Nullable CacheControl cacheControl, @Nullable HttpDataSource.RequestProperties defaultRequestProperties, @Nullable Predicate<String> contentTypePredicate) {
        super(true);
        this.callFactory = (Call.Factory)Assertions.checkNotNull((Object)callFactory);
        this.userAgent = userAgent;
        this.cacheControl = cacheControl;
        this.defaultRequestProperties = defaultRequestProperties;
        this.contentTypePredicate = contentTypePredicate;
        this.requestProperties = new HttpDataSource.RequestProperties();
    }

    @Deprecated
    @UnstableApi
    public void setContentTypePredicate(@Nullable Predicate<String> contentTypePredicate) {
        this.contentTypePredicate = contentTypePredicate;
    }

    @UnstableApi
    @Nullable
    public Uri getUri() {
        return this.response == null ? null : Uri.parse((String)this.response.request().url().toString());
    }

    @UnstableApi
    public int getResponseCode() {
        return this.response == null ? -1 : this.response.code();
    }

    @UnstableApi
    public Map<String, List<String>> getResponseHeaders() {
        return this.response == null ? Collections.emptyMap() : this.response.headers().toMultimap();
    }

    @UnstableApi
    public void setRequestProperty(String name, String value) {
        Assertions.checkNotNull((Object)name);
        Assertions.checkNotNull((Object)value);
        this.requestProperties.set(name, value);
    }

    @UnstableApi
    public void clearRequestProperty(String name) {
        Assertions.checkNotNull((Object)name);
        this.requestProperties.remove(name);
    }

    @UnstableApi
    public void clearAllRequestProperties() {
        this.requestProperties.clear();
    }

    @UnstableApi
    public long open(DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        long contentLength;
        long bytesToSkip;
        String contentType;
        ResponseBody responseBody;
        Response response;
        this.dataSpec = dataSpec;
        this.bytesRead = 0L;
        this.bytesToRead = 0L;
        this.transferInitializing(dataSpec);
        Request request = this.makeRequest(dataSpec);
        Call call = this.callFactory.newCall(request);
        try {
            response = this.response = this.executeCall(call);
            responseBody = (ResponseBody)Assertions.checkNotNull((Object)response.body());
            this.responseByteStream = responseBody.byteStream();
        }
        catch (IOException e) {
            throw HttpDataSource.HttpDataSourceException.createForIOException((IOException)e, (DataSpec)dataSpec, (int)1);
        }
        int responseCode = response.code();
        if (!response.isSuccessful()) {
            byte[] errorResponseBody;
            long documentSize;
            if (responseCode == 416 && dataSpec.position == (documentSize = HttpUtil.getDocumentSize((String)response.headers().get("Content-Range")))) {
                this.opened = true;
                this.transferStarted(dataSpec);
                return dataSpec.length != -1L ? dataSpec.length : 0L;
            }
            try {
                errorResponseBody = Util.toByteArray((InputStream)((InputStream)Assertions.checkNotNull((Object)this.responseByteStream)));
            }
            catch (IOException e) {
                errorResponseBody = Util.EMPTY_BYTE_ARRAY;
            }
            Map headers = response.headers().toMultimap();
            this.closeConnectionQuietly();
            DataSourceException cause = responseCode == 416 ? new DataSourceException(2008) : null;
            throw new HttpDataSource.InvalidResponseCodeException(responseCode, response.message(), (IOException)cause, headers, dataSpec, errorResponseBody);
        }
        MediaType mediaType = responseBody.contentType();
        String string = contentType = mediaType != null ? mediaType.toString() : "";
        if (this.contentTypePredicate != null && !this.contentTypePredicate.apply((Object)contentType)) {
            this.closeConnectionQuietly();
            throw new HttpDataSource.InvalidContentTypeException(contentType, dataSpec);
        }
        long l = bytesToSkip = responseCode == 200 && dataSpec.position != 0L ? dataSpec.position : 0L;
        this.bytesToRead = dataSpec.length != -1L ? dataSpec.length : ((contentLength = responseBody.contentLength()) != -1L ? contentLength - bytesToSkip : -1L);
        this.opened = true;
        this.transferStarted(dataSpec);
        try {
            this.skipFully(bytesToSkip, dataSpec);
        }
        catch (HttpDataSource.HttpDataSourceException e) {
            this.closeConnectionQuietly();
            throw e;
        }
        return this.bytesToRead;
    }

    @UnstableApi
    public int read(byte[] buffer, int offset, int length) throws HttpDataSource.HttpDataSourceException {
        try {
            return this.readInternal(buffer, offset, length);
        }
        catch (IOException e) {
            throw HttpDataSource.HttpDataSourceException.createForIOException((IOException)e, (DataSpec)((DataSpec)Util.castNonNull((Object)this.dataSpec)), (int)2);
        }
    }

    @UnstableApi
    public void close() {
        if (this.opened) {
            this.opened = false;
            this.transferEnded();
            this.closeConnectionQuietly();
        }
    }

    private Request makeRequest(DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        long position = dataSpec.position;
        long length = dataSpec.length;
        HttpUrl url = HttpUrl.parse((String)dataSpec.uri.toString());
        if (url == null) {
            throw new HttpDataSource.HttpDataSourceException("Malformed URL", dataSpec, 1004, 1);
        }
        Request.Builder builder = new Request.Builder().url(url);
        if (this.cacheControl != null) {
            builder.cacheControl(this.cacheControl);
        }
        HashMap headers = new HashMap();
        if (this.defaultRequestProperties != null) {
            headers.putAll(this.defaultRequestProperties.getSnapshot());
        }
        headers.putAll(this.requestProperties.getSnapshot());
        headers.putAll(dataSpec.httpRequestHeaders);
        for (Map.Entry header : headers.entrySet()) {
            builder.header((String)header.getKey(), (String)header.getValue());
        }
        String rangeHeader = HttpUtil.buildRangeRequestHeader((long)position, (long)length);
        if (rangeHeader != null) {
            builder.addHeader("Range", rangeHeader);
        }
        if (this.userAgent != null) {
            builder.addHeader("User-Agent", this.userAgent);
        }
        if (!dataSpec.isFlagSet(1)) {
            builder.addHeader("Accept-Encoding", "identity");
        }
        RequestBody requestBody = null;
        if (dataSpec.httpBody != null) {
            requestBody = RequestBody.create(null, (byte[])dataSpec.httpBody);
        } else if (dataSpec.httpMethod == 2) {
            requestBody = RequestBody.create(null, (byte[])Util.EMPTY_BYTE_ARRAY);
        }
        builder.method(dataSpec.getHttpMethodString(), requestBody);
        return builder.build();
    }

    private Response executeCall(Call call) throws IOException {
        final SettableFuture future = SettableFuture.create();
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.setException((Throwable)e);
            }

            public void onResponse(Call call, Response response) {
                future.set((Object)response);
            }
        });
        try {
            return (Response)future.get();
        }
        catch (InterruptedException e) {
            call.cancel();
            throw new InterruptedIOException();
        }
        catch (ExecutionException ee) {
            throw new IOException(ee);
        }
    }

    private void skipFully(long bytesToSkip, DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        if (bytesToSkip == 0L) {
            return;
        }
        byte[] skipBuffer = new byte[4096];
        try {
            while (bytesToSkip > 0L) {
                int readLength = (int)Math.min(bytesToSkip, (long)skipBuffer.length);
                int read = ((InputStream)Util.castNonNull((Object)this.responseByteStream)).read(skipBuffer, 0, readLength);
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedIOException();
                }
                if (read == -1) {
                    throw new HttpDataSource.HttpDataSourceException(dataSpec, 2008, 1);
                }
                bytesToSkip -= (long)read;
                this.bytesTransferred(read);
            }
            return;
        }
        catch (IOException e) {
            if (e instanceof HttpDataSource.HttpDataSourceException) {
                throw (HttpDataSource.HttpDataSourceException)((Object)e);
            }
            throw new HttpDataSource.HttpDataSourceException(dataSpec, 2000, 1);
        }
    }

    private int readInternal(byte[] buffer, int offset, int readLength) throws IOException {
        int read;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesToRead != -1L) {
            long bytesRemaining = this.bytesToRead - this.bytesRead;
            if (bytesRemaining == 0L) {
                return -1;
            }
            readLength = (int)Math.min((long)readLength, bytesRemaining);
        }
        if ((read = ((InputStream)Util.castNonNull((Object)this.responseByteStream)).read(buffer, offset, readLength)) == -1) {
            return -1;
        }
        this.bytesRead += (long)read;
        this.bytesTransferred(read);
        return read;
    }

    private void closeConnectionQuietly() {
        if (this.response != null) {
            ((ResponseBody)Assertions.checkNotNull((Object)this.response.body())).close();
            this.response = null;
        }
        this.responseByteStream = null;
    }

    static {
        MediaLibraryInfo.registerModule((String)"media3.datasource.okhttp");
    }

    public static final class Factory
    implements HttpDataSource.Factory {
        private final HttpDataSource.RequestProperties defaultRequestProperties;
        private final Call.Factory callFactory;
        @Nullable
        private String userAgent;
        @Nullable
        private TransferListener transferListener;
        @Nullable
        private CacheControl cacheControl;
        @Nullable
        private Predicate<String> contentTypePredicate;

        public Factory(Call.Factory callFactory) {
            this.callFactory = callFactory;
            this.defaultRequestProperties = new HttpDataSource.RequestProperties();
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public final Factory setDefaultRequestProperties(Map<String, String> defaultRequestProperties) {
            this.defaultRequestProperties.clearAndSet(defaultRequestProperties);
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setUserAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setCacheControl(@Nullable CacheControl cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setContentTypePredicate(@Nullable Predicate<String> contentTypePredicate) {
            this.contentTypePredicate = contentTypePredicate;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setTransferListener(@Nullable TransferListener transferListener) {
            this.transferListener = transferListener;
            return this;
        }

        @UnstableApi
        public OkHttpDataSource createDataSource() {
            OkHttpDataSource dataSource = new OkHttpDataSource(this.callFactory, this.userAgent, this.cacheControl, this.defaultRequestProperties, this.contentTypePredicate);
            if (this.transferListener != null) {
                dataSource.addTransferListener(this.transferListener);
            }
            return dataSource;
        }
    }
}

