/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import androidx.annotation.Nullable;
import androidx.media3.common.util.UnstableApi;

@UnstableApi
public final class MpegAudioUtil {
    public static final int MAX_FRAME_SIZE_BYTES = 4096;
    public static final int MAX_RATE_BYTES_PER_SECOND = 40000;
    private static final String[] MIME_TYPE_BY_LAYER = new String[]{"audio/mpeg-L1", "audio/mpeg-L2", "audio/mpeg"};
    private static final int[] SAMPLING_RATE_V1 = new int[]{44100, 48000, 32000};
    private static final int[] BITRATE_V1_L1 = new int[]{32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000};
    private static final int[] BITRATE_V2_L1 = new int[]{32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000};
    private static final int[] BITRATE_V1_L2 = new int[]{32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000};
    private static final int[] BITRATE_V1_L3 = new int[]{32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000};
    private static final int[] BITRATE_V2 = new int[]{8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000};
    private static final int SAMPLES_PER_FRAME_L1 = 384;
    private static final int SAMPLES_PER_FRAME_L2 = 1152;
    private static final int SAMPLES_PER_FRAME_L3_V1 = 1152;
    private static final int SAMPLES_PER_FRAME_L3_V2 = 576;

    public static int getFrameSize(int headerData) {
        if (!MpegAudioUtil.isMagicPresent(headerData)) {
            return -1;
        }
        int version = headerData >>> 19 & 3;
        if (version == 1) {
            return -1;
        }
        int layer = headerData >>> 17 & 3;
        if (layer == 0) {
            return -1;
        }
        int bitrateIndex = headerData >>> 12 & 0xF;
        if (bitrateIndex == 0 || bitrateIndex == 15) {
            return -1;
        }
        int samplingRateIndex = headerData >>> 10 & 3;
        if (samplingRateIndex == 3) {
            return -1;
        }
        int samplingRate = SAMPLING_RATE_V1[samplingRateIndex];
        if (version == 2) {
            samplingRate /= 2;
        } else if (version == 0) {
            samplingRate /= 4;
        }
        int padding = headerData >>> 9 & 1;
        if (layer == 3) {
            int bitrate = version == 3 ? BITRATE_V1_L1[bitrateIndex - 1] : BITRATE_V2_L1[bitrateIndex - 1];
            return (12 * bitrate / samplingRate + padding) * 4;
        }
        int bitrate = version == 3 ? (layer == 2 ? BITRATE_V1_L2[bitrateIndex - 1] : BITRATE_V1_L3[bitrateIndex - 1]) : BITRATE_V2[bitrateIndex - 1];
        if (version == 3) {
            return 144 * bitrate / samplingRate + padding;
        }
        return (layer == 1 ? 72 : 144) * bitrate / samplingRate + padding;
    }

    public static int parseMpegAudioFrameSampleCount(int headerData) {
        if (!MpegAudioUtil.isMagicPresent(headerData)) {
            return -1;
        }
        int version = headerData >>> 19 & 3;
        if (version == 1) {
            return -1;
        }
        int layer = headerData >>> 17 & 3;
        if (layer == 0) {
            return -1;
        }
        int bitrateIndex = headerData >>> 12 & 0xF;
        int samplingRateIndex = headerData >>> 10 & 3;
        if (bitrateIndex == 0 || bitrateIndex == 15 || samplingRateIndex == 3) {
            return -1;
        }
        return MpegAudioUtil.getFrameSizeInSamples(version, layer);
    }

    private MpegAudioUtil() {
    }

    private static boolean isMagicPresent(int headerData) {
        return (headerData & 0xFFE00000) == -2097152;
    }

    private static int getFrameSizeInSamples(int version, int layer) {
        switch (layer) {
            case 1: {
                return version == 3 ? 1152 : 576;
            }
            case 2: {
                return 1152;
            }
            case 3: {
                return 384;
            }
        }
        throw new IllegalArgumentException();
    }

    public static final class Header {
        public int version;
        @Nullable
        public String mimeType;
        public int frameSize;
        public int sampleRate;
        public int channels;
        public int bitrate;
        public int samplesPerFrame;

        public boolean setForHeaderData(int headerData) {
            if (!MpegAudioUtil.isMagicPresent(headerData)) {
                return false;
            }
            int version = headerData >>> 19 & 3;
            if (version == 1) {
                return false;
            }
            int layer = headerData >>> 17 & 3;
            if (layer == 0) {
                return false;
            }
            int bitrateIndex = headerData >>> 12 & 0xF;
            if (bitrateIndex == 0 || bitrateIndex == 15) {
                return false;
            }
            int samplingRateIndex = headerData >>> 10 & 3;
            if (samplingRateIndex == 3) {
                return false;
            }
            this.version = version;
            this.mimeType = MIME_TYPE_BY_LAYER[3 - layer];
            this.sampleRate = SAMPLING_RATE_V1[samplingRateIndex];
            if (version == 2) {
                this.sampleRate /= 2;
            } else if (version == 0) {
                this.sampleRate /= 4;
            }
            int padding = headerData >>> 9 & 1;
            this.samplesPerFrame = MpegAudioUtil.getFrameSizeInSamples(version, layer);
            if (layer == 3) {
                this.bitrate = version == 3 ? BITRATE_V1_L1[bitrateIndex - 1] : BITRATE_V2_L1[bitrateIndex - 1];
                this.frameSize = (12 * this.bitrate / this.sampleRate + padding) * 4;
            } else if (version == 3) {
                this.bitrate = layer == 2 ? BITRATE_V1_L2[bitrateIndex - 1] : BITRATE_V1_L3[bitrateIndex - 1];
                this.frameSize = 144 * this.bitrate / this.sampleRate + padding;
            } else {
                this.bitrate = BITRATE_V2[bitrateIndex - 1];
                this.frameSize = (layer == 1 ? 72 : 144) * this.bitrate / this.sampleRate + padding;
            }
            this.channels = (headerData >> 6 & 3) == 3 ? 1 : 2;
            return true;
        }
    }
}

