/*
 * Decompiled with CFR 0.152.
 */
package com.renderheads.AVPro.Video;

import android.app.Activity;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.Base64;
import android.view.Surface;
import com.renderheads.AVPro.Video.AVPLog;
import com.renderheads.AVPro.Video.Manager;
import com.renderheads.AVPro.Video.Player_Base$1;
import com.renderheads.AVPro.Video.Player_Base$2;
import com.renderheads.AVPro.Video.Player_Base$3;
import com.renderheads.AVPro.Video.Player_Base$DownloadedVideoInfo;
import com.renderheads.AVPro.Video.Player_Base$OpenCloseCommand;
import com.renderheads.AVPro.Video.Player_Base$TrackInfoForReturn;
import com.renderheads.AVPro.Video.Player_Base$VideoCommand;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Player_Base
implements SurfaceTexture.OnFrameAvailableListener {
    protected static final int Status_Unknown = 0;
    protected static final int Status_ReadyToPlay = 1;
    protected static final int Status_Playing = 2;
    protected static final int Status_Paused = 4;
    protected static final int Status_Finished = 8;
    protected static final int Status_Seeking = 16;
    protected static final int Status_Buffering = 32;
    protected static final int Status_Stalled = 64;
    protected static final int Status_ExternalPlaybackActive = 128;
    protected static final int Status_Cached = 256;
    protected static final int Status_FinishedSeeking = 512;
    protected static final int Status_UpdatedAssetInfo = 65536;
    protected static final int Status_UpdatedTexture = 131072;
    protected static final int Status_UpdatedBufferedTimeRanges = 262144;
    protected static final int Status_UpdatedSeekableTimeRanges = 524288;
    protected static final int Status_UpdatedText = 0x100000;
    protected static final int Status_HasVideo = 0x1000000;
    protected static final int Status_HasAudio = 0x2000000;
    protected static final int Status_HasText = 0x4000000;
    protected static final int Status_HasMetadata = 0x8000000;
    protected static final int Status_Failed = Integer.MIN_VALUE;
    protected static int Command_Open = 0;
    protected static int Command_Close = 1;
    protected static int VideoCommand_Play = 0;
    protected static int VideoCommand_Pause = 1;
    protected static int VideoCommand_Stop = 2;
    protected static int VideoCommand_Seek = 3;
    protected static int VideoCommand_AudioVolumes = 4;
    protected static int VideoCommand_SetLooping = 5;
    protected static int VideoCommand_SeekFast = 6;
    protected static int VideoCommand_PlaybackRate = 7;
    protected static int VideoCommand_SeekWithTolerances = 8;
    protected static int VideoCommand_SetVideoTrack = 9;
    protected static int VideoCommand_SetAudioTrack = 10;
    protected static int VideoCommand_SetTextTrack = 11;
    protected static final int VideoState_Unknown = -1;
    protected static final int VideoState_Idle = 0;
    protected static final int VideoState_Opening = 1;
    protected static final int VideoState_Preparing = 2;
    protected static final int VideoState_Prepared = 3;
    protected static final int VideoState_Buffering = 4;
    protected static final int VideoState_Playing = 5;
    protected static final int VideoState_Stopped = 6;
    protected static final int VideoState_Paused = 7;
    protected static final int VideoState_Finished = 8;
    protected static final int Format_Unknown = 0;
    protected static final int Format_HLS = 1;
    protected static final int Format_Dash = 2;
    protected static final int Format_SS = 3;
    protected static final int ErrorCode_None = 0;
    protected static final int ErrorCode_LoadFailed = 100;
    protected static final int ErrorCode_DecodeFailed = 200;
    protected boolean m_bUltraBuild;
    protected Context m_Context;
    protected boolean m_bShowPosterFrame;
    protected int m_iPlayerIndex;
    protected double[] m_aCurrentStateValues = new double[9];
    protected final int Audio_System;
    protected final int Audio_Unity;
    protected final int Audio_SystemWithCapture;
    protected final int Audio_FacebookAudio360;
    protected int m_iAudioSubsystem = 0;
    protected int m_iSetting_AudioSubsystem = 0;
    protected int m_iSetting_Audio360ChannelIndex = 0;
    protected int m_iSetting_Audio360LatencyMS = 0;
    protected int m_iSetting_ForcedFileFormat = 0;
    protected boolean m_bSetting_PreferSoftwareDecoder = false;
    protected boolean m_bSetting_ForceRtpTCP = false;
    protected boolean m_bSetting_ForceEnableMediaCodecAsynchronousQueueing = false;
    protected int m_iFileOffset = 0;
    protected LinkedList<Player_Base$OpenCloseCommand> m_OpenCloseCommandQueue;
    protected AtomicInteger m_iCurrentOpenCloseCommand;
    protected int m_Width;
    protected int m_Height;
    private AtomicBoolean m_resolutionChanged;
    private AtomicInteger m_newResolution;
    protected long m_DurationMs;
    protected boolean m_bLooping;
    protected float m_fPlaybackRate;
    protected boolean m_bPlaybackRateSetPaused;
    protected int m_FrameCount;
    protected boolean m_bIsStream;
    protected boolean m_bIsLive;
    protected boolean m_bIsBuffering;
    protected boolean m_bIsSeeking;
    protected boolean m_bFinishedSeeking;
    protected float m_AudioVolume;
    protected float m_AudioPan;
    protected boolean m_AudioMuted;
    protected float m_fBufferingProgressPercent;
    protected AtomicInteger m_iNumberFramesAvailable;
    protected long m_TextureTimeStamp;
    protected Queue<Player_Base$VideoCommand> m_CommandQueue;
    protected int m_VideoState;
    protected AtomicBoolean m_bVideo_RenderSurfaceCreated;
    protected AtomicBoolean m_bVideo_AcceptCommands;
    protected AtomicBoolean m_bVideo_FormatSet;
    protected AtomicBoolean m_bVideo_ReadyStateSet;
    protected int m_iCurrentAudioTrackIndex;
    protected int m_iCurrentVideoTrackIndex;
    protected int m_iCurrentTextTrackIndex;
    protected int m_iCurrentAudioTrack_NumChannels;
    protected int m_iDefaultAudioTrackIndex;
    protected int m_iDefaultVideoTrackIndex;
    protected int m_iDefaultTextTrackIndex;
    protected boolean m_bSourceHasVideo;
    protected int m_iNumberVideoTracks;
    protected float m_fSourceVideoFrameRate;
    protected int m_iSourceVideoBitrate;
    protected int m_iSourceVideoStereoMode;
    protected String m_SourceVideoId;
    protected boolean m_bVideoTracksDirty;
    protected AtomicBoolean m_bVideoTracksDirty_Internal;
    protected boolean m_bSourceHasAudio;
    protected int m_iNumberAudioTracks;
    protected int m_iSourceAudioBitrate;
    protected String m_SourceAudioId;
    protected boolean m_bAudioTracksDirty;
    protected AtomicBoolean m_bAudioTracksDirty_Internal;
    protected int m_iNumberTextTracks;
    private boolean m_bTextCuesDirty;
    protected boolean m_bTextTracksDirty;
    protected AtomicBoolean m_bTextTracksDirty_Internal;
    protected AtomicBoolean m_bTextCuesDirty_Internal;
    protected boolean m_bSourceHasTimedText;
    protected boolean m_bSourceHasSubtitles;
    protected String m_KeyServerAuthToken;
    protected String m_OverrideDecryptionKey;
    protected long m_DisplayRate_LastSystemTimeMS;
    protected long m_DisplayRate_NumberFrames;
    protected float m_DisplayRate_FrameRate;
    protected int m_iLastError;
    protected AtomicBoolean m_Extracting;
    protected int m_ExtractWaitTimeout;
    protected long m_FrameArrivalThreadID;
    protected final ReentrantLock _mutex;
    protected Random m_Random;
    protected double[] m_aCachedStatusReturn;
    protected double[] m_aCachedSeekableTimeRangesResult;
    protected double[] m_aGetSeekableTimeRangesResult;
    protected double[] m_aCachedBufferedTimeRangesResult;
    protected double[] m_aGetBufferedTimeRangesResult;
    private Player_Base$DownloadedVideoInfo[] m_acDownloadedVideosInfo;
    private String m_CachedTextCue;
    protected Player_Base$TrackInfoForReturn[] m_aVideoTrackInfo;
    protected Player_Base$TrackInfoForReturn[] m_aAudioTrackInfo;
    protected Player_Base$TrackInfoForReturn[] m_aTextTrackInfo;
    private double[] m_aAssetInfo;

    public Player_Base(int n, Random random, boolean bl) {
        AtomicBoolean atomicBoolean;
        long l;
        AtomicBoolean atomicBoolean2;
        AtomicBoolean atomicBoolean3;
        AtomicBoolean atomicBoolean4;
        AtomicBoolean atomicBoolean5;
        LinkedList linkedList;
        AtomicInteger atomicInteger;
        Serializable serializable;
        ReentrantLock reentrantLock;
        AtomicBoolean atomicBoolean6;
        AtomicBoolean atomicBoolean7;
        AtomicBoolean atomicBoolean8;
        AtomicBoolean atomicBoolean9;
        AtomicInteger atomicInteger2;
        AtomicBoolean atomicBoolean10;
        AtomicInteger atomicInteger3;
        LinkedList linkedList2;
        this.Audio_System = 0;
        this.Audio_Unity = 1;
        this.Audio_SystemWithCapture = 2;
        this.Audio_FacebookAudio360 = 3;
        Serializable serializable2 = linkedList2;
        linkedList2 = new LinkedList();
        this.m_OpenCloseCommandQueue = serializable2;
        serializable2 = atomicInteger3;
        atomicInteger3 = new AtomicInteger(-1);
        this.m_iCurrentOpenCloseCommand = serializable2;
        serializable2 = atomicBoolean10;
        atomicBoolean10 = new AtomicBoolean(false);
        this.m_resolutionChanged = serializable2;
        serializable2 = atomicInteger2;
        atomicInteger2 = new AtomicInteger(0);
        this.m_newResolution = serializable2;
        serializable2 = atomicBoolean9;
        atomicBoolean9 = new AtomicBoolean(false);
        this.m_bVideoTracksDirty_Internal = serializable2;
        serializable2 = atomicBoolean8;
        atomicBoolean8 = new AtomicBoolean(false);
        this.m_bAudioTracksDirty_Internal = serializable2;
        serializable2 = atomicBoolean7;
        atomicBoolean7 = new AtomicBoolean(false);
        this.m_bTextTracksDirty_Internal = serializable2;
        serializable2 = atomicBoolean6;
        atomicBoolean6 = new AtomicBoolean(false);
        this.m_bTextCuesDirty_Internal = serializable2;
        this.m_KeyServerAuthToken = null;
        this.m_OverrideDecryptionKey = null;
        serializable2 = reentrantLock;
        reentrantLock = new ReentrantLock();
        this._mutex = serializable2;
        this.m_aCachedStatusReturn = new double[2];
        this.m_aCachedSeekableTimeRangesResult = new double[2];
        this.m_aGetSeekableTimeRangesResult = new double[2];
        this.m_aCachedBufferedTimeRangesResult = new double[2];
        this.m_aGetBufferedTimeRangesResult = new double[2];
        this.m_CachedTextCue = "";
        this.m_aAssetInfo = new double[8];
        this.m_bUltraBuild = bl;
        this.m_iPlayerIndex = n;
        this.m_bShowPosterFrame = false;
        this.m_iAudioSubsystem = 0;
        this.m_Width = 0;
        this.m_Height = 0;
        this.m_DurationMs = 0L;
        this.m_bLooping = false;
        this.m_fPlaybackRate = 1.0f;
        this.m_FrameCount = 0;
        this.m_bIsStream = false;
        this.m_bIsLive = false;
        this.m_bIsBuffering = false;
        this.m_bIsSeeking = false;
        this.m_bFinishedSeeking = false;
        this.m_AudioVolume = 1.0f;
        this.m_AudioPan = 0.0f;
        this.m_AudioMuted = false;
        this.m_fBufferingProgressPercent = 0.0f;
        this.m_iNumberFramesAvailable = serializable = atomicInteger;
        new AtomicInteger().set(0);
        this.m_TextureTimeStamp = 0L;
        serializable = linkedList;
        linkedList = new LinkedList();
        this.m_CommandQueue = serializable;
        this.m_VideoState = -1;
        serializable = atomicBoolean5;
        this.m_bVideo_RenderSurfaceCreated = serializable;
        new AtomicBoolean().set(false);
        serializable = atomicBoolean4;
        this.m_bVideo_AcceptCommands = serializable;
        new AtomicBoolean().set(false);
        serializable = atomicBoolean3;
        this.m_bVideo_FormatSet = serializable;
        new AtomicBoolean().set(false);
        serializable = atomicBoolean2;
        this.m_bVideo_ReadyStateSet = serializable;
        new AtomicBoolean().set(false);
        this.m_iCurrentAudioTrackIndex = -1;
        this.m_iCurrentVideoTrackIndex = -1;
        this.m_iCurrentTextTrackIndex = -1;
        this.m_iCurrentAudioTrack_NumChannels = 0;
        this.m_iDefaultAudioTrackIndex = -1;
        this.m_iDefaultVideoTrackIndex = -1;
        this.m_iDefaultTextTrackIndex = -1;
        this.m_bSourceHasVideo = false;
        this.m_iNumberVideoTracks = 0;
        this.m_fSourceVideoFrameRate = 0.0f;
        this.m_iSourceVideoBitrate = 0;
        this.m_iSourceVideoStereoMode = -1;
        this.m_SourceVideoId = "";
        this.m_bVideoTracksDirty = false;
        this.m_bVideoTracksDirty_Internal.set(false);
        this.m_bSourceHasAudio = false;
        this.m_iNumberAudioTracks = 0;
        this.m_iSourceAudioBitrate = 0;
        this.m_SourceAudioId = "";
        this.m_bAudioTracksDirty = false;
        this.m_bAudioTracksDirty_Internal.set(false);
        this.m_iNumberTextTracks = 0;
        this.m_bTextCuesDirty = false;
        this.m_bTextCuesDirty_Internal.set(false);
        this.m_bTextTracksDirty = false;
        this.m_bTextTracksDirty_Internal.set(false);
        this.m_bSourceHasTimedText = false;
        this.m_bSourceHasSubtitles = false;
        this.m_DisplayRate_FrameRate = 0.0f;
        this.m_DisplayRate_NumberFrames = 0L;
        this.m_DisplayRate_LastSystemTimeMS = l = System.nanoTime();
        this.m_iLastError = 0;
        serializable = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        this.m_Extracting = serializable;
        this.m_ExtractWaitTimeout = 50;
        this.m_FrameArrivalThreadID = -1L;
        if (random != null) {
            Random random2;
            random = random2;
            random2 = new Random();
        }
        this.m_Random = random;
    }

    private void _CloseVideo() {
        LinkedList<Player_Base$VideoCommand> linkedList;
        AVPLog.Debug("CloseVideo: Closing video in state = " + this.m_VideoState, new Object[0]);
        if (this.m_VideoState == -1) {
            if (this.m_iCurrentOpenCloseCommand.get() == Command_Close) {
                this.m_iCurrentOpenCloseCommand.set(-1);
            }
            return;
        }
        LinkedList<Player_Base$VideoCommand> linkedList2 = linkedList;
        linkedList = new LinkedList<Player_Base$VideoCommand>();
        this.m_CommandQueue = linkedList2;
        this.m_bVideo_AcceptCommands.set(false);
        this.m_Width = 0;
        this.m_Height = 0;
        this.m_DurationMs = 0L;
        this.m_fPlaybackRate = 1.0f;
        this.m_iCurrentAudioTrackIndex = -1;
        this.m_iCurrentVideoTrackIndex = -1;
        this.m_iCurrentTextTrackIndex = -1;
        this.m_iCurrentAudioTrack_NumChannels = 0;
        this.m_iDefaultAudioTrackIndex = -1;
        this.m_iDefaultVideoTrackIndex = -1;
        this.m_iDefaultTextTrackIndex = -1;
        this.m_bSourceHasVideo = false;
        this.m_iNumberVideoTracks = 0;
        this.m_fSourceVideoFrameRate = 0.0f;
        this.m_iSourceVideoBitrate = 0;
        this.m_iSourceVideoStereoMode = -1;
        this.m_SourceVideoId = "";
        this.m_bVideoTracksDirty = false;
        this.m_bVideoTracksDirty_Internal.set(false);
        this.m_bSourceHasAudio = false;
        this.m_iNumberAudioTracks = 0;
        this.m_iSourceAudioBitrate = 0;
        this.m_SourceAudioId = "";
        this.m_bAudioTracksDirty = false;
        this.m_bAudioTracksDirty_Internal.set(false);
        this.m_iNumberTextTracks = 0;
        this.m_bTextCuesDirty = false;
        this.m_bTextCuesDirty_Internal.set(false);
        this.m_bTextTracksDirty = false;
        this.m_bTextTracksDirty_Internal.set(false);
        this.m_bSourceHasTimedText = false;
        this.m_bSourceHasSubtitles = false;
        this.m_TextureTimeStamp = 0L;
        this.m_FrameCount = 0;
        this.m_fBufferingProgressPercent = 0.0f;
        this.m_bVideo_FormatSet.set(false);
        this.m_bVideo_ReadyStateSet.set(false);
        this.m_iLastError = 0;
        this.CloseVideoOnPlayer();
        this.m_VideoState = -1;
        if (this.m_iCurrentOpenCloseCommand.get() == Command_Close) {
            this.m_iCurrentOpenCloseCommand.set(-1);
        }
    }

    /*
     * Exception decompiling
     */
    private void UpdateOpenCloseCommandQueue() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 80->85)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void UpdateTextureTransform() {
    }

    private void UpdateCommandQueue() {
        if (this.m_bVideo_AcceptCommands.get()) {
            Player_Base player_Base = this;
            player_Base._mutex.lock();
            if (player_Base.m_CommandQueue != null) {
                while (!this.m_CommandQueue.isEmpty()) {
                    Player_Base$VideoCommand player_Base$VideoCommand = this.m_CommandQueue.poll();
                    int n = player_Base$VideoCommand._command;
                    if (n == VideoCommand_Play) {
                        this._play();
                        continue;
                    }
                    if (n == VideoCommand_Pause) {
                        this._pause();
                        continue;
                    }
                    if (n == VideoCommand_Stop) {
                        this._stop();
                        continue;
                    }
                    if (n == VideoCommand_Seek) {
                        this._seek(player_Base$VideoCommand._longValue1);
                        continue;
                    }
                    if (n == VideoCommand_SeekFast) {
                        this._seekFast(player_Base$VideoCommand._longValue1);
                        continue;
                    }
                    if (n == VideoCommand_SeekWithTolerances) {
                        Player_Base$VideoCommand player_Base$VideoCommand2 = player_Base$VideoCommand;
                        long l = player_Base$VideoCommand2._longValue1;
                        long l2 = player_Base$VideoCommand2._longValue2;
                        long l3 = player_Base$VideoCommand2._longValue3;
                        this._seekWithTolerances(l, l2, l3);
                        continue;
                    }
                    if (n == VideoCommand_AudioVolumes) {
                        this.UpdateAudioVolumes();
                        continue;
                    }
                    if (n == VideoCommand_SetLooping) {
                        this.UpdateLooping();
                        continue;
                    }
                    if (n == VideoCommand_PlaybackRate) {
                        this._setPlaybackRate(player_Base$VideoCommand._floatValue);
                        continue;
                    }
                    if (n == VideoCommand_SetVideoTrack) {
                        this._SetVideoTrack(player_Base$VideoCommand._intValue);
                        continue;
                    }
                    if (n == VideoCommand_SetAudioTrack) {
                        this._SetAudioTrack(player_Base$VideoCommand._intValue);
                        continue;
                    }
                    if (n != VideoCommand_SetTextTrack) continue;
                    this._SetTextTrack(player_Base$VideoCommand._intValue);
                }
            }
            this._mutex.unlock();
        }
    }

    private void UpdateDisplayFrameRate(int n) {
        long l;
        long l2 = System.nanoTime();
        long l3 = (l2 - this.m_DisplayRate_LastSystemTimeMS) / 1000000L;
        this.m_DisplayRate_NumberFrames = l = this.m_DisplayRate_NumberFrames + (long)n;
        if (l3 >= 500L) {
            Player_Base player_Base = this;
            player_Base.m_DisplayRate_FrameRate = (float)l / ((float)l3 * 0.001f);
            player_Base.m_DisplayRate_NumberFrames = 0L;
            this.m_DisplayRate_LastSystemTimeMS = l2;
        }
    }

    public int GetVideoDimensions() {
        return this.m_newResolution.get();
    }

    public boolean SignalResolutionChange(int n, int n2) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = Integer.toString(n);
        objectArray[1] = Integer.toString(n2);
        AVPLog.Debug("width: {0}, height: {1}", objectArray2);
        int n3 = n & 0xFFFF | (n2 & 0xFFFF) << 16;
        boolean bl = (objectArray8.m_Width & 0xFFFF | (objectArray8.m_Height & 0xFFFF) << 16) != n3;
        if (bl) {
            Object[] objectArray3 = objectArray8;
            Object[] objectArray4 = objectArray8;
            Object[] objectArray5 = objectArray8;
            Object[] objectArray6 = objectArray8;
            Object[] objectArray7 = new Object[2];
            Object[] objectArray8 = objectArray7;
            objectArray8[0] = Integer.toString(n);
            objectArray7[1] = Integer.toString(n2);
            AVPLog.Debug("Resolution has changed to: [{0}, {1}]", objectArray8);
            objectArray6.SetPlayerSurface(Manager.CreateSurface(objectArray5.m_iPlayerIndex, n, n2));
            objectArray5.m_newResolution.set(n3);
            objectArray6.m_resolutionChanged.set(true);
            objectArray4.m_Width = n;
            objectArray3.m_Height = n2;
        }
        return bl;
    }

    public boolean ResolutionHasChanged(int[] nArray) {
        Player_Base player_Base = this;
        int n = player_Base.m_newResolution.get();
        boolean bl = player_Base.m_resolutionChanged.compareAndSet(true, false);
        if (bl) {
            nArray[0] = n & 0xFFFF;
            nArray[1] = n >>> 16;
        }
        return bl;
    }

    public abstract boolean InitialisePlayer(boolean var1, int var2, int var3, int var4, int var5, boolean var6, int var7, int var8, int var9, int var10, double var11, float var13, float var14, boolean var15);

    public abstract void CloseVideoOnPlayer();

    public abstract void DeinitializeVideoPlayer();

    public double[] GetCurrentStateValues() {
        return this.m_aCurrentStateValues;
    }

    public abstract boolean IsPlaying();

    public abstract boolean IsPaused();

    public abstract boolean IsSeeking();

    public abstract boolean IsFinished();

    public abstract boolean CanPlay();

    public abstract boolean OpenVideoFromFileInternal(String var1, long var2, String var4, int var5, int var6, int var7, int var8, boolean var9, boolean var10, boolean var11);

    public abstract void SetLooping(boolean var1);

    public abstract double GetCurrentTimeS();

    public abstract boolean _SetVideoTrack(int var1);

    public abstract boolean _SetAudioTrack(int var1);

    public abstract boolean _SetTextTrack(int var1);

    public abstract String _GetCurrentTextCue();

    public String GetCurrentTextCue() {
        return this.m_CachedTextCue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] GetVideoTrackInfoNew(int n) {
        if (n <= -1) return null;
        Player_Base$TrackInfoForReturn[] player_Base$TrackInfoForReturnArray = player_Base$TrackInfoForReturnArray.m_aVideoTrackInfo;
        if (n >= player_Base$TrackInfoForReturnArray.m_aVideoTrackInfo.length) return null;
        Object[] objectArray = player_Base$TrackInfoForReturnArray[n].m_aObjects;
        return objectArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] GetAudioTrackInfoNew(int n) {
        if (n <= -1) return null;
        Player_Base$TrackInfoForReturn[] player_Base$TrackInfoForReturnArray = player_Base$TrackInfoForReturnArray.m_aAudioTrackInfo;
        if (n >= player_Base$TrackInfoForReturnArray.m_aAudioTrackInfo.length) return null;
        Object[] objectArray = player_Base$TrackInfoForReturnArray[n].m_aObjects;
        return objectArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] GetTextTrackInfoNew(int n) {
        if (n <= -1) return null;
        Player_Base$TrackInfoForReturn[] player_Base$TrackInfoForReturnArray = player_Base$TrackInfoForReturnArray.m_aTextTrackInfo;
        if (n >= player_Base$TrackInfoForReturnArray.m_aTextTrackInfo.length) return null;
        Object[] objectArray = player_Base$TrackInfoForReturnArray[n].m_aObjects;
        return objectArray;
    }

    public abstract void InternalUpdateVideoTrackInfoNew(int var1);

    public abstract void InternalUpdateTextTrackInfoNew(int var1);

    public abstract void InternalUpdateAudioTrackInfoNew(int var1);

    public double[] GetAssetInfo() {
        double d;
        this.m_aAssetInfo[0] = 1.0;
        this.m_aAssetInfo[1] = d = this.GetDurationS();
        this.m_aAssetInfo[2] = d = (double)this.GetWidth();
        this.m_aAssetInfo[3] = d = (double)this.GetHeight();
        this.m_aAssetInfo[4] = d = (double)this.GetSourceVideoFrameRate();
        this.m_aAssetInfo[5] = d = (double)this.GetNumberVideoTracks();
        this.m_aAssetInfo[6] = d = (double)this.GetNumberAudioTracks();
        this.m_aAssetInfo[7] = d = (double)this.GetNumberTextTracks();
        AVPLog.Debug("GetAssetInfo: duration = " + this.m_aAssetInfo[1] + " | width = " + this.m_aAssetInfo[2] + " | height = " + this.m_aAssetInfo[3] + " | frameRate = " + this.m_aAssetInfo[4] + " | videoTrackCount = " + this.m_aAssetInfo[5] + " | audioTrackCount = " + this.m_aAssetInfo[6] + " | textTrackCount = " + this.m_aAssetInfo[7], new Object[0]);
        return this.m_aAssetInfo;
    }

    public abstract void SetHeadRotation(float var1, float var2, float var3, float var4);

    public abstract void SetFocusRotation(float var1, float var2, float var3, float var4);

    public abstract void SetFocusProps(float var1, float var2);

    public abstract void SetPositionTrackingEnabled(boolean var1);

    public abstract void SetFocusEnabled(boolean var1);

    public abstract void _play();

    public abstract void _pause();

    public abstract void _stop();

    public abstract void _seekWithTolerances(long var1, long var3, long var5);

    public abstract void _seek(long var1);

    public abstract void _seekFast(long var1);

    public abstract void _setPlaybackRate(float var1);

    public abstract void UpdateAudioVolumes();

    public abstract void UpdateLooping();

    public abstract void SetPlayerSurface(Surface var1);

    public abstract float GetBufferingProgressPercent();

    public abstract double GetCurrentAbsoluteTimestamp();

    public abstract long UpdateAPITextureTimestampNS();

    public double[] GetSeekableTimeRanges() {
        return this.m_aCachedSeekableTimeRangesResult;
    }

    public abstract double[] _GetSeekableTimeRanges();

    public double[] GetBufferedTimeRanges() {
        return this.m_aCachedBufferedTimeRangesResult;
    }

    public abstract double[] _GetBufferedTimeRanges();

    public long GetEstimatedBandwidthUsed() {
        return 0L;
    }

    public abstract boolean SetPreferredVideoResolutionAndBitrate(int var1, int var2, int var3);

    public abstract float[] GrabAudio(int var1, int var2);

    public abstract int GetAudioBufferedSampleCount();

    public abstract boolean IsMediaCachingSupported();

    public abstract void AddMediaToCache(String var1, String var2, double var3, int var5, int var6);

    public abstract void AddMediaToCache(String var1, String var2, double var3, int var5, int var6, double var7, int var9, int var10);

    public abstract void RemoveMediaFromCache(String var1);

    public abstract void CancelDownloadOfMediaToCache(String var1);

    public abstract void PauseDownloadOfMediaToCache(String var1);

    public abstract void ResumeDownloadOfMediaToCache(String var1);

    public abstract double[] GetCachedMediaStatus(String var1);

    public void SetSurface(Surface surface) {
    }

    public boolean Initialise(Context context, boolean bl, int n, int n2, int n3, int n4, boolean bl2, int n5, int n6, int n7, int n8, double d, float f, float f2, boolean bl3) {
        Player_Base player_Base = this;
        AVPLog.Debug("iMinBufferMs = " + n5 + " | iMaxBufferMs = " + n6 + " | iBufferForPlaybackMs = " + n7 + " | iBufferForPlaybackAfterRebufferMs = " + n8, new Object[0]);
        player_Base.m_Context = context;
        player_Base.SetPlayerOptions(player_Base.m_bShowPosterFrame);
        return this.InitialisePlayer(bl, n, n2, n3, n4, bl2, n5, n6, n7, n8, d, f, f2, bl3);
    }

    public boolean StartExtractFrame() {
        if (this.m_FrameArrivalThreadID == Thread.currentThread().getId()) {
            return false;
        }
        if (this.m_Extracting.get()) {
            return true;
        }
        this.m_Extracting.set(true);
        return true;
    }

    public void WaitForExtract() {
        int n = 0;
        while (n++ < this.m_ExtractWaitTimeout && this.m_Extracting.get()) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {}
            break;
        }
        this.m_Extracting.set(false);
    }

    public void WaitForNewFrame() {
        Player_Base player_Base = this;
        int n = player_Base.m_FrameCount;
        int n2 = 0;
        int n3 = player_Base.m_iNumberFramesAvailable.get();
        while (n + n3 >= this.m_FrameCount && n2++ < this.m_ExtractWaitTimeout) {
            Manager.RenderPlayer(this.m_iPlayerIndex);
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {}
            break;
        }
        this.m_Extracting.set(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void CloseVideo() {
        AVPLog.Debug("CloseVideo CALLED", new Object[0]);
        var1_1 = this.m_OpenCloseCommandQueue;
        synchronized (var1_1) {
            block10: {
                try {
                    for (var2_2 = 0; var2_2 < this.m_OpenCloseCommandQueue.size(); ++var2_2) {
                        AVPLog.Debug("CloseVideo: command (" + var2_2 + ") : command = " + this.m_OpenCloseCommandQueue.get((int)var2_2)._command, new Object[0]);
                    }
                }
                catch (Throwable v0) {
                    break block10;
                }
                {
                    if (this.m_OpenCloseCommandQueue.size() > 0) {
                        if (this.m_OpenCloseCommandQueue.getLast()._command == Player_Base.Command_Close) {
                            AVPLog.Debug("CloseVideo: Early out : Last command is already a close", new Object[0]);
                            return;
                        }
                        if (this.m_iCurrentOpenCloseCommand.get() == Player_Base.Command_Close && this.m_OpenCloseCommandQueue.getFirst()._command == Player_Base.Command_Open) {
                            AVPLog.Debug("CloseVideo: Early out : Currently closing and the next is an open, just remove the open", new Object[0]);
                            this.m_OpenCloseCommandQueue.clear();
                            return;
                        }
                    }
                    if (this.m_OpenCloseCommandQueue.size() <= 1 || this.m_OpenCloseCommandQueue.getFirst()._command != Player_Base.Command_Close || this.m_OpenCloseCommandQueue.get((int)1)._command != Player_Base.Command_Open) ** GOTO lbl28
                    v1 = var1_1;
                    v2 = this;
                    AVPLog.Debug("CloseVideo: Early out : Currently closing and the next is an open, just remove everything except the close", new Object[0]);
                    v2.m_OpenCloseCommandQueue.clear();
                    v2.m_OpenCloseCommandQueue.add(new Player_Base$OpenCloseCommand(Player_Base.Command_Close));
                }
                {
                    // ** MonitorExit[v1] (shouldn't be in output)
                    return;
lbl28:
                    // 1 sources

                    v3 = var1_1;
                    AVPLog.Debug("CloseVideo: Something already being processed currently, add the close to the list", new Object[0]);
                    this.m_OpenCloseCommandQueue.add(new Player_Base$OpenCloseCommand(Player_Base.Command_Close));
                }
                {
                    // ** MonitorExit[v3] (shouldn't be in output)
                    return;
                }
            }
            throw v0;
        }
    }

    public void Deinitialise() {
        Player_Base player_Base = this;
        player_Base._CloseVideo();
        player_Base._mutex.lock();
        Queue<Player_Base$VideoCommand> queue = player_Base.m_CommandQueue;
        if (queue != null) {
            queue.clear();
            this.m_CommandQueue = null;
        }
        Player_Base player_Base2 = this;
        player_Base2._mutex.unlock();
        player_Base2.DeinitializeVideoPlayer();
    }

    public void SetShowPosterFrame(boolean bl) {
        this.m_bShowPosterFrame = bl;
    }

    public void SetSetting_AudioSubsystem(int n) {
        this.m_iSetting_AudioSubsystem = n;
    }

    public void SetSetting_Audio360ChannelIndex(int n) {
        this.m_iSetting_Audio360ChannelIndex = n;
    }

    public void SetSetting_Audio360LatencyMS(int n) {
        this.m_iSetting_Audio360LatencyMS = n;
    }

    public void SetSetting_ForcedFileFormat(int n) {
        this.m_iSetting_ForcedFileFormat = n;
    }

    public void SetSetting_PreferSoftwareDecoder(boolean bl) {
        this.m_bSetting_PreferSoftwareDecoder = bl;
    }

    public void SetSetting_ForceRtpTCP(boolean bl) {
        this.m_bSetting_ForceRtpTCP = bl;
    }

    public void SetSetting_ForceEnableMediaCodecAsynchronousQueueing(boolean bl) {
        this.m_bSetting_ForceEnableMediaCodecAsynchronousQueueing = bl;
    }

    public void SetSetting_FileOffset(int n) {
        this.m_iFileOffset = n;
    }

    public void PlayerRendererSetup() {
    }

    public void PlayerRenderUpdate() {
        double d;
        double d2;
        double d3;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String string;
        int n6;
        int n7;
        double[] dArray;
        double[] dArray2;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int d4;
        this.UpdateOpenCloseCommandQueue();
        int n15 = this.CanPlay();
        if (this.IsPlaying()) {
            d4 = n15 | 2;
        }
        if (this.IsPaused()) {
            n14 = d4 | 4;
        }
        if (this.IsFinished()) {
            n13 = n14 | 8;
        }
        if (this.IsSeeking()) {
            n12 = n13 | 0x10;
        }
        if (this.IsBuffering()) {
            n11 = n12 | 0x20;
        }
        if (this.m_bFinishedSeeking) {
            n10 = n11 | 0x200;
            this.m_bFinishedSeeking = false;
        }
        if (this.m_iLastError != 0) {
            n9 = n10 | Integer.MIN_VALUE;
        }
        if (this.GetVideoTracksDirty() || this.GetAudioTracksDirty() || this.GetTextTracksDirty()) {
            n8 = n9 | 0x10000;
            this.m_bVideoTracksDirty = false;
            this.m_bAudioTracksDirty = false;
            this.m_bTextTracksDirty = false;
        }
        this._GetSeekableTimeRanges();
        boolean bl = false;
        int n16 = 0;
        while (true) {
            dArray2 = this.m_aGetSeekableTimeRangesResult;
            if (n16 >= this.m_aGetSeekableTimeRangesResult.length) break;
            double d5 = dArray2[n16];
            dArray = this.m_aCachedSeekableTimeRangesResult;
            if (d5 != this.m_aCachedSeekableTimeRangesResult[n16]) {
                bl = true;
            }
            dArray[n16] = d5;
            ++n16;
        }
        if (bl) {
            n7 = n8 | 0x80000;
        }
        this._GetBufferedTimeRanges();
        bl = false;
        n16 = 0;
        while (true) {
            dArray2 = this.m_aGetBufferedTimeRangesResult;
            if (n16 >= this.m_aGetBufferedTimeRangesResult.length) break;
            double d6 = dArray2[n16];
            dArray = this.m_aCachedBufferedTimeRangesResult;
            if (d6 != this.m_aCachedBufferedTimeRangesResult[n16]) {
                bl = true;
            }
            dArray[n16] = d6;
            ++n16;
        }
        if (bl) {
            n6 = n7 | 0x40000;
        }
        if ((string = this._GetCurrentTextCue()).compareTo(this.m_CachedTextCue) != 0) {
            this.m_CachedTextCue = string;
            n5 = n6 | 0x100000;
        }
        if (this.HasVideo()) {
            n4 = n5 | 0x1000000;
        }
        if (this.HasAudio()) {
            n3 = n4 | 0x2000000;
        }
        if (this.HasTimedText()) {
            n2 = n3 | 0x4000000;
        }
        if (this.HasMetaData()) {
            n = n2 | 0x8000000;
        }
        if ((d3 = this.GetCurrentAbsoluteTimestamp()) != 0.0) {
            d3 -= (double)Instant.parse("2001-01-01T00:00:00Z").toEpochMilli() * 0.001;
        }
        this.m_aCurrentStateValues[0] = d2 = (double)n;
        this.m_aCurrentStateValues[1] = d2 = this.GetCurrentTimeS();
        double[] dArray3 = this.m_aCurrentStateValues;
        dArray3[2] = d3;
        dArray3[3] = d = (double)this.m_iCurrentVideoTrackIndex;
        dArray3[4] = d = (double)this.m_iCurrentAudioTrackIndex;
        dArray3[5] = d = (double)this.m_iCurrentTextTrackIndex;
        dArray3[6] = 2.0;
        dArray3[7] = 2.0;
        this.m_aCurrentStateValues[8] = d = (double)this.GetAudioBufferedSampleCount();
    }

    public int GetPlayerIndex() {
        return this.m_iPlayerIndex;
    }

    public int GetLastErrorCode() {
        this.m_iLastError = 0;
        return this.m_iLastError;
    }

    public void SetPlayerOptions(boolean bl) {
        this.m_bShowPosterFrame = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean OpenVideoFromFile(String string, String string2) {
        Object object = "OpenVideoFromFile: filePath = ";
        LinkedList<Player_Base$OpenCloseCommand> linkedList = this.m_OpenCloseCommandQueue;
        synchronized (linkedList) {
            Player_Base$OpenCloseCommand player_Base$OpenCloseCommand;
            AVPLog.Debug((String)object + string + " | forcedFileFormat = " + this.m_iSetting_ForcedFileFormat + " | audioSubsystem = " + this.m_iSetting_AudioSubsystem + " | audio360Channels = " + this.m_iSetting_Audio360ChannelIndex + " | audio360LatencyMS = " + this.m_iSetting_Audio360LatencyMS + " | preferSoftwareDecoder = " + this.m_bSetting_PreferSoftwareDecoder + " | forceRtpTCP = " + this.m_bSetting_ForceRtpTCP + " | forceEnableMediaCodecAsynchronousQueueing = " + this.m_bSetting_ForceEnableMediaCodecAsynchronousQueueing, new Object[0]);
            object = player_Base$OpenCloseCommand;
            Player_Base player_Base = this;
            Object object2 = object;
            Player_Base player_Base2 = this;
            Object object3 = object;
            Player_Base player_Base3 = this;
            Object object4 = object;
            Player_Base player_Base4 = this;
            Object object5 = object;
            Player_Base player_Base5 = this;
            Object object6 = object;
            Player_Base player_Base6 = this;
            Object object7 = object;
            Player_Base player_Base7 = this;
            Object object8 = object;
            String string3 = string2;
            Object object9 = object;
            ((Player_Base$OpenCloseCommand)object)(Command_Open);
            ((Player_Base$OpenCloseCommand)object)._FilePath = string;
            long l = this.m_iFileOffset;
            ((Player_Base$OpenCloseCommand)object9)._FileOffset = l;
            ((Player_Base$OpenCloseCommand)object8)._Header = string3;
            ((Player_Base$OpenCloseCommand)object7)._ForcedFileFormat = player_Base7.m_iSetting_ForcedFileFormat;
            ((Player_Base$OpenCloseCommand)object6)._AudioSubsystem = player_Base6.m_iSetting_AudioSubsystem;
            ((Player_Base$OpenCloseCommand)object5)._Audio360Channels = player_Base5.m_iSetting_Audio360ChannelIndex;
            ((Player_Base$OpenCloseCommand)object4)._Audio360LatencyMS = player_Base4.m_iSetting_Audio360LatencyMS;
            ((Player_Base$OpenCloseCommand)object3)._PreferSoftwareDecoder = player_Base3.m_bSetting_PreferSoftwareDecoder;
            ((Player_Base$OpenCloseCommand)object2)._ForceRtpTCP = player_Base2.m_bSetting_ForceRtpTCP;
            player_Base$OpenCloseCommand._ForceEnableMediaCodecAsynchronousQueueing = player_Base.m_bSetting_ForceEnableMediaCodecAsynchronousQueueing;
            this.m_OpenCloseCommandQueue.add((Player_Base$OpenCloseCommand)object);
            return true;
        }
    }

    public boolean _OpenVideoFromFile(String string, long l, String string2, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        AVPLog.Debug("_OpenVideoFromFile: " + string, new Object[0]);
        this._CloseVideo();
        this.m_VideoState = 1;
        this.m_iCurrentVideoTrackIndex = -1;
        this.m_iCurrentAudioTrackIndex = -1;
        this.m_iCurrentTextTrackIndex = -1;
        this.m_iCurrentAudioTrack_NumChannels = 0;
        this.m_iDefaultAudioTrackIndex = -1;
        this.m_iDefaultVideoTrackIndex = -1;
        this.m_iDefaultTextTrackIndex = -1;
        this.m_bSourceHasVideo = false;
        this.m_bSourceHasAudio = false;
        this.m_iNumberAudioTracks = 0;
        this.m_iNumberVideoTracks = 0;
        this.m_bVideoTracksDirty = false;
        this.m_bVideoTracksDirty_Internal.set(false);
        this.m_bAudioTracksDirty = false;
        this.m_bAudioTracksDirty_Internal.set(false);
        this.m_iNumberTextTracks = 0;
        this.m_bTextCuesDirty = false;
        this.m_bTextCuesDirty_Internal.set(false);
        this.m_bTextTracksDirty = false;
        this.m_bTextTracksDirty_Internal.set(false);
        this.m_bSourceHasTimedText = false;
        this.m_bSourceHasSubtitles = false;
        this.m_fSourceVideoFrameRate = 0.0f;
        this.m_DurationMs = 0L;
        this.m_FrameCount = 0;
        this.m_bIsStream = false;
        this.m_bIsLive = false;
        this.m_bIsBuffering = false;
        this.m_bIsSeeking = false;
        this.m_bFinishedSeeking = false;
        this.m_fBufferingProgressPercent = 0.0f;
        boolean bl4 = this.OpenVideoFromFileInternal(string, l, string2, n, n2, n3, n4, bl, bl2, bl3);
        if (!bl4) {
            this.m_VideoState = -1;
        }
        AVPLog.Debug("_OpenVideoFromFile : OpenVideoFromFileInternal returned " + bl4, new Object[0]);
        return bl4;
    }

    public void SetKeyServerAuthToken(String string) {
        this.m_KeyServerAuthToken = string;
    }

    public void SetOverrideDecryptionKey(byte[] object) {
        object = object != null ? (Object)Base64.encodeToString((byte[])object, (int)0) : null;
        this.m_OverrideDecryptionKey = object;
    }

    public boolean IsLooping() {
        return this.m_bLooping;
    }

    public int GetFrameCount() {
        return this.m_FrameCount;
    }

    public double GetDurationS() {
        return this.m_bIsLive ? Double.POSITIVE_INFINITY : (double)this.m_DurationMs * 0.001;
    }

    public int GetWidth() {
        return this.m_Width;
    }

    public int GetHeight() {
        return this.m_Height;
    }

    public float GetDisplayRate() {
        return this.m_DisplayRate_FrameRate;
    }

    public float GetPlaybackRate() {
        return this.m_fPlaybackRate;
    }

    public boolean HasVideo() {
        return this.m_bSourceHasVideo;
    }

    public boolean HasMetaData() {
        return this.GetDurationS() > 0.0 && (this.m_bSourceHasVideo && this.GetWidth() > 0 && this.GetHeight() > 0 || this.m_bSourceHasAudio);
    }

    public boolean HasAudio() {
        return this.m_bSourceHasAudio;
    }

    public boolean HasTimedText() {
        return this.m_bSourceHasTimedText;
    }

    public boolean HasSubtitles() {
        return this.m_bSourceHasSubtitles;
    }

    public boolean IsMuted() {
        return this.m_AudioMuted;
    }

    public float GetVolume() {
        return this.m_AudioVolume;
    }

    public float GetAudioPan() {
        return this.m_AudioPan;
    }

    public int GetCurrentVideoTrackStereoMode() {
        return this.m_iSourceVideoStereoMode;
    }

    public int GetCurrentVideoTrackBitrate() {
        return this.m_iSourceVideoBitrate;
    }

    public String GetCurrentVideoTrackId() {
        return this.m_SourceVideoId;
    }

    public int GetCurrentAudioTrackBitrate() {
        return this.m_iSourceAudioBitrate;
    }

    public String GetCurrentAudioTrackId() {
        return this.m_SourceAudioId;
    }

    public boolean GetTextCueDirty() {
        return this.m_bTextCuesDirty;
    }

    public boolean GetTextTracksDirty() {
        return this.m_bTextTracksDirty;
    }

    public boolean GetVideoTracksDirty() {
        return this.m_bVideoTracksDirty;
    }

    public boolean GetAudioTracksDirty() {
        return this.m_bAudioTracksDirty;
    }

    public Map<String, String> GetStringAsMap(String stringArray, String string) {
        Player_Base player_Base = object;
        AVPLog.Debug("GetStringAsMap CALLED", new Object[0]);
        Object object = null;
        if (player_Base.m_bUltraBuild) {
            if (stringArray != null && !stringArray.isEmpty()) {
                HashMap hashMap;
                object = hashMap;
                hashMap = new HashMap();
                stringArray = stringArray.split("[\\r\\n]+");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object2 = stringArray[i].split(":", 2);
                    String string2 = object2[0];
                    object2 = ((String[])object2).length == 1 ? "" : object2[1];
                    ((HashMap)object).put(string2, object2);
                }
            }
            if (string != null && !string.isEmpty()) {
                if (object == null) {
                    HashMap hashMap;
                    object = hashMap;
                    hashMap = new HashMap();
                }
                ((HashMap)object).put("Authorization", string);
            }
            if (object != null) {
                AVPLog.Debug("GetStringAsMap : pairsMap = " + object.toString(), new Object[0]);
            }
        }
        return object;
    }

    public void Play() {
        Player_Base player_Base = this;
        player_Base.RemoveDuplicateCommand(VideoCommand_Stop);
        player_Base.RemoveDuplicateCommand(VideoCommand_Play);
        player_Base.RemoveDuplicateCommand(VideoCommand_Pause);
        player_Base.AddVideoCommandInt(VideoCommand_Play, 0);
        AVPLog.Debug("Adding VideoCommand_Play to the command queue", new Object[0]);
    }

    public void Pause() {
        Player_Base player_Base = this;
        player_Base.RemoveDuplicateCommand(VideoCommand_Stop);
        player_Base.RemoveDuplicateCommand(VideoCommand_Play);
        player_Base.RemoveDuplicateCommand(VideoCommand_Pause);
        player_Base.AddVideoCommandInt(VideoCommand_Pause, 0);
    }

    public void Stop() {
        Player_Base player_Base = this;
        player_Base.RemoveDuplicateCommand(VideoCommand_Stop);
        player_Base.RemoveDuplicateCommand(VideoCommand_Play);
        player_Base.RemoveDuplicateCommand(VideoCommand_Pause);
        player_Base.AddVideoCommandInt(VideoCommand_Stop, 0);
    }

    public void Seek(double d) {
        Player_Base player_Base = this;
        player_Base.RemoveDuplicateCommand(VideoCommand_Seek);
        player_Base.RemoveDuplicateCommand(VideoCommand_SeekFast);
        player_Base.RemoveDuplicateCommand(VideoCommand_SeekWithTolerances);
        int n = VideoCommand_Seek;
        long l = (long)Math.floor(d * 1000.0);
        this.AddVideoCommandLong(n, l);
    }

    public void SeekFast(double d) {
        Player_Base player_Base = this;
        player_Base.RemoveDuplicateCommand(VideoCommand_Seek);
        player_Base.RemoveDuplicateCommand(VideoCommand_SeekFast);
        player_Base.RemoveDuplicateCommand(VideoCommand_SeekWithTolerances);
        int n = VideoCommand_SeekFast;
        long l = (long)Math.floor(d * 1000.0);
        this.AddVideoCommandLong(n, l);
    }

    public void SeekWithTolerances(double d, long l, long l2) {
        Player_Base player_Base = this;
        player_Base.RemoveDuplicateCommand(VideoCommand_Seek);
        player_Base.RemoveDuplicateCommand(VideoCommand_SeekFast);
        player_Base.RemoveDuplicateCommand(VideoCommand_SeekWithTolerances);
        int n = VideoCommand_SeekWithTolerances;
        long l3 = (long)Math.floor(d * 1000.0);
        this.AddVideoCommandLongLongLong(n, l3, l, l2);
    }

    public void SetPlaybackRate(float f) {
        Player_Base player_Base = this;
        player_Base.RemoveDuplicateCommand(VideoCommand_PlaybackRate);
        player_Base.AddVideoCommandFloat(VideoCommand_PlaybackRate, f);
    }

    public void SetVideoTrack(int n) {
        Player_Base player_Base = this;
        player_Base.RemoveDuplicateCommand(VideoCommand_SetVideoTrack);
        player_Base.AddVideoCommandInt(VideoCommand_SetVideoTrack, n);
    }

    public void SetAudioTrack(int n) {
        Player_Base player_Base = this;
        player_Base.RemoveDuplicateCommand(VideoCommand_SetAudioTrack);
        player_Base.AddVideoCommandInt(VideoCommand_SetAudioTrack, n);
    }

    public void SetTextTrack(int n) {
        Player_Base player_Base = this;
        player_Base.RemoveDuplicateCommand(VideoCommand_SetTextTrack);
        player_Base.AddVideoCommandInt(VideoCommand_SetTextTrack, n);
    }

    public int GetCurrentAudioTrackIndex() {
        return this.m_iCurrentAudioTrackIndex;
    }

    public int GetNumberAudioTracks() {
        return this.m_iNumberAudioTracks;
    }

    public int GetCurrentAudioTrackNumChannels() {
        return this.m_iCurrentAudioTrack_NumChannels;
    }

    public int GetCurrentVideoTrackIndex() {
        return this.m_iCurrentVideoTrackIndex;
    }

    public int GetNumberVideoTracks() {
        return this.m_iNumberVideoTracks;
    }

    public int GetCurrentTextTrackIndex() {
        return this.m_iCurrentTextTrackIndex;
    }

    public int GetNumberTextTracks() {
        return this.m_iNumberTextTracks;
    }

    public boolean IsBuffering() {
        return this.m_bIsBuffering;
    }

    public float GetSourceVideoFrameRate() {
        return this.m_fSourceVideoFrameRate;
    }

    public long GetTextureTimeStamp() {
        return this.m_TextureTimeStamp / 100L;
    }

    public void MuteAudio(boolean bl) {
        Player_Base player_Base = this;
        player_Base.m_AudioMuted = bl;
        player_Base.RemoveDuplicateCommand(VideoCommand_AudioVolumes);
        player_Base.AddVideoCommandInt(VideoCommand_AudioVolumes, 0);
    }

    public void SetVolume(float f) {
        Player_Base player_Base = this;
        player_Base.m_AudioVolume = Math.max(Math.min(f, 1.0f), 0.0f);
        player_Base.RemoveDuplicateCommand(VideoCommand_AudioVolumes);
        player_Base.AddVideoCommandInt(VideoCommand_AudioVolumes, 0);
    }

    public void SetAudioPan(float f) {
        Player_Base player_Base = this;
        player_Base.m_AudioPan = Math.max(Math.min(f, 1.0f), -1.0f);
        player_Base.RemoveDuplicateCommand(VideoCommand_AudioVolumes);
        player_Base.AddVideoCommandInt(VideoCommand_AudioVolumes, 0);
    }

    public void RemoveDuplicateCommand(int n) {
        Player_Base player_Base = this;
        player_Base._mutex.lock();
        Queue<Player_Base$VideoCommand> queue = player_Base.m_CommandQueue;
        if (queue != null) {
            queue.removeIf(player_Base$VideoCommand -> player_Base$VideoCommand._command == n);
        }
        this._mutex.unlock();
    }

    public void AddVideoCommandInt(int n, int n2) {
        Player_Base player_Base = this;
        player_Base._mutex.lock();
        Object object = player_Base.m_CommandQueue;
        if (object != null) {
            Player_Base$VideoCommand player_Base$VideoCommand;
            Queue<Player_Base$VideoCommand> queue = object;
            object = player_Base$VideoCommand;
            new Player_Base$VideoCommand()._command = n;
            new Player_Base$VideoCommand()._intValue = n2;
            queue.add((Player_Base$VideoCommand)object);
        }
        this._mutex.unlock();
    }

    public void AddVideoCommandLong(int n, long l) {
        Player_Base player_Base = this;
        player_Base._mutex.lock();
        Object object = player_Base.m_CommandQueue;
        if (object != null) {
            Player_Base$VideoCommand player_Base$VideoCommand;
            Queue<Player_Base$VideoCommand> queue = object;
            object = player_Base$VideoCommand;
            new Player_Base$VideoCommand()._command = n;
            new Player_Base$VideoCommand()._longValue1 = l;
            queue.add((Player_Base$VideoCommand)object);
        }
        this._mutex.unlock();
    }

    public void AddVideoCommandLongLongLong(int n, long l, long l2, long l3) {
        Player_Base player_Base = this;
        player_Base._mutex.lock();
        Object object = player_Base.m_CommandQueue;
        if (object != null) {
            Player_Base$VideoCommand player_Base$VideoCommand;
            Queue<Player_Base$VideoCommand> queue = object;
            object = player_Base$VideoCommand;
            new Player_Base$VideoCommand()._command = n;
            new Player_Base$VideoCommand()._longValue1 = l;
            new Player_Base$VideoCommand()._longValue2 = l2;
            new Player_Base$VideoCommand()._longValue3 = l3;
            queue.add((Player_Base$VideoCommand)object);
        }
        this._mutex.unlock();
    }

    public void AddVideoCommandFloat(int n, float f) {
        Player_Base player_Base = this;
        player_Base._mutex.lock();
        Object object = player_Base.m_CommandQueue;
        if (object != null) {
            Player_Base$VideoCommand player_Base$VideoCommand;
            Queue<Player_Base$VideoCommand> queue = object;
            object = player_Base$VideoCommand;
            new Player_Base$VideoCommand()._command = n;
            new Player_Base$VideoCommand()._floatValue = f;
            queue.add((Player_Base$VideoCommand)object);
        }
        this._mutex.unlock();
    }

    public void Update() {
        Player_Base$TrackInfoForReturn[] player_Base$TrackInfoForReturnArray;
        Player_Base player_Base = this;
        player_Base.m_bTextCuesDirty = player_Base.m_bTextCuesDirty_Internal.getAndSet(false);
        if (player_Base.m_bVideoTracksDirty_Internal.getAndSet(false)) {
            player_Base$TrackInfoForReturnArray = this.m_aVideoTrackInfo;
            if (this.m_aVideoTrackInfo != null && player_Base$TrackInfoForReturnArray.length > 0) {
                ((Activity)this.m_Context).runOnUiThread((Runnable)new Player_Base$1(this));
            }
        }
        if (this.m_bAudioTracksDirty_Internal.getAndSet(false)) {
            player_Base$TrackInfoForReturnArray = this.m_aAudioTrackInfo;
            if (this.m_aAudioTrackInfo != null && player_Base$TrackInfoForReturnArray.length > 0) {
                ((Activity)this.m_Context).runOnUiThread((Runnable)new Player_Base$2(this));
            } else {
                this.m_bAudioTracksDirty = true;
            }
        }
        if (this.m_bTextTracksDirty_Internal.getAndSet(false)) {
            player_Base$TrackInfoForReturnArray = this.m_aTextTrackInfo;
            if (this.m_aTextTrackInfo != null && player_Base$TrackInfoForReturnArray.length > 0) {
                ((Activity)this.m_Context).runOnUiThread((Runnable)new Player_Base$3(this));
            } else {
                this.m_bTextTracksDirty = true;
            }
        }
        Player_Base player_Base2 = this;
        player_Base2.PlayerRenderUpdate();
        player_Base2.UpdateCommandQueue();
    }

    public boolean Render() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        Player_Base player_Base = this;
        synchronized (player_Base) {
            player_Base.m_FrameArrivalThreadID = Thread.currentThread().getId();
            player_Base.m_iNumberFramesAvailable.incrementAndGet();
            return;
        }
    }

    public abstract void UpdateVideoMetadata();
}

