/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.hls.playlist;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.hls.HlsDataSourceFactory;
import androidx.media3.exoplayer.hls.playlist.HlsMediaPlaylist;
import androidx.media3.exoplayer.hls.playlist.HlsMultivariantPlaylist;
import androidx.media3.exoplayer.hls.playlist.HlsPlaylistParserFactory;
import androidx.media3.exoplayer.source.MediaSourceEventListener;
import androidx.media3.exoplayer.upstream.LoadErrorHandlingPolicy;
import java.io.IOException;

@UnstableApi
public interface HlsPlaylistTracker {
    public void start(Uri var1, MediaSourceEventListener.EventDispatcher var2, PrimaryPlaylistListener var3);

    public void stop();

    public void addListener(PlaylistEventListener var1);

    public void removeListener(PlaylistEventListener var1);

    @Nullable
    public HlsMultivariantPlaylist getMultivariantPlaylist();

    @Nullable
    public HlsMediaPlaylist getPlaylistSnapshot(Uri var1, boolean var2);

    public long getInitialStartTimeUs();

    public boolean isSnapshotValid(Uri var1);

    public void maybeThrowPrimaryPlaylistRefreshError() throws IOException;

    public void maybeThrowPlaylistRefreshError(Uri var1) throws IOException;

    public boolean excludeMediaPlaylist(Uri var1, long var2);

    public void refreshPlaylist(Uri var1);

    public boolean isLive();

    public static final class PlaylistResetException
    extends IOException {
        public final Uri url;

        public PlaylistResetException(Uri url) {
            this.url = url;
        }
    }

    public static final class PlaylistStuckException
    extends IOException {
        public final Uri url;

        public PlaylistStuckException(Uri url) {
            this.url = url;
        }
    }

    public static interface PlaylistEventListener {
        public void onPlaylistChanged();

        public boolean onPlaylistError(Uri var1, LoadErrorHandlingPolicy.LoadErrorInfo var2, boolean var3);
    }

    public static interface PrimaryPlaylistListener {
        public void onPrimaryPlaylistRefreshed(HlsMediaPlaylist var1);
    }

    public static interface Factory {
        public HlsPlaylistTracker createTracker(HlsDataSourceFactory var1, LoadErrorHandlingPolicy var2, HlsPlaylistParserFactory var3);
    }
}

