/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp;

import androidx.media3.common.ParserException;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.rtsp.RtspMessageUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UnstableApi
final class RtspSessionTiming {
    public static final RtspSessionTiming DEFAULT = new RtspSessionTiming(0L, -9223372036854775807L);
    private static final Pattern NPT_RANGE_PATTERN = Pattern.compile("npt[:=]([.\\d]+|now)\\s?-\\s?([.\\d]+)?");
    private static final String START_TIMING_NTP_FORMAT = "npt=%.3f-";
    private static final long LIVE_START_TIME = 0L;
    public final long startTimeMs;
    public final long stopTimeMs;

    public static RtspSessionTiming parseTiming(String sdpRangeAttribute) throws ParserException {
        long stopTimeMs;
        Matcher matcher = NPT_RANGE_PATTERN.matcher(sdpRangeAttribute);
        RtspMessageUtil.checkManifestExpression(matcher.matches(), sdpRangeAttribute);
        String startTimeString = matcher.group(1);
        RtspMessageUtil.checkManifestExpression(startTimeString != null, sdpRangeAttribute);
        long startTimeMs = ((String)Util.castNonNull((Object)startTimeString)).equals("now") ? 0L : (long)(Float.parseFloat(startTimeString) * 1000.0f);
        String stopTimeString = matcher.group(2);
        if (stopTimeString != null) {
            try {
                stopTimeMs = (long)(Float.parseFloat(stopTimeString) * 1000.0f);
            }
            catch (NumberFormatException e) {
                throw ParserException.createForMalformedManifest((String)stopTimeString, (Throwable)e);
            }
            RtspMessageUtil.checkManifestExpression(stopTimeMs >= startTimeMs, sdpRangeAttribute);
        } else {
            stopTimeMs = -9223372036854775807L;
        }
        return new RtspSessionTiming(startTimeMs, stopTimeMs);
    }

    public static String getOffsetStartTimeTiming(long offsetStartTimeMs) {
        double offsetStartTimeSec = (double)offsetStartTimeMs / 1000.0;
        return Util.formatInvariant((String)START_TIMING_NTP_FORMAT, (Object[])new Object[]{offsetStartTimeSec});
    }

    private RtspSessionTiming(long startTimeMs, long stopTimeMs) {
        this.startTimeMs = startTimeMs;
        this.stopTimeMs = stopTimeMs;
    }

    public boolean isLive() {
        return this.stopTimeMs == -9223372036854775807L;
    }

    public long getDurationMs() {
        return this.stopTimeMs - this.startTimeMs;
    }
}

