/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import android.os.Handler;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnknownNull;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.source.BaseMediaSource;
import androidx.media3.exoplayer.source.LoadEventInfo;
import androidx.media3.exoplayer.source.MediaLoadData;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.MediaSourceEventListener;
import java.io.IOException;
import java.util.HashMap;

@UnstableApi
public abstract class CompositeMediaSource<T>
extends BaseMediaSource {
    private final HashMap<T, MediaSourceAndListener<T>> childSources = new HashMap();
    @Nullable
    private Handler eventHandler;
    @Nullable
    private TransferListener mediaTransferListener;

    protected CompositeMediaSource() {
    }

    @Override
    @CallSuper
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.mediaTransferListener = mediaTransferListener;
        this.eventHandler = Util.createHandlerForCurrentLooper();
    }

    @Override
    @CallSuper
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        for (MediaSourceAndListener<T> childSource : this.childSources.values()) {
            childSource.mediaSource.maybeThrowSourceInfoRefreshError();
        }
    }

    @Override
    @CallSuper
    protected void enableInternal() {
        for (MediaSourceAndListener<T> childSource : this.childSources.values()) {
            childSource.mediaSource.enable(childSource.caller);
        }
    }

    @Override
    @CallSuper
    protected void disableInternal() {
        for (MediaSourceAndListener<T> childSource : this.childSources.values()) {
            childSource.mediaSource.disable(childSource.caller);
        }
    }

    @Override
    @CallSuper
    protected void releaseSourceInternal() {
        for (MediaSourceAndListener<T> childSource : this.childSources.values()) {
            childSource.mediaSource.releaseSource(childSource.caller);
            childSource.mediaSource.removeEventListener(childSource.eventListener);
            childSource.mediaSource.removeDrmEventListener(childSource.eventListener);
        }
        this.childSources.clear();
    }

    protected abstract void onChildSourceInfoRefreshed(@UnknownNull T var1, MediaSource var2, Timeline var3);

    protected final void prepareChildSource(@UnknownNull T id, MediaSource mediaSource) {
        Assertions.checkArgument((!this.childSources.containsKey(id) ? 1 : 0) != 0);
        MediaSource.MediaSourceCaller caller = (source, timeline) -> this.onChildSourceInfoRefreshed(id, source, timeline);
        ForwardingEventListener eventListener = new ForwardingEventListener(id);
        this.childSources.put(id, new MediaSourceAndListener(mediaSource, caller, eventListener));
        mediaSource.addEventListener((Handler)Assertions.checkNotNull((Object)this.eventHandler), eventListener);
        mediaSource.addDrmEventListener((Handler)Assertions.checkNotNull((Object)this.eventHandler), eventListener);
        mediaSource.prepareSource(caller, this.mediaTransferListener, this.getPlayerId());
        if (!this.isEnabled()) {
            mediaSource.disable(caller);
        }
    }

    protected final void enableChildSource(@UnknownNull T id) {
        MediaSourceAndListener enabledChild = (MediaSourceAndListener)Assertions.checkNotNull(this.childSources.get(id));
        enabledChild.mediaSource.enable(enabledChild.caller);
    }

    protected final void disableChildSource(@UnknownNull T id) {
        MediaSourceAndListener disabledChild = (MediaSourceAndListener)Assertions.checkNotNull(this.childSources.get(id));
        disabledChild.mediaSource.disable(disabledChild.caller);
    }

    protected final void releaseChildSource(@UnknownNull T id) {
        MediaSourceAndListener removedChild = (MediaSourceAndListener)Assertions.checkNotNull(this.childSources.remove(id));
        removedChild.mediaSource.releaseSource(removedChild.caller);
        removedChild.mediaSource.removeEventListener(removedChild.eventListener);
        removedChild.mediaSource.removeDrmEventListener(removedChild.eventListener);
    }

    protected int getWindowIndexForChildWindowIndex(@UnknownNull T childSourceId, int windowIndex) {
        return windowIndex;
    }

    @Nullable
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(@UnknownNull T childSourceId, MediaSource.MediaPeriodId mediaPeriodId) {
        return mediaPeriodId;
    }

    protected long getMediaTimeForChildMediaTime(@UnknownNull T childSourceId, long mediaTimeMs) {
        return mediaTimeMs;
    }

    private final class ForwardingEventListener
    implements MediaSourceEventListener,
    DrmSessionEventListener {
        @UnknownNull
        private final T id;
        private MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;
        private DrmSessionEventListener.EventDispatcher drmEventDispatcher;

        public ForwardingEventListener(T id) {
            this.mediaSourceEventDispatcher = CompositeMediaSource.this.createEventDispatcher(null);
            this.drmEventDispatcher = CompositeMediaSource.this.createDrmEventDispatcher(null);
            this.id = id;
        }

        @Override
        public void onLoadStarted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventData, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.loadStarted(loadEventData, this.maybeUpdateMediaLoadData(mediaLoadData));
            }
        }

        @Override
        public void onLoadCompleted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventData, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.loadCompleted(loadEventData, this.maybeUpdateMediaLoadData(mediaLoadData));
            }
        }

        @Override
        public void onLoadCanceled(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventData, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.loadCanceled(loadEventData, this.maybeUpdateMediaLoadData(mediaLoadData));
            }
        }

        @Override
        public void onLoadError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventData, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.loadError(loadEventData, this.maybeUpdateMediaLoadData(mediaLoadData), error, wasCanceled);
            }
        }

        @Override
        public void onUpstreamDiscarded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.upstreamDiscarded(this.maybeUpdateMediaLoadData(mediaLoadData));
            }
        }

        @Override
        public void onDownstreamFormatChanged(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.downstreamFormatChanged(this.maybeUpdateMediaLoadData(mediaLoadData));
            }
        }

        @Override
        public void onDrmSessionAcquired(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, int state) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.drmEventDispatcher.drmSessionAcquired(state);
            }
        }

        @Override
        public void onDrmKeysLoaded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.drmEventDispatcher.drmKeysLoaded();
            }
        }

        @Override
        public void onDrmSessionManagerError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, Exception error) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.drmEventDispatcher.drmSessionManagerError(error);
            }
        }

        @Override
        public void onDrmKeysRestored(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.drmEventDispatcher.drmKeysRestored();
            }
        }

        @Override
        public void onDrmKeysRemoved(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.drmEventDispatcher.drmKeysRemoved();
            }
        }

        @Override
        public void onDrmSessionReleased(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.drmEventDispatcher.drmSessionReleased();
            }
        }

        private boolean maybeUpdateEventDispatcher(int childWindowIndex, @Nullable MediaSource.MediaPeriodId childMediaPeriodId) {
            MediaSource.MediaPeriodId mediaPeriodId = null;
            if (childMediaPeriodId != null && (mediaPeriodId = CompositeMediaSource.this.getMediaPeriodIdForChildMediaPeriodId(this.id, childMediaPeriodId)) == null) {
                return false;
            }
            int windowIndex = CompositeMediaSource.this.getWindowIndexForChildWindowIndex(this.id, childWindowIndex);
            if (this.mediaSourceEventDispatcher.windowIndex != windowIndex || !Util.areEqual((Object)((Object)this.mediaSourceEventDispatcher.mediaPeriodId), (Object)((Object)mediaPeriodId))) {
                this.mediaSourceEventDispatcher = CompositeMediaSource.this.createEventDispatcher(windowIndex, mediaPeriodId);
            }
            if (this.drmEventDispatcher.windowIndex != windowIndex || !Util.areEqual((Object)((Object)this.drmEventDispatcher.mediaPeriodId), (Object)((Object)mediaPeriodId))) {
                this.drmEventDispatcher = CompositeMediaSource.this.createDrmEventDispatcher(windowIndex, mediaPeriodId);
            }
            return true;
        }

        private MediaLoadData maybeUpdateMediaLoadData(MediaLoadData mediaLoadData) {
            long mediaStartTimeMs = CompositeMediaSource.this.getMediaTimeForChildMediaTime(this.id, mediaLoadData.mediaStartTimeMs);
            long mediaEndTimeMs = CompositeMediaSource.this.getMediaTimeForChildMediaTime(this.id, mediaLoadData.mediaEndTimeMs);
            if (mediaStartTimeMs == mediaLoadData.mediaStartTimeMs && mediaEndTimeMs == mediaLoadData.mediaEndTimeMs) {
                return mediaLoadData;
            }
            return new MediaLoadData(mediaLoadData.dataType, mediaLoadData.trackType, mediaLoadData.trackFormat, mediaLoadData.trackSelectionReason, mediaLoadData.trackSelectionData, mediaStartTimeMs, mediaEndTimeMs);
        }
    }

    private static final class MediaSourceAndListener<T> {
        public final MediaSource mediaSource;
        public final MediaSource.MediaSourceCaller caller;
        public final ForwardingEventListener eventListener;

        public MediaSourceAndListener(MediaSource mediaSource, MediaSource.MediaSourceCaller caller, ForwardingEventListener eventListener) {
            this.mediaSource = mediaSource;
            this.caller = caller;
            this.eventListener = eventListener;
        }
    }
}

