/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSourceEventListener;
import androidx.media3.exoplayer.source.MediaSourceFactory;
import androidx.media3.exoplayer.upstream.Allocator;
import androidx.media3.exoplayer.upstream.CmcdConfiguration;
import androidx.media3.exoplayer.upstream.LoadErrorHandlingPolicy;
import java.io.IOException;

public interface MediaSource {
    @UnstableApi
    public void addEventListener(Handler var1, MediaSourceEventListener var2);

    @UnstableApi
    public void removeEventListener(MediaSourceEventListener var1);

    @UnstableApi
    public void addDrmEventListener(Handler var1, DrmSessionEventListener var2);

    @UnstableApi
    public void removeDrmEventListener(DrmSessionEventListener var1);

    @UnstableApi
    @Nullable
    default public Timeline getInitialTimeline() {
        return null;
    }

    @UnstableApi
    default public boolean isSingleWindow() {
        return true;
    }

    @UnstableApi
    public MediaItem getMediaItem();

    @Deprecated
    @UnstableApi
    default public void prepareSource(MediaSourceCaller caller, @Nullable TransferListener mediaTransferListener) {
        this.prepareSource(caller, mediaTransferListener, PlayerId.UNSET);
    }

    @UnstableApi
    public void prepareSource(MediaSourceCaller var1, @Nullable TransferListener var2, PlayerId var3);

    @UnstableApi
    public void maybeThrowSourceInfoRefreshError() throws IOException;

    @UnstableApi
    public void enable(MediaSourceCaller var1);

    @UnstableApi
    public MediaPeriod createPeriod(MediaPeriodId var1, Allocator var2, long var3);

    @UnstableApi
    public void releasePeriod(MediaPeriod var1);

    @UnstableApi
    public void disable(MediaSourceCaller var1);

    @UnstableApi
    public void releaseSource(MediaSourceCaller var1);

    @UnstableApi
    public static final class MediaPeriodId
    extends androidx.media3.common.MediaPeriodId {
        public MediaPeriodId(Object periodUid) {
            super(periodUid);
        }

        public MediaPeriodId(Object periodUid, long windowSequenceNumber) {
            super(periodUid, windowSequenceNumber);
        }

        public MediaPeriodId(Object periodUid, long windowSequenceNumber, int nextAdGroupIndex) {
            super(periodUid, windowSequenceNumber, nextAdGroupIndex);
        }

        public MediaPeriodId(Object periodUid, int adGroupIndex, int adIndexInAdGroup, long windowSequenceNumber) {
            super(periodUid, adGroupIndex, adIndexInAdGroup, windowSequenceNumber);
        }

        public MediaPeriodId(androidx.media3.common.MediaPeriodId mediaPeriodId) {
            super(mediaPeriodId);
        }

        public MediaPeriodId copyWithPeriodUid(Object newPeriodUid) {
            return new MediaPeriodId(super.copyWithPeriodUid(newPeriodUid));
        }

        public MediaPeriodId copyWithWindowSequenceNumber(long windowSequenceNumber) {
            return new MediaPeriodId(super.copyWithWindowSequenceNumber(windowSequenceNumber));
        }
    }

    @UnstableApi
    public static interface MediaSourceCaller {
        public void onSourceInfoRefreshed(MediaSource var1, Timeline var2);
    }

    public static interface Factory {
        @UnstableApi
        public static final Factory UNSUPPORTED = MediaSourceFactory.UNSUPPORTED;

        @UnstableApi
        default public Factory setCmcdConfigurationFactory(CmcdConfiguration.Factory cmcdConfigurationFactory) {
            return this;
        }

        @UnstableApi
        public Factory setDrmSessionManagerProvider(DrmSessionManagerProvider var1);

        @UnstableApi
        public Factory setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy var1);

        @UnstableApi
        public int[] getSupportedTypes();

        @UnstableApi
        public MediaSource createMediaSource(MediaItem var1);
    }
}

