/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source.chunk;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.exoplayer.source.chunk.BaseMediaChunkOutput;
import androidx.media3.exoplayer.source.chunk.MediaChunk;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public abstract class BaseMediaChunk
extends MediaChunk {
    public final long clippedStartTimeUs;
    public final long clippedEndTimeUs;
    private @MonotonicNonNull BaseMediaChunkOutput output;
    private int @MonotonicNonNull [] firstSampleIndices;

    public BaseMediaChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, long startTimeUs, long endTimeUs, long clippedStartTimeUs, long clippedEndTimeUs, long chunkIndex) {
        super(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, chunkIndex);
        this.clippedStartTimeUs = clippedStartTimeUs;
        this.clippedEndTimeUs = clippedEndTimeUs;
    }

    public void init(BaseMediaChunkOutput output) {
        this.output = output;
        this.firstSampleIndices = output.getWriteIndices();
    }

    public final int getFirstSampleIndex(int trackIndex) {
        return ((int[])Assertions.checkStateNotNull((Object)this.firstSampleIndices))[trackIndex];
    }

    protected final BaseMediaChunkOutput getOutput() {
        return (BaseMediaChunkOutput)Assertions.checkStateNotNull((Object)this.output);
    }
}

