/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.upstream;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import androidx.media3.exoplayer.upstream.CmcdConfiguration;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@UnstableApi
public final class CmcdLog {
    private final CmcdObject cmcdObject;
    private final CmcdRequest cmcdRequest;
    private final CmcdSession cmcdSession;
    private final CmcdStatus cmcdStatus;

    public static CmcdLog createInstance(CmcdConfiguration cmcdConfiguration, ExoTrackSelection trackSelection, long playbackPositionUs, long loadPositionUs) {
        ImmutableMap<String, String> customData = cmcdConfiguration.requestConfig.getCustomData();
        int bitrateKbps = trackSelection.getSelectedFormat().bitrate / 1000;
        CmcdObject.Builder cmcdObject = new CmcdObject.Builder().setCustomData((String)customData.get((Object)"CMCD-Object"));
        if (cmcdConfiguration.isBitrateLoggingAllowed()) {
            cmcdObject.setBitrateKbps(bitrateKbps);
        }
        CmcdRequest.Builder cmcdRequest = new CmcdRequest.Builder().setCustomData((String)customData.get((Object)"CMCD-Request"));
        if (cmcdConfiguration.isBufferLengthLoggingAllowed()) {
            cmcdRequest.setBufferLengthMs(loadPositionUs == -9223372036854775807L ? 0L : (loadPositionUs - playbackPositionUs) / 1000L);
        }
        CmcdSession.Builder cmcdSession = new CmcdSession.Builder().setCustomData((String)customData.get((Object)"CMCD-Session"));
        if (cmcdConfiguration.isContentIdLoggingAllowed()) {
            cmcdSession.setContentId(cmcdConfiguration.contentId);
        }
        if (cmcdConfiguration.isSessionIdLoggingAllowed()) {
            cmcdSession.setSessionId(cmcdConfiguration.sessionId);
        }
        CmcdStatus.Builder cmcdStatus = new CmcdStatus.Builder().setCustomData((String)customData.get((Object)"CMCD-Status"));
        if (cmcdConfiguration.isMaximumRequestThroughputLoggingAllowed()) {
            cmcdStatus.setMaximumRequestedThroughputKbps(cmcdConfiguration.requestConfig.getRequestedMaximumThroughputKbps(bitrateKbps));
        }
        return new CmcdLog(cmcdObject.build(), cmcdRequest.build(), cmcdSession.build(), cmcdStatus.build());
    }

    private CmcdLog(CmcdObject cmcdObject, CmcdRequest cmcdRequest, CmcdSession cmcdSession, CmcdStatus cmcdStatus) {
        this.cmcdObject = cmcdObject;
        this.cmcdRequest = cmcdRequest;
        this.cmcdSession = cmcdSession;
        this.cmcdStatus = cmcdStatus;
    }

    public ImmutableMap<String, String> getHttpRequestHeaders() {
        ImmutableMap.Builder httpRequestHeaders = ImmutableMap.builder();
        this.cmcdObject.populateHttpRequestHeaders((ImmutableMap.Builder<String, String>)httpRequestHeaders);
        this.cmcdRequest.populateHttpRequestHeaders((ImmutableMap.Builder<String, String>)httpRequestHeaders);
        this.cmcdSession.populateHttpRequestHeaders((ImmutableMap.Builder<String, String>)httpRequestHeaders);
        this.cmcdStatus.populateHttpRequestHeaders((ImmutableMap.Builder<String, String>)httpRequestHeaders);
        return httpRequestHeaders.buildOrThrow();
    }

    private static final class CmcdStatus {
        public final int maximumRequestedThroughputKbps;
        @Nullable
        public final String customData;

        private CmcdStatus(Builder builder) {
            this.maximumRequestedThroughputKbps = builder.maximumRequestedThroughputKbps;
            this.customData = builder.customData;
        }

        public void populateHttpRequestHeaders(ImmutableMap.Builder<String, String> httpRequestHeaders) {
            StringBuilder headerValue = new StringBuilder();
            if (this.maximumRequestedThroughputKbps != -2147483647) {
                headerValue.append(Util.formatInvariant((String)"%s=%d,", (Object[])new Object[]{"rtp", this.maximumRequestedThroughputKbps}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.customData)) {
                headerValue.append(Util.formatInvariant((String)"%s,", (Object[])new Object[]{this.customData}));
            }
            if (headerValue.length() == 0) {
                return;
            }
            headerValue.setLength(headerValue.length() - 1);
            httpRequestHeaders.put((Object)"CMCD-Status", (Object)headerValue.toString());
        }

        public static final class Builder {
            private int maximumRequestedThroughputKbps = -2147483647;
            @Nullable
            private String customData;

            @CanIgnoreReturnValue
            public Builder setMaximumRequestedThroughputKbps(int maximumRequestedThroughputKbps) {
                Assertions.checkArgument((maximumRequestedThroughputKbps == -2147483647 || maximumRequestedThroughputKbps >= 0 ? 1 : 0) != 0);
                this.maximumRequestedThroughputKbps = maximumRequestedThroughputKbps == -2147483647 ? maximumRequestedThroughputKbps : (maximumRequestedThroughputKbps + 50) / 100 * 100;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCustomData(@Nullable String customData) {
                this.customData = customData;
                return this;
            }

            public CmcdStatus build() {
                return new CmcdStatus(this);
            }
        }
    }

    private static final class CmcdSession {
        @Nullable
        public final String contentId;
        @Nullable
        public final String sessionId;
        @Nullable
        public final String customData;

        private CmcdSession(Builder builder) {
            this.contentId = builder.contentId;
            this.sessionId = builder.sessionId;
            this.customData = builder.customData;
        }

        public void populateHttpRequestHeaders(ImmutableMap.Builder<String, String> httpRequestHeaders) {
            StringBuilder headerValue = new StringBuilder();
            if (!TextUtils.isEmpty((CharSequence)this.contentId)) {
                headerValue.append(Util.formatInvariant((String)"%s=\"%s\",", (Object[])new Object[]{"cid", this.contentId}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.sessionId)) {
                headerValue.append(Util.formatInvariant((String)"%s=\"%s\",", (Object[])new Object[]{"sid", this.sessionId}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.customData)) {
                headerValue.append(Util.formatInvariant((String)"%s,", (Object[])new Object[]{this.customData}));
            }
            if (headerValue.length() == 0) {
                return;
            }
            headerValue.setLength(headerValue.length() - 1);
            httpRequestHeaders.put((Object)"CMCD-Session", (Object)headerValue.toString());
        }

        public static final class Builder {
            @Nullable
            private String contentId;
            @Nullable
            private String sessionId;
            @Nullable
            private String customData;

            @CanIgnoreReturnValue
            public Builder setContentId(@Nullable String contentId) {
                Assertions.checkArgument((contentId == null || contentId.length() <= 64 ? 1 : 0) != 0);
                this.contentId = contentId;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setSessionId(@Nullable String sessionId) {
                Assertions.checkArgument((sessionId == null || sessionId.length() <= 64 ? 1 : 0) != 0);
                this.sessionId = sessionId;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCustomData(@Nullable String customData) {
                this.customData = customData;
                return this;
            }

            public CmcdSession build() {
                return new CmcdSession(this);
            }
        }
    }

    private static final class CmcdRequest {
        public final long bufferLengthMs;
        @Nullable
        public final String customData;

        private CmcdRequest(Builder builder) {
            this.bufferLengthMs = builder.bufferLengthMs;
            this.customData = builder.customData;
        }

        public void populateHttpRequestHeaders(ImmutableMap.Builder<String, String> httpRequestHeaders) {
            StringBuilder headerValue = new StringBuilder();
            if (this.bufferLengthMs != -9223372036854775807L) {
                headerValue.append(Util.formatInvariant((String)"%s=%d,", (Object[])new Object[]{"bl", this.bufferLengthMs}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.customData)) {
                headerValue.append(Util.formatInvariant((String)"%s,", (Object[])new Object[]{this.customData}));
            }
            if (headerValue.length() == 0) {
                return;
            }
            headerValue.setLength(headerValue.length() - 1);
            httpRequestHeaders.put((Object)"CMCD-Request", (Object)headerValue.toString());
        }

        public static final class Builder {
            private long bufferLengthMs = -9223372036854775807L;
            @Nullable
            private String customData;

            @CanIgnoreReturnValue
            public Builder setBufferLengthMs(long bufferLengthMs) {
                Assertions.checkArgument((bufferLengthMs == -9223372036854775807L || bufferLengthMs >= 0L ? 1 : 0) != 0);
                this.bufferLengthMs = bufferLengthMs == -9223372036854775807L ? bufferLengthMs : (bufferLengthMs + 50L) / 100L * 100L;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCustomData(@Nullable String customData) {
                this.customData = customData;
                return this;
            }

            public CmcdRequest build() {
                return new CmcdRequest(this);
            }
        }
    }

    private static final class CmcdObject {
        public final int bitrateKbps;
        @Nullable
        public final String customData;

        private CmcdObject(Builder builder) {
            this.bitrateKbps = builder.bitrateKbps;
            this.customData = builder.customData;
        }

        public void populateHttpRequestHeaders(ImmutableMap.Builder<String, String> httpRequestHeaders) {
            StringBuilder headerValue = new StringBuilder();
            if (this.bitrateKbps != -2147483647) {
                headerValue.append(Util.formatInvariant((String)"%s=%d,", (Object[])new Object[]{"br", this.bitrateKbps}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.customData)) {
                headerValue.append(Util.formatInvariant((String)"%s,", (Object[])new Object[]{this.customData}));
            }
            if (headerValue.length() == 0) {
                return;
            }
            headerValue.setLength(headerValue.length() - 1);
            httpRequestHeaders.put((Object)"CMCD-Object", (Object)headerValue.toString());
        }

        public static final class Builder {
            private int bitrateKbps = -2147483647;
            @Nullable
            private String customData;

            @CanIgnoreReturnValue
            public Builder setBitrateKbps(int bitrateKbps) {
                this.bitrateKbps = bitrateKbps;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCustomData(@Nullable String customData) {
                this.customData = customData;
                return this;
            }

            public CmcdObject build() {
                return new CmcdObject(this);
            }
        }
    }
}

