/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.video.spherical;

import android.graphics.SurfaceTexture;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.TimedValueQueue;
import androidx.media3.exoplayer.video.VideoFrameMetadataListener;
import androidx.media3.exoplayer.video.spherical.CameraMotionListener;
import androidx.media3.exoplayer.video.spherical.FrameRotationQueue;
import androidx.media3.exoplayer.video.spherical.Projection;
import androidx.media3.exoplayer.video.spherical.ProjectionDecoder;
import androidx.media3.exoplayer.video.spherical.ProjectionRenderer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class SceneRenderer
implements VideoFrameMetadataListener,
CameraMotionListener {
    private static final String TAG = "SceneRenderer";
    private final AtomicBoolean frameAvailable = new AtomicBoolean();
    private final AtomicBoolean resetRotationAtNextFrame = new AtomicBoolean(true);
    private final ProjectionRenderer projectionRenderer = new ProjectionRenderer();
    private final FrameRotationQueue frameRotationQueue = new FrameRotationQueue();
    private final TimedValueQueue<Long> sampleTimestampQueue = new TimedValueQueue();
    private final TimedValueQueue<Projection> projectionQueue = new TimedValueQueue();
    private final float[] rotationMatrix = new float[16];
    private final float[] tempMatrix = new float[16];
    private int textureId;
    private @MonotonicNonNull SurfaceTexture surfaceTexture;
    private volatile int defaultStereoMode = 0;
    private int lastStereoMode = -1;
    @Nullable
    private byte[] lastProjectionData;

    public void setDefaultStereoMode(int stereoMode) {
        this.defaultStereoMode = stereoMode;
    }

    public SurfaceTexture init() {
        try {
            GLES20.glClearColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            GlUtil.checkGlError();
            this.projectionRenderer.init();
            GlUtil.checkGlError();
            this.textureId = GlUtil.createExternalTexture();
        }
        catch (GlUtil.GlException e) {
            Log.e((String)TAG, (String)"Failed to initialize the renderer", (Throwable)e);
        }
        this.surfaceTexture = new SurfaceTexture(this.textureId);
        this.surfaceTexture.setOnFrameAvailableListener(surfaceTexture -> this.frameAvailable.set(true));
        return this.surfaceTexture;
    }

    public void drawFrame(float[] viewProjectionMatrix, boolean rightEye) {
        GLES20.glClear((int)16384);
        try {
            GlUtil.checkGlError();
        }
        catch (GlUtil.GlException e) {
            Log.e((String)TAG, (String)"Failed to draw a frame", (Throwable)e);
        }
        if (this.frameAvailable.compareAndSet(true, false)) {
            Projection projection;
            long lastFrameTimestampNs;
            Long sampleTimestampUs;
            ((SurfaceTexture)Assertions.checkNotNull((Object)this.surfaceTexture)).updateTexImage();
            try {
                GlUtil.checkGlError();
            }
            catch (GlUtil.GlException e) {
                Log.e((String)TAG, (String)"Failed to draw a frame", (Throwable)e);
            }
            if (this.resetRotationAtNextFrame.compareAndSet(true, false)) {
                GlUtil.setToIdentity((float[])this.rotationMatrix);
            }
            if ((sampleTimestampUs = (Long)this.sampleTimestampQueue.poll(lastFrameTimestampNs = this.surfaceTexture.getTimestamp())) != null) {
                this.frameRotationQueue.pollRotationMatrix(this.rotationMatrix, sampleTimestampUs);
            }
            if ((projection = (Projection)this.projectionQueue.pollFloor(lastFrameTimestampNs)) != null) {
                this.projectionRenderer.setProjection(projection);
            }
        }
        Matrix.multiplyMM((float[])this.tempMatrix, (int)0, (float[])viewProjectionMatrix, (int)0, (float[])this.rotationMatrix, (int)0);
        this.projectionRenderer.draw(this.textureId, this.tempMatrix, rightEye);
    }

    public void shutdown() {
        this.projectionRenderer.shutdown();
    }

    @Override
    public void onVideoFrameAboutToBeRendered(long presentationTimeUs, long releaseTimeNs, Format format, @Nullable MediaFormat mediaFormat) {
        this.sampleTimestampQueue.add(releaseTimeNs, (Object)presentationTimeUs);
        this.setProjection(format.projectionData, format.stereoMode, releaseTimeNs);
    }

    @Override
    public void onCameraMotion(long timeUs, float[] rotation) {
        this.frameRotationQueue.setRotation(timeUs, rotation);
    }

    @Override
    public void onCameraMotionReset() {
        this.sampleTimestampQueue.clear();
        this.frameRotationQueue.reset();
        this.resetRotationAtNextFrame.set(true);
    }

    private void setProjection(@Nullable byte[] projectionData, int stereoMode, long timeNs) {
        byte[] oldProjectionData = this.lastProjectionData;
        int oldStereoMode = this.lastStereoMode;
        this.lastProjectionData = projectionData;
        int n = this.lastStereoMode = stereoMode == -1 ? this.defaultStereoMode : stereoMode;
        if (oldStereoMode == this.lastStereoMode && Arrays.equals(oldProjectionData, this.lastProjectionData)) {
            return;
        }
        Projection projectionFromData = null;
        if (this.lastProjectionData != null) {
            projectionFromData = ProjectionDecoder.decode(this.lastProjectionData, this.lastStereoMode);
        }
        Projection projection = projectionFromData != null && ProjectionRenderer.isSupported(projectionFromData) ? projectionFromData : Projection.createEquirectangular(this.lastStereoMode);
        this.projectionQueue.add(timeNs, (Object)projection);
    }
}

