/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp;

import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.rtsp.RtpDataChannel;
import androidx.media3.exoplayer.rtsp.RtpUtils;
import androidx.media3.exoplayer.rtsp.TransferRtpDataChannel;

@UnstableApi
final class TransferRtpDataChannelFactory
implements RtpDataChannel.Factory {
    private static final int INTERLEAVED_CHANNELS_PER_TRACK = 2;
    private final long timeoutMs;

    public TransferRtpDataChannelFactory(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    @Override
    public RtpDataChannel createAndOpenDataChannel(int trackId) {
        TransferRtpDataChannel dataChannel = new TransferRtpDataChannel(this.timeoutMs);
        dataChannel.open(RtpUtils.getIncomingRtpDataSpec(trackId * 2));
        return dataChannel;
    }
}

