/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.util;

import android.os.SystemClock;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.upstream.Loader;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.ConcurrentModificationException;

@UnstableApi
public final class SntpClient {
    public static final String DEFAULT_NTP_HOST = "time.android.com";
    private static final int TIMEOUT_MS = 10000;
    private static final int ORIGINATE_TIME_OFFSET = 24;
    private static final int RECEIVE_TIME_OFFSET = 32;
    private static final int TRANSMIT_TIME_OFFSET = 40;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int NTP_PORT = 123;
    private static final int NTP_MODE_CLIENT = 3;
    private static final int NTP_MODE_SERVER = 4;
    private static final int NTP_MODE_BROADCAST = 5;
    private static final int NTP_VERSION = 3;
    private static final int NTP_LEAP_NOSYNC = 3;
    private static final int NTP_STRATUM_DEATH = 0;
    private static final int NTP_STRATUM_MAX = 15;
    private static final long OFFSET_1900_TO_1970 = 2208988800L;
    private static final Object loaderLock = new Object();
    private static final Object valueLock = new Object();
    @GuardedBy(value="valueLock")
    private static boolean isInitialized;
    @GuardedBy(value="valueLock")
    private static long elapsedRealtimeOffsetMs;
    @GuardedBy(value="valueLock")
    private static String ntpHost;

    private SntpClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNtpHost() {
        Object object = valueLock;
        synchronized (object) {
            return ntpHost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNtpHost(String ntpHost) {
        Object object = valueLock;
        synchronized (object) {
            if (!SntpClient.ntpHost.equals(ntpHost)) {
                SntpClient.ntpHost = ntpHost;
                isInitialized = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Object object = valueLock;
        synchronized (object) {
            return isInitialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getElapsedRealtimeOffsetMs() {
        Object object = valueLock;
        synchronized (object) {
            return isInitialized ? elapsedRealtimeOffsetMs : -9223372036854775807L;
        }
    }

    public static void initialize(@Nullable Loader loader, @Nullable InitializationCallback callback) {
        if (SntpClient.isInitialized()) {
            if (callback != null) {
                callback.onInitialized();
            }
            return;
        }
        if (loader == null) {
            loader = new Loader("SntpClient");
        }
        loader.startLoading(new NtpTimeLoadable(), new NtpTimeCallback(callback), 1);
    }

    private static long loadNtpTimeOffsetMs() throws IOException {
        InetAddress address = InetAddress.getByName(SntpClient.getNtpHost());
        try (DatagramSocket socket = new DatagramSocket();){
            socket.setSoTimeout(10000);
            byte[] buffer = new byte[48];
            DatagramPacket request = new DatagramPacket(buffer, buffer.length, address, 123);
            buffer[0] = 27;
            long requestTime = System.currentTimeMillis();
            long requestTicks = SystemClock.elapsedRealtime();
            SntpClient.writeTimestamp(buffer, 40, requestTime);
            socket.send(request);
            DatagramPacket response = new DatagramPacket(buffer, buffer.length);
            socket.receive(response);
            long responseTicks = SystemClock.elapsedRealtime();
            long responseTime = requestTime + (responseTicks - requestTicks);
            byte leap = (byte)(buffer[0] >> 6 & 3);
            byte mode = (byte)(buffer[0] & 7);
            int stratum = buffer[1] & 0xFF;
            long originateTime = SntpClient.readTimestamp(buffer, 24);
            long receiveTime = SntpClient.readTimestamp(buffer, 32);
            long transmitTime = SntpClient.readTimestamp(buffer, 40);
            SntpClient.checkValidServerReply(leap, mode, stratum, transmitTime);
            long clockOffset = (receiveTime - originateTime + (transmitTime - responseTime)) / 2L;
            long ntpTime = responseTime + clockOffset;
            long ntpTimeReference = responseTicks;
            long l = ntpTime - ntpTimeReference;
            return l;
        }
    }

    private static long readTimestamp(byte[] buffer, int offset) {
        long seconds = SntpClient.read32(buffer, offset);
        long fraction = SntpClient.read32(buffer, offset + 4);
        if (seconds == 0L && fraction == 0L) {
            return 0L;
        }
        return (seconds - 2208988800L) * 1000L + fraction * 1000L / 0x100000000L;
    }

    private static void writeTimestamp(byte[] buffer, int offset, long time) {
        if (time == 0L) {
            Arrays.fill(buffer, offset, offset + 8, (byte)0);
            return;
        }
        long seconds = time / 1000L;
        long milliseconds = time - seconds * 1000L;
        buffer[offset++] = (byte)((seconds += 2208988800L) >> 24);
        buffer[offset++] = (byte)(seconds >> 16);
        buffer[offset++] = (byte)(seconds >> 8);
        buffer[offset++] = (byte)(seconds >> 0);
        long fraction = milliseconds * 0x100000000L / 1000L;
        buffer[offset++] = (byte)(fraction >> 24);
        buffer[offset++] = (byte)(fraction >> 16);
        buffer[offset++] = (byte)(fraction >> 8);
        buffer[offset++] = (byte)(Math.random() * 255.0);
    }

    private static long read32(byte[] buffer, int offset) {
        int b0 = buffer[offset];
        int b1 = buffer[offset + 1];
        int b2 = buffer[offset + 2];
        int b3 = buffer[offset + 3];
        int i0 = (b0 & 0x80) == 128 ? (b0 & 0x7F) + 128 : b0;
        int i1 = (b1 & 0x80) == 128 ? (b1 & 0x7F) + 128 : b1;
        int i2 = (b2 & 0x80) == 128 ? (b2 & 0x7F) + 128 : b2;
        int i3 = (b3 & 0x80) == 128 ? (b3 & 0x7F) + 128 : b3;
        return ((long)i0 << 24) + ((long)i1 << 16) + ((long)i2 << 8) + (long)i3;
    }

    private static void checkValidServerReply(byte leap, byte mode, int stratum, long transmitTime) throws IOException {
        if (leap == 3) {
            throw new IOException("SNTP: Unsynchronized server");
        }
        if (mode != 4 && mode != 5) {
            throw new IOException("SNTP: Untrusted mode: " + mode);
        }
        if (stratum == 0 || stratum > 15) {
            throw new IOException("SNTP: Untrusted stratum: " + stratum);
        }
        if (transmitTime == 0L) {
            throw new IOException("SNTP: Zero transmitTime");
        }
    }

    static {
        ntpHost = DEFAULT_NTP_HOST;
    }

    private static final class NtpTimeCallback
    implements Loader.Callback<Loader.Loadable> {
        @Nullable
        private final InitializationCallback callback;

        public NtpTimeCallback(@Nullable InitializationCallback callback) {
            this.callback = callback;
        }

        @Override
        public void onLoadCompleted(Loader.Loadable loadable, long elapsedRealtimeMs, long loadDurationMs) {
            if (this.callback != null) {
                if (!SntpClient.isInitialized()) {
                    this.callback.onInitializationFailed(new IOException(new ConcurrentModificationException()));
                } else {
                    this.callback.onInitialized();
                }
            }
        }

        @Override
        public void onLoadCanceled(Loader.Loadable loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        }

        @Override
        public Loader.LoadErrorAction onLoadError(Loader.Loadable loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
            if (this.callback != null) {
                this.callback.onInitializationFailed(error);
            }
            return Loader.DONT_RETRY;
        }
    }

    private static final class NtpTimeLoadable
    implements Loader.Loadable {
        private NtpTimeLoadable() {
        }

        @Override
        public void cancelLoad() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load() throws IOException {
            Object object = loaderLock;
            synchronized (object) {
                Object object2 = valueLock;
                synchronized (object2) {
                    if (isInitialized) {
                        return;
                    }
                }
                long offsetMs = SntpClient.loadNtpTimeOffsetMs();
                Object object3 = valueLock;
                synchronized (object3) {
                    elapsedRealtimeOffsetMs = offsetMs;
                    isInitialized = true;
                }
            }
        }
    }

    public static interface InitializationCallback {
        public void onInitialized();

        public void onInitializationFailed(IOException var1);
    }
}

