/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.video.spherical;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.SurfaceTexture;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.Display;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.AnyThread;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.video.VideoFrameMetadataListener;
import androidx.media3.exoplayer.video.spherical.CameraMotionListener;
import androidx.media3.exoplayer.video.spherical.OrientationListener;
import androidx.media3.exoplayer.video.spherical.SceneRenderer;
import androidx.media3.exoplayer.video.spherical.TouchTracker;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

@UnstableApi
public final class SphericalGLSurfaceView
extends GLSurfaceView {
    private static final int FIELD_OF_VIEW_DEGREES = 90;
    private static final float Z_NEAR = 0.1f;
    private static final float Z_FAR = 100.0f;
    private static final float PX_PER_DEGREES = 25.0f;
    static final float UPRIGHT_ROLL = (float)Math.PI;
    private final CopyOnWriteArrayList<VideoSurfaceListener> videoSurfaceListeners = new CopyOnWriteArrayList();
    private final SensorManager sensorManager;
    @Nullable
    private final Sensor orientationSensor;
    private final OrientationListener orientationListener;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private final TouchTracker touchTracker;
    private final SceneRenderer scene;
    @Nullable
    private SurfaceTexture surfaceTexture;
    @Nullable
    private Surface surface;
    private boolean useSensorRotation;
    private boolean isStarted;
    private boolean isOrientationListenerRegistered;

    public SphericalGLSurfaceView(Context context) {
        this(context, null);
    }

    public SphericalGLSurfaceView(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.sensorManager = (SensorManager)Assertions.checkNotNull((Object)context.getSystemService("sensor"));
        Sensor orientationSensor = null;
        if (Util.SDK_INT >= 18) {
            orientationSensor = this.sensorManager.getDefaultSensor(15);
        }
        if (orientationSensor == null) {
            orientationSensor = this.sensorManager.getDefaultSensor(11);
        }
        this.orientationSensor = orientationSensor;
        this.scene = new SceneRenderer();
        Renderer renderer = new Renderer(this.scene);
        this.touchTracker = new TouchTracker(context, renderer, 25.0f);
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = ((WindowManager)Assertions.checkNotNull((Object)windowManager)).getDefaultDisplay();
        this.orientationListener = new OrientationListener(display, this.touchTracker, renderer);
        this.useSensorRotation = true;
        this.setEGLContextClientVersion(2);
        this.setRenderer(renderer);
        this.setOnTouchListener(this.touchTracker);
    }

    public void addVideoSurfaceListener(VideoSurfaceListener listener) {
        this.videoSurfaceListeners.add(listener);
    }

    public void removeVideoSurfaceListener(VideoSurfaceListener listener) {
        this.videoSurfaceListeners.remove(listener);
    }

    @Nullable
    public Surface getVideoSurface() {
        return this.surface;
    }

    public VideoFrameMetadataListener getVideoFrameMetadataListener() {
        return this.scene;
    }

    public CameraMotionListener getCameraMotionListener() {
        return this.scene;
    }

    public void setDefaultStereoMode(int stereoMode) {
        this.scene.setDefaultStereoMode(stereoMode);
    }

    public void setUseSensorRotation(boolean useSensorRotation) {
        this.useSensorRotation = useSensorRotation;
        this.updateOrientationListenerRegistration();
    }

    public void onResume() {
        super.onResume();
        this.isStarted = true;
        this.updateOrientationListenerRegistration();
    }

    public void onPause() {
        this.isStarted = false;
        this.updateOrientationListenerRegistration();
        super.onPause();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mainHandler.post(() -> {
            Surface oldSurface = this.surface;
            if (oldSurface != null) {
                for (VideoSurfaceListener videoSurfaceListener : this.videoSurfaceListeners) {
                    videoSurfaceListener.onVideoSurfaceDestroyed(oldSurface);
                }
            }
            SphericalGLSurfaceView.releaseSurface(this.surfaceTexture, oldSurface);
            this.surfaceTexture = null;
            this.surface = null;
        });
    }

    private void updateOrientationListenerRegistration() {
        boolean enabled;
        boolean bl = enabled = this.useSensorRotation && this.isStarted;
        if (this.orientationSensor == null || enabled == this.isOrientationListenerRegistered) {
            return;
        }
        if (enabled) {
            this.sensorManager.registerListener((SensorEventListener)this.orientationListener, this.orientationSensor, 0);
        } else {
            this.sensorManager.unregisterListener((SensorEventListener)this.orientationListener);
        }
        this.isOrientationListenerRegistered = enabled;
    }

    private void onSurfaceTextureAvailable(SurfaceTexture newSurfaceTexture) {
        this.mainHandler.post(() -> {
            SurfaceTexture oldSurfaceTexture = this.surfaceTexture;
            Surface oldSurface = this.surface;
            Surface newSurface = new Surface(newSurfaceTexture);
            this.surfaceTexture = newSurfaceTexture;
            this.surface = newSurface;
            for (VideoSurfaceListener videoSurfaceListener : this.videoSurfaceListeners) {
                videoSurfaceListener.onVideoSurfaceCreated(newSurface);
            }
            SphericalGLSurfaceView.releaseSurface(oldSurfaceTexture, oldSurface);
        });
    }

    private static void releaseSurface(@Nullable SurfaceTexture oldSurfaceTexture, @Nullable Surface oldSurface) {
        if (oldSurfaceTexture != null) {
            oldSurfaceTexture.release();
        }
        if (oldSurface != null) {
            oldSurface.release();
        }
    }

    @VisibleForTesting
    final class Renderer
    implements GLSurfaceView.Renderer,
    TouchTracker.Listener,
    OrientationListener.Listener {
        private final SceneRenderer scene;
        private final float[] projectionMatrix = new float[16];
        private final float[] viewProjectionMatrix = new float[16];
        private final float[] deviceOrientationMatrix = new float[16];
        private final float[] touchPitchMatrix = new float[16];
        private final float[] touchYawMatrix = new float[16];
        private float touchPitch;
        private float deviceRoll;
        private final float[] viewMatrix = new float[16];
        private final float[] tempMatrix = new float[16];

        public Renderer(SceneRenderer scene) {
            this.scene = scene;
            GlUtil.setToIdentity((float[])this.deviceOrientationMatrix);
            GlUtil.setToIdentity((float[])this.touchPitchMatrix);
            GlUtil.setToIdentity((float[])this.touchYawMatrix);
            this.deviceRoll = (float)Math.PI;
        }

        public synchronized void onSurfaceCreated(GL10 gl, EGLConfig config) {
            SphericalGLSurfaceView.this.onSurfaceTextureAvailable(this.scene.init());
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
            float aspect = (float)width / (float)height;
            float fovY = this.calculateFieldOfViewInYDirection(aspect);
            Matrix.perspectiveM((float[])this.projectionMatrix, (int)0, (float)fovY, (float)aspect, (float)0.1f, (float)100.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDrawFrame(GL10 gl) {
            Renderer renderer = this;
            synchronized (renderer) {
                Matrix.multiplyMM((float[])this.tempMatrix, (int)0, (float[])this.deviceOrientationMatrix, (int)0, (float[])this.touchYawMatrix, (int)0);
                Matrix.multiplyMM((float[])this.viewMatrix, (int)0, (float[])this.touchPitchMatrix, (int)0, (float[])this.tempMatrix, (int)0);
            }
            Matrix.multiplyMM((float[])this.viewProjectionMatrix, (int)0, (float[])this.projectionMatrix, (int)0, (float[])this.viewMatrix, (int)0);
            this.scene.drawFrame(this.viewProjectionMatrix, false);
        }

        @Override
        @BinderThread
        public synchronized void onOrientationChange(float[] matrix, float deviceRoll) {
            System.arraycopy(matrix, 0, this.deviceOrientationMatrix, 0, this.deviceOrientationMatrix.length);
            this.deviceRoll = -deviceRoll;
            this.updatePitchMatrix();
        }

        @AnyThread
        private void updatePitchMatrix() {
            Matrix.setRotateM((float[])this.touchPitchMatrix, (int)0, (float)(-this.touchPitch), (float)((float)Math.cos(this.deviceRoll)), (float)((float)Math.sin(this.deviceRoll)), (float)0.0f);
        }

        @Override
        @UiThread
        public synchronized void onScrollChange(PointF scrollOffsetDegrees) {
            this.touchPitch = scrollOffsetDegrees.y;
            this.updatePitchMatrix();
            Matrix.setRotateM((float[])this.touchYawMatrix, (int)0, (float)(-scrollOffsetDegrees.x), (float)0.0f, (float)1.0f, (float)0.0f);
        }

        @Override
        @UiThread
        public boolean onSingleTapUp(MotionEvent event) {
            return SphericalGLSurfaceView.this.performClick();
        }

        private float calculateFieldOfViewInYDirection(float aspect) {
            boolean landscapeMode;
            boolean bl = landscapeMode = aspect > 1.0f;
            if (landscapeMode) {
                double halfFovX = 45.0;
                double tanY = Math.tan(Math.toRadians(halfFovX)) / (double)aspect;
                double halfFovY = Math.toDegrees(Math.atan(tanY));
                return (float)(halfFovY * 2.0);
            }
            return 90.0f;
        }
    }

    public static interface VideoSurfaceListener {
        public void onVideoSurfaceCreated(Surface var1);

        public void onVideoSurfaceDestroyed(Surface var1);
    }
}

