/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.wav;

import androidx.media3.common.util.Util;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.SeekPoint;
import androidx.media3.extractor.wav.WavFormat;

final class WavSeekMap
implements SeekMap {
    private final WavFormat wavFormat;
    private final int framesPerBlock;
    private final long firstBlockPosition;
    private final long blockCount;
    private final long durationUs;

    public WavSeekMap(WavFormat wavFormat, int framesPerBlock, long dataStartPosition, long dataEndPosition) {
        this.wavFormat = wavFormat;
        this.framesPerBlock = framesPerBlock;
        this.firstBlockPosition = dataStartPosition;
        this.blockCount = (dataEndPosition - dataStartPosition) / (long)wavFormat.blockSize;
        this.durationUs = this.blockIndexToTimeUs(this.blockCount);
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        long blockIndex = timeUs * (long)this.wavFormat.frameRateHz / (1000000L * (long)this.framesPerBlock);
        blockIndex = Util.constrainValue((long)blockIndex, (long)0L, (long)(this.blockCount - 1L));
        long seekPosition = this.firstBlockPosition + blockIndex * (long)this.wavFormat.blockSize;
        long seekTimeUs = this.blockIndexToTimeUs(blockIndex);
        SeekPoint seekPoint = new SeekPoint(seekTimeUs, seekPosition);
        if (seekTimeUs >= timeUs || blockIndex == this.blockCount - 1L) {
            return new SeekMap.SeekPoints(seekPoint);
        }
        long secondBlockIndex = blockIndex + 1L;
        long secondSeekPosition = this.firstBlockPosition + secondBlockIndex * (long)this.wavFormat.blockSize;
        long secondSeekTimeUs = this.blockIndexToTimeUs(secondBlockIndex);
        SeekPoint secondSeekPoint = new SeekPoint(secondSeekTimeUs, secondSeekPosition);
        return new SeekMap.SeekPoints(seekPoint, secondSeekPoint);
    }

    private long blockIndexToTimeUs(long blockIndex) {
        return Util.scaleLargeTimestamp((long)(blockIndex * (long)this.framesPerBlock), (long)1000000L, (long)this.wavFormat.frameRateHz);
    }
}

