/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.util.SparseBooleanArray;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@UnstableApi
public final class FlagSet {
    private final SparseBooleanArray flags;

    private FlagSet(SparseBooleanArray flags) {
        this.flags = flags;
    }

    public boolean contains(int flag) {
        return this.flags.get(flag);
    }

    public boolean containsAny(int ... flags) {
        for (int flag : flags) {
            if (!this.contains(flag)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.flags.size();
    }

    public int get(int index) {
        Assertions.checkIndex(index, 0, this.size());
        return this.flags.keyAt(index);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlagSet)) {
            return false;
        }
        FlagSet that = (FlagSet)o;
        if (Util.SDK_INT < 24) {
            if (this.size() != that.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == that.get(i)) continue;
                return false;
            }
            return true;
        }
        return this.flags.equals((Object)that.flags);
    }

    public int hashCode() {
        if (Util.SDK_INT < 24) {
            int hashCode = this.size();
            for (int i = 0; i < this.size(); ++i) {
                hashCode = 31 * hashCode + this.get(i);
            }
            return hashCode;
        }
        return this.flags.hashCode();
    }

    public static final class Builder {
        private final SparseBooleanArray flags = new SparseBooleanArray();
        private boolean buildCalled;

        @CanIgnoreReturnValue
        public Builder add(int flag) {
            Assertions.checkState(!this.buildCalled);
            this.flags.append(flag, true);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addIf(int flag, boolean condition) {
            if (condition) {
                return this.add(flag);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(int ... flags) {
            for (int flag : flags) {
                this.add(flag);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(FlagSet flags) {
            for (int i = 0; i < flags.size(); ++i) {
                this.add(flags.get(i));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder remove(int flag) {
            Assertions.checkState(!this.buildCalled);
            this.flags.delete(flag);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder removeIf(int flag, boolean condition) {
            if (condition) {
                return this.remove(flag);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder removeAll(int ... flags) {
            for (int flag : flags) {
                this.remove(flag);
            }
            return this;
        }

        public FlagSet build() {
            Assertions.checkState(!this.buildCalled);
            this.buildCalled = true;
            return new FlagSet(this.flags);
        }
    }
}

