/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.audio;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.net.Uri;
import android.provider.Settings;
import android.util.Pair;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;

@UnstableApi
public final class AudioCapabilities {
    private static final int DEFAULT_MAX_CHANNEL_COUNT = 10;
    @VisibleForTesting
    static final int DEFAULT_SAMPLE_RATE_HZ = 48000;
    public static final AudioCapabilities DEFAULT_AUDIO_CAPABILITIES = new AudioCapabilities(new int[]{2}, 10);
    private static final ImmutableList<Integer> EXTERNAL_SURROUND_SOUND_ENCODINGS = ImmutableList.of((Object)2, (Object)5, (Object)6);
    private static final ImmutableMap<Integer, Integer> ALL_SURROUND_ENCODINGS_AND_MAX_CHANNELS = new ImmutableMap.Builder().put((Object)5, (Object)6).put((Object)17, (Object)6).put((Object)7, (Object)6).put((Object)30, (Object)10).put((Object)18, (Object)6).put((Object)6, (Object)8).put((Object)8, (Object)8).put((Object)14, (Object)8).buildOrThrow();
    private static final String EXTERNAL_SURROUND_SOUND_KEY = "external_surround_sound_enabled";
    private final int[] supportedEncodings;
    private final int maxChannelCount;

    public static AudioCapabilities getCapabilities(Context context) {
        Intent intent = context.registerReceiver(null, new IntentFilter("android.media.action.HDMI_AUDIO_PLUG"));
        return AudioCapabilities.getCapabilities(context, intent);
    }

    @SuppressLint(value={"InlinedApi"})
    static AudioCapabilities getCapabilities(Context context, @Nullable Intent intent) {
        if (Util.SDK_INT >= 23 && Api23.isBluetoothConnected(context)) {
            return DEFAULT_AUDIO_CAPABILITIES;
        }
        ImmutableSet.Builder supportedEncodings = new ImmutableSet.Builder();
        if (AudioCapabilities.deviceMaySetExternalSurroundSoundGlobalSetting() && Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)EXTERNAL_SURROUND_SOUND_KEY, (int)0) == 1) {
            supportedEncodings.addAll(EXTERNAL_SURROUND_SOUND_ENCODINGS);
        }
        if (Util.SDK_INT >= 29 && (Util.isTv((Context)context) || Util.isAutomotive((Context)context))) {
            supportedEncodings.addAll(Api29.getDirectPlaybackSupportedEncodings());
            return new AudioCapabilities(Ints.toArray((Collection)supportedEncodings.build()), 10);
        }
        if (intent != null && intent.getIntExtra("android.media.extra.AUDIO_PLUG_STATE", 0) == 1) {
            int[] encodingsFromExtra = intent.getIntArrayExtra("android.media.extra.ENCODINGS");
            if (encodingsFromExtra != null) {
                supportedEncodings.addAll((Iterable)Ints.asList((int[])encodingsFromExtra));
            }
            return new AudioCapabilities(Ints.toArray((Collection)supportedEncodings.build()), intent.getIntExtra("android.media.extra.MAX_CHANNEL_COUNT", 10));
        }
        ImmutableSet supportedEncodingsSet = supportedEncodings.build();
        if (!supportedEncodingsSet.isEmpty()) {
            return new AudioCapabilities(Ints.toArray((Collection)supportedEncodingsSet), 10);
        }
        return DEFAULT_AUDIO_CAPABILITIES;
    }

    @Nullable
    static Uri getExternalSurroundSoundGlobalSettingUri() {
        return AudioCapabilities.deviceMaySetExternalSurroundSoundGlobalSetting() ? Settings.Global.getUriFor((String)EXTERNAL_SURROUND_SOUND_KEY) : null;
    }

    public AudioCapabilities(@Nullable int[] supportedEncodings, int maxChannelCount) {
        if (supportedEncodings != null) {
            this.supportedEncodings = Arrays.copyOf(supportedEncodings, supportedEncodings.length);
            Arrays.sort(this.supportedEncodings);
        } else {
            this.supportedEncodings = new int[0];
        }
        this.maxChannelCount = maxChannelCount;
    }

    public boolean supportsEncoding(int encoding) {
        return Arrays.binarySearch(this.supportedEncodings, encoding) >= 0;
    }

    public int getMaxChannelCount() {
        return this.maxChannelCount;
    }

    public boolean isPassthroughPlaybackSupported(Format format) {
        return this.getEncodingAndChannelConfigForPassthrough(format) != null;
    }

    @Nullable
    public Pair<Integer, Integer> getEncodingAndChannelConfigForPassthrough(Format format) {
        int channelCount;
        int encoding = MimeTypes.getEncoding((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (String)format.codecs);
        if (!ALL_SURROUND_ENCODINGS_AND_MAX_CHANNELS.containsKey((Object)encoding)) {
            return null;
        }
        if (encoding == 18 && !this.supportsEncoding(18)) {
            encoding = 6;
        } else if (encoding == 8 && !this.supportsEncoding(8) || encoding == 30 && !this.supportsEncoding(30)) {
            encoding = 7;
        }
        if (!this.supportsEncoding(encoding)) {
            return null;
        }
        if (format.channelCount == -1 || encoding == 18) {
            int sampleRate = format.sampleRate != -1 ? format.sampleRate : 48000;
            channelCount = AudioCapabilities.getMaxSupportedChannelCountForPassthrough(encoding, sampleRate);
        } else {
            channelCount = format.channelCount;
            if (format.sampleMimeType.equals("audio/vnd.dts.uhd;profile=p2") ? channelCount > 10 : channelCount > this.maxChannelCount) {
                return null;
            }
        }
        int channelConfig = AudioCapabilities.getChannelConfigForPassthrough(channelCount);
        if (channelConfig == 0) {
            return null;
        }
        return Pair.create((Object)encoding, (Object)channelConfig);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AudioCapabilities)) {
            return false;
        }
        AudioCapabilities audioCapabilities = (AudioCapabilities)other;
        return Arrays.equals(this.supportedEncodings, audioCapabilities.supportedEncodings) && this.maxChannelCount == audioCapabilities.maxChannelCount;
    }

    public int hashCode() {
        return this.maxChannelCount + 31 * Arrays.hashCode(this.supportedEncodings);
    }

    public String toString() {
        return "AudioCapabilities[maxChannelCount=" + this.maxChannelCount + ", supportedEncodings=" + Arrays.toString(this.supportedEncodings) + "]";
    }

    private static boolean deviceMaySetExternalSurroundSoundGlobalSetting() {
        return Util.SDK_INT >= 17 && ("Amazon".equals(Util.MANUFACTURER) || "Xiaomi".equals(Util.MANUFACTURER));
    }

    private static int getMaxSupportedChannelCountForPassthrough(int encoding, int sampleRate) {
        if (Util.SDK_INT >= 29) {
            return Api29.getMaxSupportedChannelCountForPassthrough(encoding, sampleRate);
        }
        return (Integer)Assertions.checkNotNull((Object)((Integer)ALL_SURROUND_ENCODINGS_AND_MAX_CHANNELS.getOrDefault((Object)encoding, (Object)0)));
    }

    private static int getChannelConfigForPassthrough(int channelCount) {
        if (Util.SDK_INT <= 28) {
            if (channelCount == 7) {
                channelCount = 8;
            } else if (channelCount == 3 || channelCount == 4 || channelCount == 5) {
                channelCount = 6;
            }
        }
        if (Util.SDK_INT <= 26 && "fugu".equals(Util.DEVICE) && channelCount == 1) {
            channelCount = 2;
        }
        return Util.getAudioTrackChannelConfig((int)channelCount);
    }

    @RequiresApi(value=29)
    private static final class Api29 {
        private static final AudioAttributes DEFAULT_AUDIO_ATTRIBUTES = new AudioAttributes.Builder().setUsage(1).setContentType(3).setFlags(0).build();

        private Api29() {
        }

        @DoNotInline
        public static ImmutableList<Integer> getDirectPlaybackSupportedEncodings() {
            ImmutableList.Builder supportedEncodingsListBuilder = ImmutableList.builder();
            UnmodifiableIterator unmodifiableIterator = ALL_SURROUND_ENCODINGS_AND_MAX_CHANNELS.keySet().iterator();
            while (unmodifiableIterator.hasNext()) {
                int encoding = (Integer)unmodifiableIterator.next();
                if (Util.SDK_INT < 34 && encoding == 30 || !AudioTrack.isDirectPlaybackSupported((AudioFormat)new AudioFormat.Builder().setChannelMask(12).setEncoding(encoding).setSampleRate(48000).build(), (AudioAttributes)DEFAULT_AUDIO_ATTRIBUTES)) continue;
                supportedEncodingsListBuilder.add((Object)encoding);
            }
            supportedEncodingsListBuilder.add((Object)2);
            return supportedEncodingsListBuilder.build();
        }

        @DoNotInline
        public static int getMaxSupportedChannelCountForPassthrough(int encoding, int sampleRate) {
            for (int channelCount = 10; channelCount > 0; --channelCount) {
                AudioFormat audioFormat = new AudioFormat.Builder().setEncoding(encoding).setSampleRate(sampleRate).setChannelMask(Util.getAudioTrackChannelConfig((int)channelCount)).build();
                if (!AudioTrack.isDirectPlaybackSupported((AudioFormat)audioFormat, (AudioAttributes)DEFAULT_AUDIO_ATTRIBUTES)) continue;
                return channelCount;
            }
            return 0;
        }
    }

    @RequiresApi(value=23)
    private static final class Api23 {
        private Api23() {
        }

        @DoNotInline
        public static final boolean isBluetoothConnected(Context context) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            AudioDeviceInfo[] audioDeviceInfos = ((AudioManager)Assertions.checkNotNull((Object)audioManager)).getDevices(2);
            ImmutableSet<Integer> allBluetoothDeviceTypesSet = Api23.getAllBluetoothDeviceTypes();
            for (int i = 0; i < audioDeviceInfos.length; ++i) {
                if (!allBluetoothDeviceTypesSet.contains((Object)audioDeviceInfos[i].getType())) continue;
                return true;
            }
            return false;
        }

        @DoNotInline
        private static final ImmutableSet<Integer> getAllBluetoothDeviceTypes() {
            ImmutableSet.Builder allBluetoothDeviceTypes = new ImmutableSet.Builder().add((Object[])new Integer[]{8, 7});
            if (Util.SDK_INT >= 31) {
                allBluetoothDeviceTypes.add((Object[])new Integer[]{26, 27});
            }
            if (Util.SDK_INT >= 33) {
                allBluetoothDeviceTypes.add((Object)30);
            }
            return allBluetoothDeviceTypes.build();
        }
    }
}

