/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360;

import com.twobigears.audio360.Audio360JNI;
import com.twobigears.audio360.AudioSettings;
import com.twobigears.audio360.Experimental;
import com.twobigears.audio360.MemorySettings;
import com.twobigears.audio360.PlatformSettings;
import com.twobigears.audio360.ThreadSettings;
import com.twobigears.audio360.VoiceManagerSettings;

public class EngineInitSettings {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected EngineInitSettings(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(EngineInitSettings obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                Audio360JNI.delete_EngineInitSettings(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setAudioSettings(AudioSettings value) {
        Audio360JNI.EngineInitSettings_audioSettings_set(this.swigCPtr, this, AudioSettings.getCPtr(value), value);
    }

    public AudioSettings getAudioSettings() {
        long cPtr = Audio360JNI.EngineInitSettings_audioSettings_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new AudioSettings(cPtr, false);
    }

    public void setMemorySettings(MemorySettings value) {
        Audio360JNI.EngineInitSettings_memorySettings_set(this.swigCPtr, this, MemorySettings.getCPtr(value), value);
    }

    public MemorySettings getMemorySettings() {
        long cPtr = Audio360JNI.EngineInitSettings_memorySettings_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new MemorySettings(cPtr, false);
    }

    public void setPlatformSettings(PlatformSettings value) {
        Audio360JNI.EngineInitSettings_platformSettings_set(this.swigCPtr, this, PlatformSettings.getCPtr(value), value);
    }

    public PlatformSettings getPlatformSettings() {
        long cPtr = Audio360JNI.EngineInitSettings_platformSettings_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new PlatformSettings(cPtr, false);
    }

    public void setThreads(ThreadSettings value) {
        Audio360JNI.EngineInitSettings_threads_set(this.swigCPtr, this, ThreadSettings.getCPtr(value), value);
    }

    public ThreadSettings getThreads() {
        long cPtr = Audio360JNI.EngineInitSettings_threads_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new ThreadSettings(cPtr, false);
    }

    public void setExperimental(Experimental value) {
        Audio360JNI.EngineInitSettings_experimental_set(this.swigCPtr, this, Experimental.getCPtr(value), value);
    }

    public Experimental getExperimental() {
        long cPtr = Audio360JNI.EngineInitSettings_experimental_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new Experimental(cPtr, false);
    }

    public void setVoiceManagerSettings(VoiceManagerSettings value) {
        Audio360JNI.EngineInitSettings_voiceManagerSettings_set(this.swigCPtr, this, VoiceManagerSettings.getCPtr(value), value);
    }

    public VoiceManagerSettings getVoiceManagerSettings() {
        long cPtr = Audio360JNI.EngineInitSettings_voiceManagerSettings_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new VoiceManagerSettings(cPtr, false);
    }

    public EngineInitSettings() {
        this(Audio360JNI.new_EngineInitSettings(), true);
    }
}

