/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360exo2;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.AuxEffectInfo;
import androidx.media3.common.Format;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.audio.AudioSink;
import com.twobigears.audio360.Audio360;
import com.twobigears.audio360.ChannelMap;
import com.twobigears.audio360.PlayState;
import com.twobigears.audio360.SpatDecoderQueue;
import java.nio.ByteBuffer;

public class Audio360Sink
implements AudioSink {
    private static final String TAG = "Audio360Sink";
    private static final int SAMPLE_RATE = 48000;
    private static final int NUM_BITS = 16;
    private static final int NUM_BYTES_PER_SAMPLE = 2;
    private static final int MAX_CHANNELS = 18;
    private static final int MAX_PLAYHEAD_OFFSET_COUNT = 10;
    private static final int MIN_PLAYHEAD_OFFSET_SAMPLE_INTERVAL_US = 30000;
    private static final int START_NOT_SET = 0;
    private static final int START_IN_SYNC = 1;
    private static final int START_NEED_SYNC = 2;
    private SpatDecoderQueue spat;
    private ChannelMap channelMap;
    private int numChannels;
    private long startMediaTimeUs;
    private int syncState;
    private long submittedPcmBytes;
    @Nullable
    private AudioSink.Listener listener;
    private long latencyUs;
    private int nextPlayheadOffsetIndex;
    private int playheadOffsetCount;
    private long smoothedPlayheadOffsetUs;
    private long lastPlayheadSampleTimeUs;
    private final long[] playheadOffsets;

    public Audio360Sink(SpatDecoderQueue spatDecoderQueue, ChannelMap map) {
        this(spatDecoderQueue, map, 0.0);
    }

    public Audio360Sink(SpatDecoderQueue spatDecoderQueue, ChannelMap map, double outputLatencyMs) {
        this.spat = spatDecoderQueue;
        this.channelMap = map;
        this.startMediaTimeUs = 0L;
        this.syncState = 0;
        this.playheadOffsets = new long[10];
        this.latencyUs = this.msToUs(outputLatencyMs);
    }

    public void configure(Format inputFormat, int specifiedBufferSize, @Nullable int[] outputChannels) throws AudioSink.ConfigurationException {
        if (inputFormat.pcmEncoding != 2) {
            throw new AudioSink.ConfigurationException("Incompatible bit depth", inputFormat);
        }
        if (inputFormat.sampleRate != 48000) {
            throw new AudioSink.ConfigurationException("Incompatible sample rate", inputFormat);
        }
        int channels_for_map = Audio360.getNumChannelsForMap((ChannelMap)this.channelMap);
        if (channels_for_map != inputFormat.channelCount) {
            throw new AudioSink.ConfigurationException("Incorrect number of channels for defined ChannelMap. The stream has " + inputFormat.channelCount + " channels, expected " + channels_for_map + " channels.", inputFormat);
        }
        this.numChannels = inputFormat.channelCount;
        this.reset();
    }

    public void flush() {
        this.reset();
    }

    public void experimentalFlushWithoutAudioTrackRelease() {
    }

    public void reset() {
        this.spat.flushQueue();
        this.startMediaTimeUs = 0L;
        this.syncState = 0;
        this.submittedPcmBytes = 0L;
        this.resetClockParams();
    }

    public boolean handleBuffer(ByteBuffer buffer, long presentationTimeUs, int encodedAccessUnitCount) throws AudioSink.InitializationException, AudioSink.WriteException {
        if (!buffer.hasRemaining()) {
            return true;
        }
        if (this.syncState == 0) {
            this.startMediaTimeUs = Math.max(0L, presentationTimeUs);
            this.syncState = 1;
        } else {
            long expectedPresentationTimeUs = this.startMediaTimeUs + this.audioSamplesToUs(this.getSubmittedFrames());
            if (this.syncState == 1 && Math.abs(expectedPresentationTimeUs - presentationTimeUs) > 200000L) {
                Log.e((String)TAG, (String)("Discontinuity detected [expected " + expectedPresentationTimeUs + ", got " + presentationTimeUs + "]"));
                this.syncState = 2;
            }
            if (this.syncState == 2) {
                this.startMediaTimeUs += presentationTimeUs - expectedPresentationTimeUs;
                this.syncState = 1;
                if (this.listener != null) {
                    this.listener.onPositionDiscontinuity();
                }
            }
        }
        int num_samples = buffer.remaining() / 2;
        if (this.spat.getFreeSpaceInQueue(this.channelMap) >= num_samples) {
            this.submittedPcmBytes += (long)buffer.remaining();
            this.spat.enqueueDataInt16(buffer, num_samples, this.channelMap);
            return true;
        }
        return false;
    }

    public void play() {
        this.spat.play();
    }

    public void pause() {
        this.spat.pause();
        this.resetClockParams();
    }

    public void setVolume(float volume) {
        this.spat.setVolume(volume, 0.0f);
    }

    public long getCurrentPositionUs(boolean sourceEnded) {
        if (!this.hasCurrentPositionUs()) {
            return Long.MIN_VALUE;
        }
        if (this.spat.getPlayState() == PlayState.PLAYING) {
            this.maybeInterpolateClock();
        }
        long systemClockUs = System.nanoTime() / 1000L;
        long positionUs = this.playheadOffsetCount == 0 ? this.getSpatDequeuedInUs() : systemClockUs + this.smoothedPlayheadOffsetUs;
        if (!sourceEnded) {
            positionUs -= this.latencyUs;
        }
        return this.startMediaTimeUs + positionUs;
    }

    public void handleDiscontinuity() {
        if (this.syncState == 1) {
            this.syncState = 2;
        }
    }

    public void playToEndOfStream() throws AudioSink.WriteException {
        this.spat.setEndOfStream(true);
    }

    public boolean isEnded() {
        return this.spat.getEndOfStreamStatus() && !this.hasPendingData();
    }

    public boolean hasPendingData() {
        return this.spat.getFreeSpaceInQueue(this.channelMap) != this.spat.getQueueSize(this.channelMap);
    }

    public void setListener(AudioSink.Listener listener) {
        this.listener = listener;
    }

    public boolean supportsFormat(Format format) {
        return this.getFormatSupport(format) != 0;
    }

    public int getFormatSupport(Format format) {
        boolean bSupported = format.channelCount <= 18 && Util.isEncodingLinearPcm((int)format.pcmEncoding);
        return bSupported ? 2 : 0;
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
    }

    public PlaybackParameters getPlaybackParameters() {
        return PlaybackParameters.DEFAULT;
    }

    public void setSkipSilenceEnabled(boolean skipSilenceEnabled) {
    }

    public boolean getSkipSilenceEnabled() {
        return false;
    }

    public void setAudioAttributes(AudioAttributes audioAttributes) {
    }

    @Nullable
    public AudioAttributes getAudioAttributes() {
        return null;
    }

    public void setAudioSessionId(int audioSessionId) {
    }

    public void setAuxEffectInfo(AuxEffectInfo auxEffectInfo) {
    }

    public void enableTunnelingV21() {
    }

    public void disableTunneling() {
    }

    public void setChannelMap(ChannelMap map) {
        this.channelMap = map;
    }

    public ChannelMap getChannelMap() {
        return this.channelMap;
    }

    public int getNumDecoderChannels() {
        return this.numChannels;
    }

    private long audioSamplesToUs(long samples) {
        return samples * 1000000L / 48000L;
    }

    private long msToUs(double ms) {
        return (long)(ms * 1000.0);
    }

    private long getSubmittedFrames() {
        return this.submittedPcmBytes / (long)this.numChannels / 2L;
    }

    private boolean hasCurrentPositionUs() {
        return this.syncState != 0;
    }

    private long getSpatDequeuedInUs() {
        long samples = this.spat.getNumSamplesDequeuedPerChannel().longValue();
        return this.audioSamplesToUs(samples);
    }

    private void maybeInterpolateClock() {
        long playbackPositionUs = this.getSpatDequeuedInUs();
        if (playbackPositionUs == 0L) {
            return;
        }
        long systemClockUs = System.nanoTime() / 1000L;
        if (systemClockUs - this.lastPlayheadSampleTimeUs >= 30000L) {
            this.playheadOffsets[this.nextPlayheadOffsetIndex] = playbackPositionUs - systemClockUs;
            this.nextPlayheadOffsetIndex = (this.nextPlayheadOffsetIndex + 1) % 10;
            if (this.playheadOffsetCount < 10) {
                ++this.playheadOffsetCount;
            }
            this.lastPlayheadSampleTimeUs = systemClockUs;
            this.smoothedPlayheadOffsetUs = 0L;
            for (int i = 0; i < this.playheadOffsetCount; ++i) {
                this.smoothedPlayheadOffsetUs += this.playheadOffsets[i] / (long)this.playheadOffsetCount;
            }
        }
    }

    private void resetClockParams() {
        this.smoothedPlayheadOffsetUs = 0L;
        this.playheadOffsetCount = 0;
        this.nextPlayheadOffsetIndex = 0;
        this.lastPlayheadSampleTimeUs = 0L;
    }
}

