/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.analytics;

import android.util.Base64;
import androidx.annotation.Nullable;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import androidx.media3.exoplayer.analytics.PlaybackSessionManager;
import androidx.media3.exoplayer.source.MediaSource;
import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class DefaultPlaybackSessionManager
implements PlaybackSessionManager {
    public static final Supplier<String> DEFAULT_SESSION_ID_GENERATOR = DefaultPlaybackSessionManager::generateDefaultSessionId;
    private static final Random RANDOM = new Random();
    private static final int SESSION_ID_LENGTH = 12;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private final HashMap<String, SessionDescriptor> sessions;
    private final Supplier<String> sessionIdGenerator;
    private @MonotonicNonNull PlaybackSessionManager.Listener listener;
    private Timeline currentTimeline;
    @Nullable
    private String currentSessionId;

    public DefaultPlaybackSessionManager() {
        this(DEFAULT_SESSION_ID_GENERATOR);
    }

    public DefaultPlaybackSessionManager(Supplier<String> sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        this.sessions = new HashMap();
        this.currentTimeline = Timeline.EMPTY;
    }

    @Override
    public void setListener(PlaybackSessionManager.Listener listener) {
        this.listener = listener;
    }

    @Override
    public synchronized String getSessionForMediaPeriodId(Timeline timeline, MediaSource.MediaPeriodId mediaPeriodId) {
        int windowIndex = timeline.getPeriodByUid((Object)mediaPeriodId.periodUid, (Timeline.Period)this.period).windowIndex;
        return this.getOrAddSession(windowIndex, mediaPeriodId).sessionId;
    }

    @Override
    public synchronized boolean belongsToSession(AnalyticsListener.EventTime eventTime, String sessionId) {
        SessionDescriptor sessionDescriptor = this.sessions.get(sessionId);
        if (sessionDescriptor == null) {
            return false;
        }
        sessionDescriptor.maybeSetWindowSequenceNumber(eventTime.windowIndex, eventTime.mediaPeriodId);
        return sessionDescriptor.belongsToSession(eventTime.windowIndex, eventTime.mediaPeriodId);
    }

    @Override
    public synchronized void updateSessions(AnalyticsListener.EventTime eventTime) {
        MediaSource.MediaPeriodId contentMediaPeriodId;
        SessionDescriptor contentSession;
        Assertions.checkNotNull((Object)this.listener);
        if (eventTime.timeline.isEmpty()) {
            return;
        }
        SessionDescriptor currentSession = this.sessions.get(this.currentSessionId);
        if (eventTime.mediaPeriodId != null && currentSession != null) {
            boolean isAlreadyFinished;
            boolean bl = currentSession.windowSequenceNumber == -1L ? currentSession.windowIndex != eventTime.windowIndex : (isAlreadyFinished = eventTime.mediaPeriodId.windowSequenceNumber < currentSession.windowSequenceNumber);
            if (isAlreadyFinished) {
                return;
            }
        }
        SessionDescriptor eventSession = this.getOrAddSession(eventTime.windowIndex, eventTime.mediaPeriodId);
        if (this.currentSessionId == null) {
            this.currentSessionId = eventSession.sessionId;
        }
        if (eventTime.mediaPeriodId != null && eventTime.mediaPeriodId.isAd() && !(contentSession = this.getOrAddSession(eventTime.windowIndex, contentMediaPeriodId = new MediaSource.MediaPeriodId(eventTime.mediaPeriodId.periodUid, eventTime.mediaPeriodId.windowSequenceNumber, eventTime.mediaPeriodId.adGroupIndex))).isCreated) {
            contentSession.isCreated = true;
            eventTime.timeline.getPeriodByUid(eventTime.mediaPeriodId.periodUid, this.period);
            long adGroupPositionMs = Util.usToMs((long)this.period.getAdGroupTimeUs(eventTime.mediaPeriodId.adGroupIndex)) + this.period.getPositionInWindowMs();
            adGroupPositionMs = Math.max(0L, adGroupPositionMs);
            AnalyticsListener.EventTime eventTimeForContent = new AnalyticsListener.EventTime(eventTime.realtimeMs, eventTime.timeline, eventTime.windowIndex, contentMediaPeriodId, adGroupPositionMs, eventTime.currentTimeline, eventTime.currentWindowIndex, eventTime.currentMediaPeriodId, eventTime.currentPlaybackPositionMs, eventTime.totalBufferedDurationMs);
            this.listener.onSessionCreated(eventTimeForContent, contentSession.sessionId);
        }
        if (!eventSession.isCreated) {
            eventSession.isCreated = true;
            this.listener.onSessionCreated(eventTime, eventSession.sessionId);
        }
        if (eventSession.sessionId.equals(this.currentSessionId) && !eventSession.isActive) {
            eventSession.isActive = true;
            this.listener.onSessionActive(eventTime, eventSession.sessionId);
        }
    }

    @Override
    public synchronized void updateSessionsWithTimelineChange(AnalyticsListener.EventTime eventTime) {
        Assertions.checkNotNull((Object)this.listener);
        Timeline previousTimeline = this.currentTimeline;
        this.currentTimeline = eventTime.timeline;
        Iterator<SessionDescriptor> iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            SessionDescriptor session = iterator.next();
            if (session.tryResolvingToNewTimeline(previousTimeline, this.currentTimeline) && !session.isFinishedAtEventTime(eventTime)) continue;
            iterator.remove();
            if (!session.isCreated) continue;
            if (session.sessionId.equals(this.currentSessionId)) {
                this.currentSessionId = null;
            }
            this.listener.onSessionFinished(eventTime, session.sessionId, false);
        }
        this.updateCurrentSession(eventTime);
    }

    @Override
    public synchronized void updateSessionsWithDiscontinuity(AnalyticsListener.EventTime eventTime, int reason) {
        Assertions.checkNotNull((Object)this.listener);
        boolean hasAutomaticTransition = reason == 0;
        Iterator<SessionDescriptor> iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            boolean isAutomaticTransition;
            SessionDescriptor session = iterator.next();
            if (!session.isFinishedAtEventTime(eventTime)) continue;
            iterator.remove();
            if (!session.isCreated) continue;
            boolean isRemovingCurrentSession = session.sessionId.equals(this.currentSessionId);
            boolean bl = isAutomaticTransition = hasAutomaticTransition && isRemovingCurrentSession && session.isActive;
            if (isRemovingCurrentSession) {
                this.currentSessionId = null;
            }
            this.listener.onSessionFinished(eventTime, session.sessionId, isAutomaticTransition);
        }
        this.updateCurrentSession(eventTime);
    }

    @Override
    @Nullable
    public synchronized String getActiveSessionId() {
        return this.currentSessionId;
    }

    @Override
    public synchronized void finishAllSessions(AnalyticsListener.EventTime eventTime) {
        this.currentSessionId = null;
        Iterator<SessionDescriptor> iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            SessionDescriptor session = iterator.next();
            iterator.remove();
            if (!session.isCreated || this.listener == null) continue;
            this.listener.onSessionFinished(eventTime, session.sessionId, false);
        }
    }

    @RequiresNonNull(value={"listener"})
    private void updateCurrentSession(AnalyticsListener.EventTime eventTime) {
        if (eventTime.timeline.isEmpty()) {
            this.currentSessionId = null;
            return;
        }
        SessionDescriptor previousSessionDescriptor = this.sessions.get(this.currentSessionId);
        SessionDescriptor currentSessionDescriptor = this.getOrAddSession(eventTime.windowIndex, eventTime.mediaPeriodId);
        this.currentSessionId = currentSessionDescriptor.sessionId;
        this.updateSessions(eventTime);
        if (eventTime.mediaPeriodId != null && eventTime.mediaPeriodId.isAd() && (previousSessionDescriptor == null || previousSessionDescriptor.windowSequenceNumber != eventTime.mediaPeriodId.windowSequenceNumber || previousSessionDescriptor.adMediaPeriodId == null || ((SessionDescriptor)previousSessionDescriptor).adMediaPeriodId.adGroupIndex != eventTime.mediaPeriodId.adGroupIndex || ((SessionDescriptor)previousSessionDescriptor).adMediaPeriodId.adIndexInAdGroup != eventTime.mediaPeriodId.adIndexInAdGroup)) {
            MediaSource.MediaPeriodId contentMediaPeriodId = new MediaSource.MediaPeriodId(eventTime.mediaPeriodId.periodUid, eventTime.mediaPeriodId.windowSequenceNumber);
            SessionDescriptor contentSession = this.getOrAddSession(eventTime.windowIndex, contentMediaPeriodId);
            this.listener.onAdPlaybackStarted(eventTime, contentSession.sessionId, currentSessionDescriptor.sessionId);
        }
    }

    private SessionDescriptor getOrAddSession(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        SessionDescriptor bestMatch = null;
        long bestMatchWindowSequenceNumber = Long.MAX_VALUE;
        for (SessionDescriptor sessionDescriptor : this.sessions.values()) {
            sessionDescriptor.maybeSetWindowSequenceNumber(windowIndex, mediaPeriodId);
            if (!sessionDescriptor.belongsToSession(windowIndex, mediaPeriodId)) continue;
            long windowSequenceNumber = sessionDescriptor.windowSequenceNumber;
            if (windowSequenceNumber == -1L || windowSequenceNumber < bestMatchWindowSequenceNumber) {
                bestMatch = sessionDescriptor;
                bestMatchWindowSequenceNumber = windowSequenceNumber;
                continue;
            }
            if (windowSequenceNumber != bestMatchWindowSequenceNumber || ((SessionDescriptor)Util.castNonNull((Object)bestMatch)).adMediaPeriodId == null || sessionDescriptor.adMediaPeriodId == null) continue;
            bestMatch = sessionDescriptor;
        }
        if (bestMatch == null) {
            String sessionId = (String)this.sessionIdGenerator.get();
            bestMatch = new SessionDescriptor(sessionId, windowIndex, mediaPeriodId);
            this.sessions.put(sessionId, bestMatch);
        }
        return bestMatch;
    }

    private static String generateDefaultSessionId() {
        byte[] randomBytes = new byte[12];
        RANDOM.nextBytes(randomBytes);
        return Base64.encodeToString((byte[])randomBytes, (int)10);
    }

    private final class SessionDescriptor {
        private final String sessionId;
        private int windowIndex;
        private long windowSequenceNumber;
        private  @MonotonicNonNull MediaSource.MediaPeriodId adMediaPeriodId;
        private boolean isCreated;
        private boolean isActive;

        public SessionDescriptor(String sessionId, @Nullable int windowIndex, MediaSource.MediaPeriodId mediaPeriodId) {
            this.sessionId = sessionId;
            this.windowIndex = windowIndex;
            long l = this.windowSequenceNumber = mediaPeriodId == null ? -1L : mediaPeriodId.windowSequenceNumber;
            if (mediaPeriodId != null && mediaPeriodId.isAd()) {
                this.adMediaPeriodId = mediaPeriodId;
            }
        }

        public boolean tryResolvingToNewTimeline(Timeline oldTimeline, Timeline newTimeline) {
            this.windowIndex = this.resolveWindowIndexToNewTimeline(oldTimeline, newTimeline, this.windowIndex);
            if (this.windowIndex == -1) {
                return false;
            }
            if (this.adMediaPeriodId == null) {
                return true;
            }
            int newPeriodIndex = newTimeline.getIndexOfPeriod(this.adMediaPeriodId.periodUid);
            return newPeriodIndex != -1;
        }

        public boolean belongsToSession(int eventWindowIndex, @Nullable MediaSource.MediaPeriodId eventMediaPeriodId) {
            if (eventMediaPeriodId == null) {
                return eventWindowIndex == this.windowIndex;
            }
            if (this.adMediaPeriodId == null) {
                return !eventMediaPeriodId.isAd() && eventMediaPeriodId.windowSequenceNumber == this.windowSequenceNumber;
            }
            return eventMediaPeriodId.windowSequenceNumber == this.adMediaPeriodId.windowSequenceNumber && eventMediaPeriodId.adGroupIndex == this.adMediaPeriodId.adGroupIndex && eventMediaPeriodId.adIndexInAdGroup == this.adMediaPeriodId.adIndexInAdGroup;
        }

        public void maybeSetWindowSequenceNumber(int eventWindowIndex, @Nullable MediaSource.MediaPeriodId eventMediaPeriodId) {
            if (this.windowSequenceNumber == -1L && eventWindowIndex == this.windowIndex && eventMediaPeriodId != null) {
                this.windowSequenceNumber = eventMediaPeriodId.windowSequenceNumber;
            }
        }

        public boolean isFinishedAtEventTime(AnalyticsListener.EventTime eventTime) {
            if (eventTime.mediaPeriodId == null) {
                return this.windowIndex != eventTime.windowIndex;
            }
            if (this.windowSequenceNumber == -1L) {
                return false;
            }
            if (eventTime.mediaPeriodId.windowSequenceNumber > this.windowSequenceNumber) {
                return true;
            }
            if (this.adMediaPeriodId == null) {
                return false;
            }
            int eventPeriodIndex = eventTime.timeline.getIndexOfPeriod(eventTime.mediaPeriodId.periodUid);
            int adPeriodIndex = eventTime.timeline.getIndexOfPeriod(this.adMediaPeriodId.periodUid);
            if (eventTime.mediaPeriodId.windowSequenceNumber < this.adMediaPeriodId.windowSequenceNumber || eventPeriodIndex < adPeriodIndex) {
                return false;
            }
            if (eventPeriodIndex > adPeriodIndex) {
                return true;
            }
            if (eventTime.mediaPeriodId.isAd()) {
                int eventAdGroup = eventTime.mediaPeriodId.adGroupIndex;
                int eventAdIndex = eventTime.mediaPeriodId.adIndexInAdGroup;
                return eventAdGroup > this.adMediaPeriodId.adGroupIndex || eventAdGroup == this.adMediaPeriodId.adGroupIndex && eventAdIndex > this.adMediaPeriodId.adIndexInAdGroup;
            }
            return eventTime.mediaPeriodId.nextAdGroupIndex == -1 || eventTime.mediaPeriodId.nextAdGroupIndex > this.adMediaPeriodId.adGroupIndex;
        }

        private int resolveWindowIndexToNewTimeline(Timeline oldTimeline, Timeline newTimeline, int windowIndex) {
            if (windowIndex >= oldTimeline.getWindowCount()) {
                return windowIndex < newTimeline.getWindowCount() ? windowIndex : -1;
            }
            oldTimeline.getWindow(windowIndex, DefaultPlaybackSessionManager.this.window);
            for (int periodIndex = ((DefaultPlaybackSessionManager)DefaultPlaybackSessionManager.this).window.firstPeriodIndex; periodIndex <= ((DefaultPlaybackSessionManager)DefaultPlaybackSessionManager.this).window.lastPeriodIndex; ++periodIndex) {
                Object periodUid = oldTimeline.getUidOfPeriod(periodIndex);
                int newPeriodIndex = newTimeline.getIndexOfPeriod(periodUid);
                if (newPeriodIndex == -1) continue;
                return newTimeline.getPeriod((int)newPeriodIndex, (Timeline.Period)((DefaultPlaybackSessionManager)DefaultPlaybackSessionManager.this).period).windowIndex;
            }
            return -1;
        }
    }
}

