/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.offline;

import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.PriorityTaskManager;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.RunnableFutureTask;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.cache.CacheDataSource;
import androidx.media3.datasource.cache.CacheWriter;
import androidx.media3.exoplayer.offline.Downloader;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class ProgressiveDownloader
implements Downloader {
    private final Executor executor;
    private final DataSpec dataSpec;
    private final CacheDataSource dataSource;
    private final CacheWriter cacheWriter;
    @Nullable
    private final PriorityTaskManager priorityTaskManager;
    @Nullable
    private Downloader.ProgressListener progressListener;
    private volatile @MonotonicNonNull RunnableFutureTask<Void, IOException> downloadRunnable;
    private volatile boolean isCanceled;

    public ProgressiveDownloader(MediaItem mediaItem, CacheDataSource.Factory cacheDataSourceFactory) {
        this(mediaItem, cacheDataSourceFactory, Runnable::run);
    }

    public ProgressiveDownloader(MediaItem mediaItem, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this.executor = (Executor)Assertions.checkNotNull((Object)executor);
        Assertions.checkNotNull((Object)mediaItem.localConfiguration);
        this.dataSpec = new DataSpec.Builder().setUri(mediaItem.localConfiguration.uri).setKey(mediaItem.localConfiguration.customCacheKey).setFlags(4).build();
        this.dataSource = cacheDataSourceFactory.createDataSourceForDownloading();
        CacheWriter.ProgressListener progressListener = this::onProgress;
        this.cacheWriter = new CacheWriter(this.dataSource, this.dataSpec, null, progressListener);
        this.priorityTaskManager = cacheDataSourceFactory.getUpstreamPriorityTaskManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(@Nullable Downloader.ProgressListener progressListener) throws IOException, InterruptedException {
        this.progressListener = progressListener;
        if (this.priorityTaskManager != null) {
            this.priorityTaskManager.add(-1000);
        }
        try {
            boolean finished = false;
            while (!finished && !this.isCanceled) {
                this.downloadRunnable = new RunnableFutureTask<Void, IOException>(){

                    protected Void doWork() throws IOException {
                        ProgressiveDownloader.this.cacheWriter.cache();
                        return null;
                    }

                    protected void cancelWork() {
                        ProgressiveDownloader.this.cacheWriter.cancel();
                    }
                };
                if (this.priorityTaskManager != null) {
                    this.priorityTaskManager.proceed(-1000);
                }
                this.executor.execute((Runnable)this.downloadRunnable);
                try {
                    this.downloadRunnable.get();
                    finished = true;
                }
                catch (ExecutionException e) {
                    Throwable cause = (Throwable)Assertions.checkNotNull((Object)e.getCause());
                    if (cause instanceof PriorityTaskManager.PriorityTooLowException) continue;
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    Util.sneakyThrow((Throwable)cause);
                }
            }
        }
        finally {
            ((RunnableFutureTask)Assertions.checkNotNull(this.downloadRunnable)).blockUntilFinished();
            if (this.priorityTaskManager != null) {
                this.priorityTaskManager.remove(-1000);
            }
        }
    }

    @Override
    public void cancel() {
        this.isCanceled = true;
        RunnableFutureTask<Void, IOException> downloadRunnable = this.downloadRunnable;
        if (downloadRunnable != null) {
            downloadRunnable.cancel(true);
        }
    }

    @Override
    public void remove() {
        this.dataSource.getCache().removeResource(this.dataSource.getCacheKeyFactory().buildCacheKey(this.dataSpec));
    }

    private void onProgress(long contentLength, long bytesCached, long newBytesCached) {
        if (this.progressListener == null) {
            return;
        }
        float percentDownloaded = contentLength == -1L || contentLength == 0L ? -1.0f : (float)bytesCached * 100.0f / (float)contentLength;
        this.progressListener.onProgress(contentLength, bytesCached, percentDownloaded);
    }
}

