/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source.chunk;

import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.source.chunk.MediaChunkIterator;
import java.util.NoSuchElementException;

@UnstableApi
public abstract class BaseMediaChunkIterator
implements MediaChunkIterator {
    private final long fromIndex;
    private final long toIndex;
    private long currentIndex;

    public BaseMediaChunkIterator(long fromIndex, long toIndex) {
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.reset();
    }

    @Override
    public boolean isEnded() {
        return this.currentIndex > this.toIndex;
    }

    @Override
    public boolean next() {
        ++this.currentIndex;
        return !this.isEnded();
    }

    @Override
    public void reset() {
        this.currentIndex = this.fromIndex - 1L;
    }

    protected final void checkInBounds() {
        if (this.currentIndex < this.fromIndex || this.currentIndex > this.toIndex) {
            throw new NoSuchElementException();
        }
    }

    protected final long getCurrentIndex() {
        return this.currentIndex;
    }
}

