/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import androidx.annotation.Nullable;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.ExtractorInput;
import java.io.EOFException;
import java.io.IOException;
import org.checkerframework.dataflow.qual.Pure;

@UnstableApi
public final class ExtractorUtil {
    @Pure
    public static void checkContainerInput(boolean expression, @Nullable String message) throws ParserException {
        if (!expression) {
            throw ParserException.createForMalformedContainer((String)message, null);
        }
    }

    public static int peekToLength(ExtractorInput input, byte[] target, int offset, int length) throws IOException {
        int totalBytesPeeked;
        int bytesPeeked;
        for (totalBytesPeeked = 0; totalBytesPeeked < length && (bytesPeeked = input.peek(target, offset + totalBytesPeeked, length - totalBytesPeeked)) != -1; totalBytesPeeked += bytesPeeked) {
        }
        return totalBytesPeeked;
    }

    public static boolean readFullyQuietly(ExtractorInput input, byte[] output, int offset, int length) throws IOException {
        try {
            input.readFully(output, offset, length);
        }
        catch (EOFException e) {
            return false;
        }
        return true;
    }

    public static boolean skipFullyQuietly(ExtractorInput input, int length) throws IOException {
        try {
            input.skipFully(length);
        }
        catch (EOFException e) {
            return false;
        }
        return true;
    }

    public static boolean peekFullyQuietly(ExtractorInput input, byte[] output, int offset, int length, boolean allowEndOfInput) throws IOException {
        try {
            return input.peekFully(output, offset, length, allowEndOfInput);
        }
        catch (EOFException e) {
            if (allowEndOfInput) {
                return false;
            }
            throw e;
        }
    }

    private ExtractorUtil() {
    }
}

